/*
 * Copyright (c)  2000
 * SWsoft  company
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted 
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */

#ifdef _DEBUG

#include "headers.h"

struct CMemAuditor
{
	void* pointer;
	const char* file;
	int line;
	size_t size;
	CMemAuditor(void* p=NULL, const char* f=NULL, int l=0, size_t s=0) : pointer(p), file(f), line(l), size(s) {}
};


CMemAuditor* pointers = NULL;
size_t avail = 0;

const size_t size = 0xfffff;
const size_t elems = size / sizeof(*pointers);

#undef malloc
#undef free
	

void * __cdecl operator new(unsigned int cb, const char *file, int line)
{
	
	if( pointers == NULL )
	{
		pointers = (CMemAuditor*) malloc(size);
		if( pointers == NULL )
		{
			TRACE( "*** new: no pointers array!");
			return NULL;
		}
		ZeroMemory(pointers, size);
	}

	void* ret = malloc(cb);
	if( ret == NULL )
		return NULL;
	
	if( avail < elems )
	{
		pointers[avail++] = CMemAuditor(ret, file, line, cb);
		return ret;
	}

	for( size_t i = 0; i < elems; i++ )
		if( pointers[i].pointer == NULL )
		{
			pointers[i] = CMemAuditor(ret, file, line, cb);
			return ret;
		}

	return ret;
}


void __cdecl operator delete(void * p, const char *, int)
{
	if( p == NULL )
		return;
	
	if( pointers == NULL )
	{
		TRACE( "*** delete: no pointers array!");
		return;
	}

	for( size_t i = 0; i < elems; i++ )
		if( pointers[i].pointer == p )
		{
			free( p );
			pointers[i] = CMemAuditor();
			return;
		}
	
	TRACE( "*** delete: ????");
	free( p );
}

struct aTag
{
   ~aTag()
   {
	if( pointers == NULL )
	{
		TRACE( "*** ~aTag: no pointers array!");
		return;
	}

	for( size_t i = 0; i < elems; i++ )
		if( pointers[i].pointer != NULL )
		{
			TRACE( "*** DELETE: not deleted %ld bytes! File [%s] Line [%d]", pointers[i].size	, pointers[i].file, pointers[i].line );
			TRACE( "*** ( String [%s] )", (char*)pointers[i].pointer );
		}
   }
} a;


#endif