/*
 * Copyright (c)  2000
 * SWsoft  company
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted 
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */

// Purpose: check memory leaks

#pragma once

#if defined (_DEBUG)

#define malloc(cb)	((void*)operator new(cb, __FILE__, __LINE__))
#define free(p)		operator delete (p, __FILE__, __LINE__)

void * __cdecl operator new(unsigned int cb, const char *, int);
void __cdecl operator delete(void * p, const char *, int);

#define VirtualAlloc( p, cb, type, prt) ((type==MEM_RESERVE)?(void*)operator new(cb, __FILE__, __LINE__):p)
#define VirtualFree( p, cb, type) { if( type==MEM_RELEASE ) operator delete( p, __FILE__, __LINE__); }

inline void * __cdecl operator new(unsigned int cb)
		{ return ::operator new(cb, __FILE__, __LINE__); }

inline void __cdecl operator delete(void * p)
        { ::operator delete(p, __FILE__, __LINE__); }

#endif