/*
 * Copyright (c)  2000
 * SWsoft  company
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted 
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */

///////////////////////////////////////////////
// CBufferHolder
///////////////////////////////////////////////

#include "hfiles.h"
#include "headers.h"
#include "bufhold.h"

CBufferHolder::CBufferHolder( int base ) 
{ 
	CLEAR_CONSTRUCT( CBufferHolder );
	if( base > 1024 )
		base = 1024;
	m_nMaxElemsBase = base;	// Base to enlarge
	m_holder = new CBuffer*[ m_nMaxElemsBase ];
	if( m_holder )
		m_nMaxElems		= m_nMaxElemsBase;	// Current size
}


CBufferHolder::~CBufferHolder() 
{
	if( m_holder )
	{
		//for( int i = 0; i < m_nMaxElems; i++ )
		for( int i = 0; i < m_uiFirstFree; i++ )
			if( m_holder[ i ] != NULL )
				delete m_holder[ i ]; 
		delete m_holder;
	}

	if( m_currentRow.m_pszBuf != NULL )
		delete m_currentRow.m_pszBuf;

	if( m_lastRow.m_pszBuf != NULL )
		delete m_lastRow.m_pszBuf;
}


// Get elem at position
HRESULT CBufferHolder::At(int i, CBuffer** ppElem ) 
{
	if( ppElem == NULL )
		return E_INVALIDARG;
	if( m_holder == NULL || i >= m_uiFirstFree )
	{
		*ppElem = NULL;
		return S_FALSE;;
	}
	else
	{
		*ppElem = m_holder[ i ];
		return ( *ppElem != NULL ) ? S_OK : S_FALSE;
	}
}


// Get maximum element number
HRESULT CBufferHolder::GetMaxNumber( int* puiMaxNumber )
{
	 if( puiMaxNumber == NULL )
		 return E_INVALIDARG;
	 *puiMaxNumber = m_uiFirstFree;
	 return S_OK;
}

// Get first free slot
HRESULT CBufferHolder::GetFreeSlotNumber( CBuffer** ppBuffer, int* pnSlot )
{
	// Check args
	if( pnSlot == NULL || ppBuffer == NULL )
		return E_INVALIDARG;

	// set up out parameters for the case if an error appear
	*ppBuffer = NULL;
	
	if( m_uiFirstFree >= m_nMaxElems )
	{
		CBuffer** holder = new CBuffer*[ m_nMaxElems + m_nMaxElemsBase ];
		if( holder == NULL )
			return E_OUTOFMEMORY;
		memcpy( holder, m_holder, m_nMaxElems * sizeof( CBuffer* ) );
		m_nMaxElems += m_nMaxElemsBase;
		delete m_holder;
		m_holder = holder;
	}

	m_holder[ m_uiFirstFree ] = new CBuffer;
	if( m_holder[ m_uiFirstFree ] == NULL )
		return E_OUTOFMEMORY;
	
	*ppBuffer = m_holder[ m_uiFirstFree ];
	*pnSlot = m_uiFirstFree;
	
	m_uiFirstFree++;

	return S_OK;
}
	

//Release slot
HRESULT CBufferHolder::ReleaseSlot(int slot) 
{
	CBuffer* pElem;
	if( At( slot, &pElem ) != S_OK )
		return E_FAIL;

	m_holder[ slot ] = NULL;

	return S_OK;
}