/*
 * Copyright (c)  2000
 * SWsoft  company
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted 
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */

//--------------------------------------------------------------------
// MySQL OLE DB Provider 
// Functionality: minimum
// Release: 0.1
//
// @doc
//
// @module CLASSFAC.H | Class Definitions for CClassFactory and 
// DLL Entry Points
//
//
#ifndef _CLASSFAC_H_
#define _CLASSFAC_H_

// Classes -------------------------------------------------------------------
//----------------------------------------------------------------------------
// @class CClassFactory 
//
class CClassFactory : public IClassFactory2		//@base public | IClassFactory
{
	START_CLASS(); 

	protected: //@access protected
		//@cmember Reference count
		ULONG			m_cRef;
		CLSID			m_CLSID;

		static CLSID	m_createdCLSID;
		HRESULT			StartUp();
		STDMETHODIMP	CreateInstanceHelper(LPUNKNOWN, REFIID, LPVOID *);

	public: // @access public
		//@cmember Constructor
		CClassFactory( REFCLSID refCLSID );
		//@cmember Destructor
		~CClassFactory(void);

		//	IUnknown members
		//@cmember Request an Interface
		STDMETHODIMP			QueryInterface(REFIID, LPVOID *);
		//@cmember Increments the Reference count
		STDMETHODIMP_(ULONG)	AddRef(void);
		//@cmember Decrements the Reference count
		STDMETHODIMP_(ULONG)	Release(void);

		//	IClassFactory members
		//@cmember Instantiates an uninitialized instance of an object
		STDMETHODIMP			CreateInstance(LPUNKNOWN, REFIID, LPVOID *);
	    //@cmember Lock Object so that it can not be unloaded
		STDMETHODIMP			LockServer(BOOL);

        // IClassFactory2 methods.
        STDMETHODIMP         GetLicInfo(LPLICINFO);
        STDMETHODIMP         RequestLicKey(DWORD, BSTR*);
        STDMETHODIMP         CreateInstanceLic(
                               IUnknown*,
                               IUnknown*,
                               REFIID,
                               BSTR,
                               LPVOID*);

	FINISH_CLASS(); 
};

#endif

