/*
 * Copyright (c)  2000
 * SWsoft  company
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted 
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */

//--------------------------------------------------------------------
// MySQL OLE DB Provider 
// Functionality: minimum
// Release: 0.1
//
// @doc
//
// @module COMMAND.H | CCommand base object and contained interface
// definitions
//
//
#ifndef _COMMAND_H_
#define _COMMAND_H_

// For multiply rowsets management
#include	"rwstmgmt.h"

// Forward declarations ------------------------------------------------------

class   CImpICommand;
class   CImpICommandProperties;
class	CImpICommandText;
class	CImpICommandPrepare;
class   CImpICommandWithParameters;
class	CImpISupportErrorInfo;

typedef CImpICommand*				PIMPICOMMAND;
typedef CImpICommandProperties*		PIMPICOMMANDPROPERTIES;
typedef CImpICommandText*			PIMPICOMMANDTEXT;
typedef CImpICommandPrepare*		PIMPICOMMANDPREPARE;
typedef CImpICommandWithParameters*	PIMPICOMMANDWITHPARAMETERS;
typedef CImpISupportErrorInfo*		PIMPISUPPORTERRORINFO;

// Enums ---------------------------------------------------------------------

enum STATES
{
	STATE_INITIAL = 1,
	STATE_UNPREPARED,
	STATE_PREPARED,
	STATE_EXECUTE,
};

// Classes -------------------------------------------------------------------

//----------------------------------------------------------------------------
// @class CDBCommand | Containing class for all interfaces on the DBCommand 
// Object
//
class CCommand : public IUnknown				//@base public | IUnknown
{
	START_CLASS(); 

// contained interfaces are friends
friend class CImpICommand;
friend class CImpICommandText;
friend class CImpICommandPrepare;
friend class CImpICommandWithParameters;
friend class CImpICommandProperties;
friend class CImpICommandConvertType;
friend class CImpIAccessor;
friend class CImpIColumnsInfo;
friend class CImpISupportErrorInfo;

protected: //@access protected
	//@cmember Reference count
	ULONG					m_cRef;						
	//@cmember Command text
	LPOLESTR				m_pwszCommand;
	//@cmember Prepared command text
	LPSTR					m_pszSQL;
	//@cmember Flag: if command text contains parameters
	bool					m_bParameters;
	//Open rowset count
	ULONG					m_cRowsets;
	
	//Command state
	STATES					m_enumState;

    //@member Utility object to manage properties
    PCUTILPROP              m_pUtilProp;
	//@cmember array of accessor ptrs
	LPEXTBUFFER     		m_pExtBufferAccessor;

	//Members for IColumnsInfo

	//@cmember	column count
	ULONG			m_cCols;
	//@cmember	bookmark flag
	bool			m_bBookmark;
	//@cmember	pointer to column info structures
	DBCOLUMNINFO*	m_pColInfo;

	//Interfaces

    //@member contained ICommand
    PIMPICOMMAND				m_pICommand;
	//@member contained ICommandProperties
	PIMPICOMMANDPROPERTIES		m_pICommandProperties;
    //@member contained ICommandText
    PIMPICOMMANDTEXT			m_pICommandText;
    //@member contained ICommandPrepare
    PIMPICOMMANDPREPARE			m_pICommandPrepare;
    //@member contained ICommandWithParameters
    PIMPICOMMANDWITHPARAMETERS	m_pICommandWithParameters;
	//@member contained IConvertType	
	PIMPICONVERTTYPE			m_pIConvertType;
	//@member contained IAccessor
	PIMPIACCESSOR				m_pIAccessor;
	//@member contained IColumnsInfo	
	PIMPICOLUMNSINFO			m_pIColumnsInfo;
	//@member contained ISupportErrorInfo	
	PIMPISUPPORTERRORINFO		m_pISupportErrorInfo;
	
public: //@access public
	//@cmember Constructor		 
	 CCommand(LPUNKNOWN);
	//@cmember Destructor
	~CCommand(void);

	//@cmember Controlling IUnknown
	LPUNKNOWN		m_pUnkOuter;				
	//@mcember parent session object
	PCDBSESSION		m_pDBSession;


	//@cmember Intitialization Routine
	BOOL Init(PCDBSESSION pDBSession);

	//Check command set state
	bool IsTextSet() {return m_pwszCommand != NULL;};
	//Check prepared state
	bool IsPrepared() {return m_enumState >= STATE_PREPARED;};

	void IncrementRowset() {m_cRowsets++;};
	void DecrementRowset() {m_cRowsets--;};

	void SetState(STATES enumState) {m_enumState = enumState;};

	//Prepare command
	HRESULT Prepare(bool bCheckRowsets);
	//Unprepare command
	HRESULT Unprepare();

	//Fill column info array
	HRESULT FillColumnInfo(CRowset *pRowset);
	//Clear column info array 
	HRESULT ClearColumnInfo();


	//	Object's base IUnknown
	//@cmember Request an Interface
	STDMETHODIMP			QueryInterface(REFIID, LPVOID *);
	//@cmember Increments the Reference count
	STDMETHODIMP_(ULONG)	AddRef(void);
	//@cmember Decrements the Reference count
	STDMETHODIMP_(ULONG)	Release(void);

	FINISH_CLASS(); 
};

typedef CCommand *PCCOMMAND;


//----------------------------------------------------------------------------------------
// @class CImpICommand  | contained ICommand class


class CImpICommand : public ICommand      //@base public | ICommand
{
	START_CLASS(); 

private:        //@access private
	DEBUGCODE(ULONG m_cRef);											
	CCommand		*m_pObj;											
	LPUNKNOWN		m_pUnkOuter;

public:         //@access public
	CImpICommand(CCommand *pObj, IUnknown *pUnkOuter)					
	{																	
		CLEAR_CONSTRUCT( CImpICommand );

		DEBUGCODE(m_cRef = 0L);											
		m_pObj		= pObj;												
		m_pUnkOuter	= pUnkOuter;										
	}																	
	
	~CImpICommand()														
	{																	
	}


	STDMETHODIMP_(ULONG)	AddRef(void)									
	{																	
		DEBUGCODE( ++m_cRef );											
		return m_pUnkOuter->AddRef();									
	}
																		
	STDMETHODIMP_(ULONG)	Release(void)									
	{																	
		ASSERT( m_cRef > 0 );											
		DEBUGCODE( --m_cRef );											
		return m_pUnkOuter->Release();									
	}
																		
	STDMETHODIMP			QueryInterface(REFIID riid, LPVOID *ppv)		
	{																	
		return m_pUnkOuter->QueryInterface(riid, ppv);					
	}

   
    // ICommand methods

    //@cmember Cancel
	STDMETHODIMP  Cancel();

    //@cmember Execute
	STDMETHODIMP  Execute(IUnknown*, REFIID, DBPARAMS*, LONG*, IUnknown**);
    
	//@cmember GetDBSession
	STDMETHODIMP  GetDBSession(REFIID, IUnknown**);

protected:
	HRESULT SubstituteParameters(LPSTR* ppszSQL, DBPARAMS* pParams);

	FINISH_CLASS(); 
};


//----------------------------------------------------------------------------------------
// @class CImpICommandText  | contained ICommandText class


class CImpICommandText : public ICommandText      //@base public | ICommandText
{
	START_CLASS(); 

	private:        //@access private
		DEBUGCODE(ULONG m_cRef);											
		CCommand		*m_pObj;											
		LPUNKNOWN		m_pUnkOuter;

	public:         //@access public
		CImpICommandText( CCommand *pObj, IUnknown *pUnkOuter )					
		{																	
			CLEAR_CONSTRUCT( CImpICommandText);
			
			DEBUGCODE(m_cRef = 0L);											
			m_pObj		= pObj;												
			m_pUnkOuter	= pUnkOuter;										
		}																	
		
		~CImpICommandText()														
		{																	
		}


		STDMETHODIMP_(ULONG)	AddRef(void)									
		{																	
			DEBUGCODE( ++m_cRef );											
			return m_pUnkOuter->AddRef();									
		}
																			
		STDMETHODIMP_(ULONG)	Release(void)									
		{																	
			ASSERT( m_cRef > 0 );											
			DEBUGCODE( --m_cRef );											
			return m_pUnkOuter->Release();									
		}
																			
		STDMETHODIMP			QueryInterface(REFIID riid, LPVOID *ppv)		
		{																	
			return m_pUnkOuter->QueryInterface(riid, ppv);					
		}


        // ICommand methods

        //@cmember Cancel
		STDMETHODIMP  Cancel();

        //@cmember Execute
		STDMETHODIMP  Execute
						(
						IUnknown*	pUnkOuter,
						REFIID		riid,	
						DBPARAMS*	pParams,
						LONG*		pcRowsAffected, 
						IUnknown**	ppRowset
						);
        
		//@cmember GetDBSession
		STDMETHODIMP  GetDBSession(REFIID riid, IUnknown** ppSession);		

        // ICommandText methods

        //@cmember GetCommandText
		STDMETHODIMP  GetCommandText(GUID*, LPOLESTR*);

        //@cmember SetCommandText
		STDMETHODIMP  SetCommandText(REFGUID, LPCOLESTR);

		FINISH_CLASS(); 
};


//----------------------------------------------------------------------------------------
// @class CImpICommandProperties  | contained ICommandProperties class

class CImpICommandProperties : public ICommandProperties      //@base public | ICommandProperties
{
	START_CLASS(); 

private: //@access private
	DEBUGCODE(ULONG m_cRef);											
		
	CCommand*	m_pObj;
	LPUNKNOWN	m_pUnkOuter;

public: //@access public
	CImpICommandProperties(CCommand* pObj, IUnknown *pUnkOuter)					
	{																	
		CLEAR_CONSTRUCT( CImpICommandProperties );
		
		DEBUGCODE(m_cRef = 0L);											
		m_pObj		= pObj;
		m_pUnkOuter	= pUnkOuter;										
	}																	
	
	~CImpICommandProperties()	
	{																	
	}


	STDMETHODIMP_(ULONG)	AddRef(void)									
	{																	
		DEBUGCODE( ++m_cRef );											
		return m_pUnkOuter->AddRef();									
	}
																		
	STDMETHODIMP_(ULONG)	Release(void)									
	{																	
		ASSERT( m_cRef > 0 );											
		DEBUGCODE( --m_cRef );											
		return m_pUnkOuter->Release();									
	}
																		
	STDMETHODIMP			QueryInterface(REFIID riid, LPVOID *ppv)		
	{																	
		return m_pUnkOuter->QueryInterface(riid, ppv);					
	}


	//ICommandProperties methods

    //@cmember GetProperties method
    STDMETHODIMP GetProperties
        (
		const ULONG			cPropertyIDSets,		
		const DBPROPIDSET	rgPropertyIDSets[], 	
		ULONG*              pcPropertySet, 	
		DBPROPSET**			prgPropertySet 	    
		);


    //@cmember SetProperties method
    STDMETHODIMP	SetProperties
		(
		ULONG				cPropertySets,		
		DBPROPSET			rgPropertySets[] 	    
		);

	FINISH_CLASS(); 
};


//----------------------------------------------------------------------------------------
// @class CImpICommandPrepare  | contained ICommandPrepare class


class CImpICommandPrepare : public ICommandPrepare      //@base public | ICommandPrepare
{
	START_CLASS(); 

	private:        //@access private
		DEBUGCODE(ULONG m_cRef);											
		CCommand		*m_pObj;											
		LPUNKNOWN		m_pUnkOuter;

	public:         //@access public
		CImpICommandPrepare(CCommand *pObj, IUnknown *pUnkOuter)					
		{																	
			CLEAR_CONSTRUCT( CImpICommandPrepare );
			
			DEBUGCODE(m_cRef = 0L);											
			m_pObj		= pObj;												
			m_pUnkOuter	= pUnkOuter;										
		}																	
		
		~CImpICommandPrepare()														
		{																	
		}


		STDMETHODIMP_(ULONG)	AddRef(void)									
		{																	
			DEBUGCODE( ++m_cRef );											
			return m_pUnkOuter->AddRef();									
		}
																			
		STDMETHODIMP_(ULONG)	Release(void)									
		{																	
			ASSERT( m_cRef > 0 );											
			DEBUGCODE( --m_cRef );											
			return m_pUnkOuter->Release();									
		}
																			
		STDMETHODIMP			QueryInterface(REFIID riid, LPVOID *ppv)		
		{																	
			return m_pUnkOuter->QueryInterface(riid, ppv);					
		}

       
        // ICommandPrepare methods

        //@cmember Prepare
		STDMETHODIMP Prepare(ULONG);

        //@cmember Unprepare
		STDMETHODIMP Unprepare();

		FINISH_CLASS(); 
};


//----------------------------------------------------------------------------------------
// @class CImpICommandText  | contained ICommandText class


//----------------------------------------------------------------------------------------
// @class CImpISupportErrorInfo  | contained ISupportErrorInfo class

class CImpISupportErrorInfo : public ISupportErrorInfo      //@base public | ISupportErrorInfo
{
	START_CLASS(); 

private: //@access private
	DEBUGCODE(ULONG m_cRef);											
		
	CCommand*	m_pObj;
	LPUNKNOWN	m_pUnkOuter;

public: //@access public
	CImpISupportErrorInfo(CCommand* pObj, IUnknown *pUnkOuter)					
	{																	
		CLEAR_CONSTRUCT( CImpISupportErrorInfo );
		
		DEBUGCODE(m_cRef = 0L);											
		m_pObj		= pObj;
		m_pUnkOuter	= pUnkOuter;										
	}																	
	
	~CImpISupportErrorInfo()	
	{																	
	}


	STDMETHODIMP_(ULONG)	AddRef(void)									
	{																	
		DEBUGCODE( ++m_cRef );											
		return m_pUnkOuter->AddRef();									
	}
																		
	STDMETHODIMP_(ULONG)	Release(void)									
	{																	
		ASSERT( m_cRef > 0 );											
		DEBUGCODE( --m_cRef );											
		return m_pUnkOuter->Release();									
	}
																		
	STDMETHODIMP			QueryInterface(REFIID riid, LPVOID *ppv)		
	{																	
		return m_pUnkOuter->QueryInterface(riid, ppv);					
	}


	//CImpISupportErrorInfo method
	STDMETHODIMP InterfaceSupportsErrorInfo(REFIID riid);

	FINISH_CLASS(); 
};



//----------------------------------------------------------------------------------------
// @class CImpICommandWithParameters  | contained ICommandWithParameters class


class CImpICommandWithParameters : public ICommandWithParameters      //@base public | ICommandWithParameters
{
	START_CLASS(); 

friend class CImpICommand;

private:        //@access private
	DEBUGCODE(ULONG m_cRef);											
	CCommand		*m_pObj;											
	LPUNKNOWN		m_pUnkOuter;

protected:
	//Count of infos
	ULONG			m_nCount;  
	//Info array
	DBPARAMINFO*	m_pParamInfo;

public:         //@access public
	CImpICommandWithParameters(CCommand *pObj, IUnknown *pUnkOuter)					
	{																	
		CLEAR_CONSTRUCT( CImpICommandWithParameters );
		
		DEBUGCODE(m_cRef = 0L);											
		
		m_pObj			= pObj;												
		m_pUnkOuter		= pUnkOuter;										
		//m_nCount		= 0;
		//m_pParamInfo	= NULL;
	}																	
	
	~CImpICommandWithParameters()														
	{																	
	}


	STDMETHODIMP_(ULONG)	AddRef(void)									
	{																	
		DEBUGCODE( ++m_cRef );											
		return m_pUnkOuter->AddRef();									
	}
																		
	STDMETHODIMP_(ULONG)	Release(void)									
	{																	
		ASSERT( m_cRef > 0 );											
		DEBUGCODE( --m_cRef );											
		return m_pUnkOuter->Release();									
	}
																		
	STDMETHODIMP			QueryInterface(REFIID riid, LPVOID *ppv)		
	{																	
		return m_pUnkOuter->QueryInterface(riid, ppv);					
	}

   
    // ICommandWithParameters methods

    //@cmember GetParameterInfo
	STDMETHODIMP GetParameterInfo(ULONG*, DBPARAMINFO**, OLECHAR**);

    //@cmember MapParameterNames
	STDMETHODIMP MapParameterNames(ULONG, const OLECHAR*[], LONG[]);
    
	//@cmember SetParameterInfo
	STDMETHODIMP SetParameterInfo(ULONG, const ULONG[], const DBPARAMBINDINFO[]);

	FINISH_CLASS(); 
};



#endif

