/*
 * Copyright (c)  2000
 * SWsoft  company
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted 
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */

//--------------------------------------------------------------------
// MySQL OLE DB Provider 
// Functionality: minimum
// Release: 0.1
//
// @doc
//
// @module DBSESS.H | CDBSession base object and contained interface
// definitions
//
//
#ifndef _DBSESS_H_
#define _DBSESS_H_

// For multiply rowsets management
#include	"rwstmgmt.h"

// Forward declarations ------------------------------------------------------

class   CImpIGetDataSource;
class   CImpIOpenRowset;
class	CImpISessionProperties;
class	CImpIDBCreateCommand;
class	CImpIDBSchemaRowset;
class	CSQLParser;
class CQueryTable;
//class	CImpIIndexDefinition;
typedef CImpIGetDataSource*		PIMPIGETDATASOURCE;
typedef CImpIOpenRowset*		PIMPIOPENROWSET;
typedef CImpISessionProperties*	PIMPISESSIONPROPERTIES;
typedef CImpIDBCreateCommand*	PIMPIDBCREATECOMMAND;
typedef CImpIDBSchemaRowset*	PIMPIDBSCHEMAROWSET;
//typedef CImpIIndexDefinition*	PIMPIINDEXDEFINITION;

// Classes -------------------------------------------------------------------

//----------------------------------------------------------------------------
// @class CDBSession | Containing class for all interfaces on the DBSession 
// Object
//
class CDBSession : public IUnknown				//@base public | IUnknown
{
	START_CLASS(); 

// contained interfaces are friends
friend class CImpIGetDataSource;
friend class CImpIOpenRowset;
friend class CImpIDataSource;
friend class CImpISessionProperties;
friend class CImpIDBCreateCommand;
friend class CImpIDBSchemaRowset;
friend class CImpICommand;
friend class CSQLParser;
friend class CQueryTable;
//friend class CImpIIndexDefinition;

friend class CCommand;  // it would be better to remove later (CUtilProp)
friend class CRowset;	// it would be better to remove later (CUtilProp)
friend class CSqlParser;	// it would be better to remove later (CUtilProp)


private: //@access private
	// Session ID
	MT_SINT m_siSessionID;

	//@cmember  operation status declaration
	MT_SINT   m_bstatus;

protected: //@access protected
	//@cmember Reference count
	ULONG		m_cRef;						
	//@cmember Session number
	ULONG		m_cNSession;						
	//@cmember Path Name (path to data dictionary)
	//char		m_szPath[_MAX_PATH+1];
    //@member flag is TRUE if Rowset has been created
    BOOL        m_fRowsetCreated;
    //@member rowset's monitor 
	ROWSETBITS	m_rbRowsetMonitor;
    //@member total number of current rowsets 
	ULONG		m_ulTotalRowsets;
    //@member rowset's monitor 
	CRowset*	m_pRowsets[NUM_SUPPORTED_ROWSETS_PER_SESSION];
     //@member Utility object to manage properties
    PCUTILPROP  m_pUtilProp;
	
    //@member contained IOpenRowset
    PIMPIOPENROWSET         m_pIOpenRowset;
	//@member contained IGetDataSource
	PIMPIGETDATASOURCE		m_pIGetDataSource;
	//@member contained ISessionProperties
	PIMPISESSIONPROPERTIES	m_pISessionProperties;
	//@member contained IDBCreateCommand
	PIMPIDBCREATECOMMAND	m_pIDBCreateCommand;
	//@member contained IDBSchemaRowset
	PIMPIDBSCHEMAROWSET		m_pIDBSchemaRowset;
	//@member contained IIndexDefinition
	//PIMPIINDEXDEFINITION	m_pIIndexDefinition;

	
public: //@access public
	//@cmember Constructor		 
	 CDBSession(LPUNKNOWN);
	//@cmember Destructor
	~CDBSession(void);

	//@cmember Controlling IUnknown
	LPUNKNOWN					m_pUnkOuter;				
	//@mcember parent data source object
	PCDATASOURCE				m_pCDataSource;

	//@cmember MARK Rowset ulSession As Active/InActive
	HRESULT SetActiveRowset(ULONG ulRowset);
	HRESULT SetInActiveRowset(ULONG ulRowset);

	//@cmember Get first inactive session
	HRESULT GetFirstInactiveRowset(ULONG *ulRowset);

	//@cmember Count Active Sessions
	HRESULT CountActiveRowsets(void);

	//@cmember Intitialization Routine
	BOOL FInit( ULONG ulSession, /*char* szPath,*/ CDataSource	*pCDataSource );

	//@cmember Make XQL session active
	// HRESULT MakeMyXQLSessionActive();

	//@cmember inline to dec rowset count
	inline void DecRowsetCount(void){if(this->m_fRowsetCreated) this->m_fRowsetCreated--;};

	//	Object's base IUnknown
	//@cmember Request an Interface
	STDMETHODIMP			QueryInterface(REFIID, LPVOID *);
	//@cmember Increments the Reference count
	STDMETHODIMP_(ULONG)	AddRef(void);
	//@cmember Decrements the Reference count
	STDMETHODIMP_(ULONG)	Release(void);

	inline void	RowsetDestroyed() { m_fRowsetCreated = FALSE; };

	//@cmember Perform operations connected with correct destroying of rowset
	HRESULT		RemoveRowset(ULONG ulRowset);

	FINISH_CLASS(); 
};

typedef CDBSession *PCDBSESSION;


//----------------------------------------------------------------------------------------
// @class CImpIGetDataSource   | contained IGetDataSource class


class CImpIGetDataSource : public IGetDataSource      //@base public | IGetDataSource
{
	START_CLASS(); 

	private:        //@access private
		DEBUGCODE(ULONG m_cRef);											
		CDBSession		*m_pObj;											
		LPUNKNOWN		m_pUnkOuter;

	public:         //@access public
		CImpIGetDataSource( CDBSession *pObj, IUnknown *pUnkOuter )					
		{																	
			CLEAR_CONSTRUCT( CImpIGetDataSource );
			
			DEBUGCODE(m_cRef = 0L);											
			m_pObj		= pObj;												
			m_pUnkOuter	= pUnkOuter;										
		}																	
		
		~CImpIGetDataSource()														
		{																	
		}


		STDMETHODIMP_(ULONG)	AddRef(void)									
		{																	
			DEBUGCODE( ++m_cRef );											
			return m_pUnkOuter->AddRef();									
		}
																			
		STDMETHODIMP_(ULONG)	Release(void)									
		{																	
			ASSERT( m_cRef > 0 );											
			DEBUGCODE( --m_cRef );											
			return m_pUnkOuter->Release();									
		}
																			
		STDMETHODIMP			QueryInterface(REFIID riid, LPVOID *ppv)		
		{																	
			return m_pUnkOuter->QueryInterface(riid, ppv);					
		}

       
        // IGetDataSource method
        //@cmember GetDataSource
		STDMETHODIMP  GetDataSource( REFIID, IUnknown** );
	
		FINISH_CLASS(); 
};

//----------------------------------------------------------------------------------------
// @class CImpIOpenRowset   | contained IOpenRowset class


class CImpIOpenRowset : public IOpenRowset      //@base public | IOpenRowset
{
	START_CLASS(); 

	private:        //@access private
		DEBUGCODE(ULONG m_cRef);											
		CDBSession		*m_pObj;											
		LPUNKNOWN		m_pUnkOuter;

	public:         //@access public
		CImpIOpenRowset( CDBSession *pObj, IUnknown *pUnkOuter )					
		{																	
			CLEAR_CONSTRUCT( CImpIOpenRowset );
			
			DEBUGCODE(m_cRef = 0L);											
			m_pObj		= pObj;												
			m_pUnkOuter	= pUnkOuter;										
		}																	
		
		~CImpIOpenRowset()														
		{																	
		}

		STDMETHODIMP_(ULONG)	AddRef(void)									
		{																	
			DEBUGCODE( ++m_cRef );											
			return m_pUnkOuter->AddRef();									
		}
																			
		STDMETHODIMP_(ULONG)	Release(void)									
		{																	
			ASSERT( m_cRef > 0 );											
			DEBUGCODE( --m_cRef );											
			return m_pUnkOuter->Release();									
		}
																			
		STDMETHODIMP			QueryInterface(REFIID riid, LPVOID *ppv)		
		{																	
			return m_pUnkOuter->QueryInterface(riid, ppv);					
		}

       
        // IOpenRowset method
        //@cmember OpenRowset
		STDMETHODIMP  OpenRowset( IUnknown*, DBID*, DBID*, REFIID, ULONG, DBPROPSET[], IUnknown** );
	
		FINISH_CLASS(); 
};


//----------------------------------------------------------------------------
// @class CImpISessionProperties | Contained ISessionProperties class
//
class CImpISessionProperties : public ISessionProperties		//@base public | ISessionProperties
{
	START_CLASS(); 

	private:        //@access private
		DEBUGCODE(ULONG m_cRef);											
		CDBSession		*m_pObj;											
		LPUNKNOWN		m_pUnkOuter;

	public:         //@access public
		CImpISessionProperties( CDBSession *pObj, IUnknown *pUnkOuter )					
		{																	
			CLEAR_CONSTRUCT( CImpISessionProperties );
			
			DEBUGCODE(m_cRef = 0L);											
			m_pObj		= pObj;												
			m_pUnkOuter	= pUnkOuter;										
		}																	
		
		~CImpISessionProperties()														
		{																	
		}

		STDMETHODIMP_(ULONG)	AddRef(void)									
		{																	
			DEBUGCODE( ++m_cRef );											
			return m_pUnkOuter->AddRef();									
		}
																			
		STDMETHODIMP_(ULONG)	Release(void)									
		{																	
			ASSERT( m_cRef > 0 );											
			DEBUGCODE( --m_cRef );											
			return m_pUnkOuter->Release();									
		}
																			
		STDMETHODIMP			QueryInterface(REFIID riid, LPVOID *ppv)		
		{																	
			return m_pUnkOuter->QueryInterface(riid, ppv);					
		}


		//	IDBProperties member functions

        //@cmember GetProperties method
        STDMETHODIMP GetProperties
		        	(
						ULONG				cPropertySets,		
				      	const DBPROPIDSET	rgPropertySets[], 	
			        	ULONG*              pcProperties, 	
					 	DBPROPSET**			prgProperties 	    
		        	);


        //@cmember SetProperties method
        STDMETHODIMP	SetProperties
					 	(
							ULONG				cProperties,		
						 	DBPROPSET			rgProperties[] 	    
						);
		FINISH_CLASS(); 
};


//----------------------------------------------------------------------------
// @class CImpIDBCreateCommands | Contained IDBCreateCommand class
//
class CImpIDBCreateCommand : public IDBCreateCommand		//@base public | IDBCreateCommand
{
	START_CLASS(); 

	private:        //@access private
		DEBUGCODE(ULONG m_cRef);											
		CDBSession		*m_pObj;											
		LPUNKNOWN		m_pUnkOuter;

	public:         //@access public
		CImpIDBCreateCommand(CDBSession *pObj, IUnknown *pUnkOuter)					
		{																	
			CLEAR_CONSTRUCT( CImpIDBCreateCommand );
			
			DEBUGCODE(m_cRef = 0L);											
			m_pObj		= pObj;												
			m_pUnkOuter	= pUnkOuter;										
		}																	
		
		~CImpIDBCreateCommand()														
		{																	
		}

		STDMETHODIMP_(ULONG)	AddRef(void)									
		{																	
			DEBUGCODE( ++m_cRef );											
			return m_pUnkOuter->AddRef();									
		}
																			
		STDMETHODIMP_(ULONG)	Release(void)									
		{																	
			ASSERT( m_cRef > 0 );											
			DEBUGCODE( --m_cRef );											
			return m_pUnkOuter->Release();									
		}
																			
		STDMETHODIMP			QueryInterface(REFIID riid, LPVOID *ppv)		
		{																	
			return m_pUnkOuter->QueryInterface(riid, ppv);					
		}


		//	ICreateCommand member functions

        //@cmember CreateCommand method
        STDMETHODIMP CreateCommand(IUnknown*, REFIID, IUnknown**);
	
		FINISH_CLASS(); 
};


//----------------------------------------------------------------------------
// @class CImpIDBSchemaRowset | Contained IDBSchemaRowset class
//
class CImpIDBSchemaRowset : public IDBSchemaRowset		//@base public | IDBSchemaRowset
{
	START_CLASS(); 

	private:        //@access private
		DEBUGCODE(ULONG m_cRef);											
		CDBSession		*m_pObj;											
		LPUNKNOWN		m_pUnkOuter;

	public:         //@access public
		CImpIDBSchemaRowset(CDBSession *pObj, IUnknown *pUnkOuter)					
		{																	
			CLEAR_CONSTRUCT( CImpIDBSchemaRowset );

			DEBUGCODE(m_cRef = 0L);											
			m_pObj		= pObj;												
			m_pUnkOuter	= pUnkOuter;										
		}																	
		
		~CImpIDBSchemaRowset()														
		{																	
		}

		STDMETHODIMP_(ULONG)	AddRef(void)									
		{																	
			DEBUGCODE( ++m_cRef );											
			return m_pUnkOuter->AddRef();									
		}
																			
		STDMETHODIMP_(ULONG)	Release(void)									
		{																	
			ASSERT( m_cRef > 0 );											
			DEBUGCODE( --m_cRef );											
			return m_pUnkOuter->Release();									
		}
																			
		STDMETHODIMP			QueryInterface(REFIID riid, LPVOID *ppv)		
		{																	
			return m_pUnkOuter->QueryInterface(riid, ppv);					
		}


		//	IDBSchemaRowset member functions

        //@cmember GetRowset method
		STDMETHODIMP GetRowset(IUnknown*, REFGUID, ULONG, const VARIANT [],	REFIID,	ULONG, DBPROPSET [], IUnknown**);
        //@cmember GetSchemas method
		STDMETHODIMP GetSchemas(ULONG*,	GUID**,	ULONG**);

		FINISH_CLASS(); 
};

//----------------------------------------------------------------------------
// @class CImpIDBSchemaRowset | Contained IDBSchemaRowset class
//
/*class CImpIIndexDefinition : public IIndexDefinition	//@base public | IIndexDefinition
{
	START_CLASS(); 

	private:        //@access private
		DEBUGCODE(ULONG m_cRef);											
		CDBSession		*m_pObj;											
		LPUNKNOWN		m_pUnkOuter;

	public:         //@access public
		CImpIIndexDefinition(CDBSession *pObj, IUnknown *pUnkOuter)					
		{																	
			CLEAR_CONSTRUCT( CImpIIndexDefinition );

			DEBUGCODE(m_cRef = 0L);											
			m_pObj		= pObj;												
			m_pUnkOuter	= pUnkOuter;										
		}																	
		
		~CImpIIndexDefinition()														
		{																	
		}

		STDMETHODIMP_(ULONG)	AddRef(void)									
		{																	
			DEBUGCODE( ++m_cRef );											
			return m_pUnkOuter->AddRef();									
		}
																			
		STDMETHODIMP_(ULONG)	Release(void)									
		{																	
			ASSERT( m_cRef > 0 );											
			DEBUGCODE( --m_cRef );											
			return m_pUnkOuter->Release();									
		}
																			
		STDMETHODIMP			QueryInterface(REFIID riid, LPVOID *ppv)		
		{																	
			return m_pUnkOuter->QueryInterface(riid, ppv);					
		}


		//	IIndexDefinition member functions
        //@cmember Create an index
		STDMETHODIMP CreateIndex(DBID* pTableID,  DBID* pIndexID, 
			ULONG cIndexColumnDescs, const DBINDEXCOLUMNDESC rgIndexColumnDescs[], 
			ULONG cPropertySets,  DBPROPSET rgPropertySets[], DBID **  ppIndexID );
   
        //@cmember Drop an index
		STDMETHODIMP DropIndex(DBID* pTableID, DBID* pIndexID);

		FINISH_CLASS(); 
};*/


#endif

