/*
 * Copyright (c)  2000
 * SWsoft  company
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted 
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */

//--------------------------------------------------------------------
// MySQL OLE DB Provider 
// Functionality: minimum
// Release: 0.1
//
// @doc
//
// @module EXTBUFF.H | Class Definitions for CExtBuffer Class
//
//
#ifndef _EXTBUFF_H_
#define _EXTBUFF_H_

// Forward Declaration
class FAR CExtBuffer;
typedef CExtBuffer FAR *LPEXTBUFFER;


//--------------------------------------------------------------------
// @class Allocates and manages fixed sized block memory routines
// 
// @hungarian ext or pext
//
class FAR CExtBuffer
{			
	START_CLASS(); 

private: //@access private
	//@cmember Current count of items
	ULONG    m_cbItem;		
	//@cmember Item size, in bytes
	ULONG    m_cItem;		
	//@cmember Reserved byte count
	ULONG    m_cbReserved;	
	//@cmember Allocated byte count
	ULONG    m_cbAlloc;
	//@cmember increment value
	ULONG    m_dbAlloc;
	//@cmember Ptr to beginning of buffer
	BYTE     *m_rgItem;		
	

private:
	// Not implemented; private so dcl prevents generation.
	CExtBuffer( const CExtBuffer & p);
	CExtBuffer& operator=(const CExtBuffer & p);

public:	//@access public
	//@cmember Construcutor
	CExtBuffer ( void );
	//@cmember Destructor
	~CExtBuffer ( void );
	//@cmember Calculated data pointer from index value
	void * operator[] (ULONG nIndex);	
	//@cmember Initialize the fixed size buffer
	STDMETHODIMP 	FInit (ULONG cItemMax, ULONG cbItem, ULONG cbPage);
	//@cmember Add new items to the buffer
	STDMETHODIMP 	InsertIntoExtBuffer (VOID* pvItem, ULONG &hItem);
	//cmember Retrieve items from buffer
	STDMETHODIMP    GetItemOfExtBuffer (ULONG hItem,	VOID* pvItem);
	//@cmember Get usage extent indexes
	STDMETHODIMP    GetFirstLastItemH (ULONG &hItemFirst, ULONG &hItemLast);

	FINISH_CLASS(); 
};

#endif
