/*
 * Copyright (c)  2000
 * SWsoft  company
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted 
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */

//--------------------------------------------------------------------
// MySQL OLE DB Provider 
// Functionality: minimum
// Release: 0.1
//
// @doc
//
// @module SWSTPROV.H | Main include file
//
//
#ifndef _SWSTPROV_H_
#define _SWSTPROV_H_



// Defines -------------------------------------------------------------------
#ifdef DBINITCONSTANTS
# define GLOBAL_(type, name, val) 	type name = val
#else
# define GLOBAL_(type, name, val)	extern type name
#endif

#ifdef DBINITCONSTANTS
# define GLOBALSTRUCT_(type, name) 	type name 
#else
# define GLOBALSTRUCT_(type, name)	extern type name
#endif


#define OBJECT_CONSTRUCTED()		InterlockedIncrement(&g_cObj);
#define OBJECT_DESTRUCTED()			InterlockedDecrement(&g_cObj);

#ifndef  MAX
# define MIN(a,b)  ( (a) < (b) ? (a) : (b) )
# define MAX(a,b)  ( (a) > (b) ? (a) : (b) )
#endif


#ifndef NUMELEM
# define NUMELEM(x) (sizeof(x)/sizeof(*x))
#endif

#define MAX_HEAP_SIZE          	128000
#define MAX_TOTAL_ROWBUFF_SIZE 	(10*1024*1024)				// Max for all row buffers.
#define MAX_IBUFFER_SIZE       	2000000
#define MAX_BIND_LEN      		(MAX_IBUFFER_SIZE/10)
#define ACTIVE_ROWS_LIMIT		200


#define STAT_ENDOFCURSOR            0x00000100	// for forward-only means fully materialized


//-----------------------------------------------------------------------------
// Memory alignment
//-----------------------------------------------------------------------------

//++
// Useful rounding macros.
// Rounding amount is always a power of two.
//--
#define ROUND_DOWN( Size, Amount )  ((DWORD)(Size) & ~((Amount) - 1))
#define ROUND_UP(   Size, Amount ) (((DWORD)(Size) +  ((Amount) - 1)) & ~((Amount) - 1))

//++
// These macros are for aligment of ColumnData within the internal row buffer.
// COLUMN_ALIGN takes a ptr where you think data ought to go,
// and rounds up to the next appropriate address boundary.
//
// Rule of thumb is "natural" boundary, i.e. 4-byte member should be
// aligned on address that is multiple of 4.
//
// Most everything should be aligned to 32-bit boundary.
// But doubles should be aligned to 64-bit boundary, so let's play it safe.
// Also have __int64.
//--



// make these symbols a little easier to type\read
#if   defined(_M_IX86)
#     define X86
#elif defined(_M_MRX000)
#     define MIPS
#elif defined(_M_ALPHA)
#     define ALPHA
#elif defined(_M_PPC)
#     define PPC
#else
#     error: Unknown machine type: Not one of {X86,MIPS,ALPHA,PPC}.
#endif

#ifdef MIPS
# define COLUMN_ALIGNVAL 8
#elif  defined(ALPHA)
# define COLUMN_ALIGNVAL 8
#else
# define COLUMN_ALIGNVAL 8		// venerable 80x86
#endif


// Typedefs ------------------------------------------------------------------
typedef VOID**	LPLPVOID;

typedef long int            SDWORD;
typedef short int           SWORD;
typedef unsigned long int   UDWORD;
typedef unsigned short int  UWORD;
typedef signed long 		SLONG;
typedef unsigned long		ULONG;
typedef unsigned short		USHORT;



// Accessor Structure
typedef struct tagACCESSOR
{
    DBACCESSORFLAGS dwAccessorFlags;
	LONG			cRef;
	ULONG			cBindings;
	bool			bNullAccessor;
	DBBINDING		rgBindings[1];
} ACCESSOR, *PACCESSOR;




//-----------------------------------------------------------------------------
// Macros for interface classes -- IUnknown methods and constructor\destructor
// Use these in the class definition for an interface.
// The code is defined in the header (definition) part because
// it is easier to do so here, and easier to use.


// Globals -------------------------------------------------------------------

GLOBAL_(LONG, g_cObj, 0L);						// # of outstanding objects
GLOBAL_(LONG, g_cLock, 0L);						// # of explicit locks set
GLOBAL_(DWORD, g_cAttachedProcesses, 0L);		// # of attached processes
GLOBAL_(DWORD, g_dwPageSize, 0L);				// System page size
GLOBAL_(IMalloc *, g_pIMalloc, NULL);			// OLE2 task memory allocator
GLOBAL_(HINSTANCE, g_hInstance, 0L);			// Instance Handle
GLOBAL_(IDataConvert *, g_pIDataConvert, NULL);	// IDataConvert pointer

GLOBALSTRUCT_(CRITICAL_SECTION, g_CriticalSection);

#define	LICLENGTH	25
//#define TERMDIV2	8	 // 8 ~ 5 days, that means 10 days per trial version. Old value: 23 ~ <30 days
#define TERMDIV2	23
#define	PERMANENT	211879
typedef enum {EXPIRED = 0, TRIAL = 1, LICENSED = 2, REGISTRATION = 3} LICENSESTATE;
GLOBAL_( LICENSESTATE, g_LicenseStateSwst, EXPIRED);

GLOBAL_( LICENSESTATE, g_LicenseStateMySql, LICENSED);

GLOBAL_( char, g_szLicense[LICLENGTH], "");
// 

#endif

