/*
 * Copyright (c)  2000
 * SWsoft  company
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted 
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */

//--------------------------------------------------------------------
// MySQL OLE DB Provider 
// Functionality: base
// Release: 0.1
//
// @doc
//
// @module ROWIDEN.CPP | IRowsetIdentity interface implementation
//
//

// Includes ------------------------------------------------------------------

#include "hfiles.h"
#include "headers.h"

// CImpIRowsetIdentity::IsSameRow
//
// @mfunc	Compares two bookmarks.
//
// @desc	HRESULT
//		@flag	S_OK			| The method succeeded. 
//		@flag	E_FAIL			| A provider-specific error occurred. 
//		@flag	E_INVALIDARG	| cbBookmark1 or cbBookmark2 was zero. 
//		@flag	DB_E_BADBOOKMARK| pBookmark1 or pBookmark2 was zero
//
HRESULT	CImpIRowsetIdentity::IsSameRow
(
	HROW    hThisRow,
    HROW    hThatRow
)
{
	INTERFACE_METHOD_START( "IRowsetIdentity::IsSameRow" );

	// if row handle bad ?
	if (hThisRow > ACTIVE_ROWS_LIMIT || hThatRow >ACTIVE_ROWS_LIMIT)
		return DB_E_BADROWHANDLE;

    // IsSlotSet returns S_OK    if row is marked.
    //                   S_FALSE if row is not marked.
    // The "mark" means that there is data present in the row.
    // Rows are [1...n], slot marks are [0...n-1].
	if (m_pObj->m_prowbitsIBuffer->IsSlotSet( m_pObj->GetSlotNumber(hThisRow) ) != S_OK ||
		m_pObj->m_prowbitsIBuffer->IsSlotSet( m_pObj->GetSlotNumber(hThatRow) ) != S_OK)
	{
        return DB_E_BADROWHANDLE;
	}

	// if row hThisRow is deleted ?
	if (m_pObj->IfRowMarkedAsDeleted(hThisRow)) 
		return DB_E_DELETEDROW;

	// if row hThatRow is deleted ?
	if (m_pObj->IfRowMarkedAsDeleted(hThatRow)) 
		return DB_E_DELETEDROW;

	// are hThisRow and hThatRow rows the same ?
	if (hThisRow == hThatRow)
		return S_OK;
	else
		return S_FALSE;

	INTERFACE_METHOD_END();
}
