/*
 * Copyright (c)  2000
 * SWsoft  company
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted 
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */

//This file contains definition of class that is responsible
//for navifation though data sources

#pragma once
#include "schema.h"	// for COLINFO

struct SOURCEITEMDATA
{
	WCHAR m_wszSourceName[ MAXDATASOURCENAME+1 ];
	WCHAR m_wszParseName[ MAXDDFPATH+1 ];
	WCHAR m_wszDescription[ MAXDESCRIPTION+1 ];
};


//----------------------------------------------------------------------------
// @class CImpISourcesRowset | Contained ISourcesRowset class
//
class CImpISourcesRowset : public ISourcesRowset		//@base public | ISourcesRowset
{
	START_CLASS(); 

	private:        //@access private
		DEBUGCODE(ULONG m_cRef);											
		CUtilProp		*m_pUtilProp;
		LPUNKNOWN		m_pUnkOuter;
		BOOL			m_bMySqlMode;

	public:         //@access public
		CImpISourcesRowset( LPUNKNOWN pUnknown, BOOL bMySqlMode )					
		{																	
			CLEAR_CONSTRUCT( CImpISourcesRowset );
			m_pUnkOuter = pUnknown;
			m_bMySqlMode = bMySqlMode;
		}																	
		
		~CImpISourcesRowset()														
		{
			delete m_pUtilProp;
		}

		STDMETHODIMP_(ULONG)	AddRef(void)									
		{																	
			DEBUGCODE( ++m_cRef );											
			return m_pUnkOuter->AddRef();									
		}																	
	
		STDMETHODIMP_(ULONG)	Release(void)									
		{																	
			ASSERT( m_cRef > 0 );											
			DEBUGCODE( --m_cRef );											
			return m_pUnkOuter->Release();									
		}																	
	
		STDMETHODIMP			QueryInterface(REFIID riid, LPVOID *ppv)		
		{																	
			return m_pUnkOuter->QueryInterface(riid, ppv);					
		}

		//	ISourcesRowset member functions

        //@cmember GetRowset method
		STDMETHODIMP GetSourcesRowset(IUnknown*, REFIID, ULONG, DBPROPSET [], IUnknown**);

		FINISH_CLASS(); 
};

typedef CImpISourcesRowset * PCIMPISOURCESROWSET;

//----------------------------------------------------------------------------
// @class CImpIParseDisplayName | Contained IParseDisplayName class
//
class CImpIParseDisplayName : public IParseDisplayName		//@base public | IParseDisplayName
{
	START_CLASS(); 

	private:        //@access private
		DEBUGCODE(ULONG m_cRef);											
		CUtilProp		*m_pUtilProp;
		LPUNKNOWN		m_pUnkOuter;
		BOOL			m_bMySqlMode;

	public:         //@access public
		CImpIParseDisplayName( LPUNKNOWN pUnknown, BOOL bMySqlMode )
		{																	
			CLEAR_CONSTRUCT( CImpIParseDisplayName );
			m_pUnkOuter = pUnknown;
			m_bMySqlMode = bMySqlMode;
		}																	
		
		~CImpIParseDisplayName()														
		{
			delete m_pUtilProp;
		}

		STDMETHODIMP_(ULONG)	AddRef(void)									
		{																	
			DEBUGCODE( ++m_cRef );											
			return m_pUnkOuter->AddRef();									
		}																	
	
		STDMETHODIMP_(ULONG)	Release(void)									
		{																	
			ASSERT( m_cRef > 0 );											
			DEBUGCODE( --m_cRef );											
			return m_pUnkOuter->Release();									
		}																	
	
		STDMETHODIMP			QueryInterface(REFIID riid, LPVOID *ppv)		
		{																	
			return m_pUnkOuter->QueryInterface(riid, ppv);					
		}


		//	IParseDisplayName member functions

        //@cmember GetRowset method
		STDMETHODIMP ParseDisplayName(IBindCtx*, LPOLESTR, ULONG*, IMoniker**);

		FINISH_CLASS(); 
};

typedef CImpIParseDisplayName * PCIMPIPARSEDISPLAYNAME;


class CSourcesData : public CData
{
	START_CLASS(); 
	BOOL m_bMySqlMode;

public: // virtual overrides
	// Invalidate buffers
	HRESULT SetMoveInfo( HRESULT hr );
	//@cmember Move relative
	HRESULT MovePending(LONG nRows, BOOL bSaveCurrentPosition );
	//@cmember Move relative
	HRESULT GetFetchedData(LONG ulRow, DWORD *pdwBmk);
	//@cmember Move to first row
	HRESULT MoveFirst();
	//@cmember Move to last row
	HRESULT MoveLast();
	//@cmember Move to specified bookmark
	HRESULT MoveBookmark(ULONG* pulBookmark);

	//@cmember Find row from current position
	HRESULT Find(ULONG icol, PCOLUMNDATA pDst/*void* pvValue*/,	DBCOMPAREOP	CompareOp, DBTYPE dbType, bool bForward);

	//@cmember Return the number of rows in the table	
	HRESULT GetRowCnt(DWORD* pdwRows);
	//@cmember Get relative position (by percentage) of the row in  table
	HRESULT GetPercentage(ULONG* pulBookmark, double *pdfPPos);
	//@cmember Get bookmark for current row
	HRESULT GetBookmark(ULONG *pulBookmark);
	//@cmember Retrieve number of columns
	HRESULT GetColumnCnt(DWORD* pdwCount);
	//@cmember Retrieve column information
	HRESULT GetColumnInfo(DWORD dwCol, DBCOLUMNINFO* pInfo);
	
	//@cmember Fetch row data
	HRESULT GetRow(ULONG* ulOffset, BYTE* pbProvRow);

	//@cmember Update the current rows values
	HRESULT UpdateRow(ULONG* pulBookmark, ULONG* ulOffset, BYTE* pbProvRow, PACCESSOR	pAccessor, BYTE* pbProvRowOld);
	//@cmember Insert new row
	HRESULT InsertRow(ULONG* ulOffset, BYTE* pbProvRow, PACCESSOR pAccessor);
	//@cmember Remove row with the bmk
	HRESULT DeleteRow(ULONG* pulBookmark);

public:
	CSourcesData::CSourcesData( BOOL bMySqlMode );
	CSourcesData::~CSourcesData();

	//Initialize object with schema data
	HRESULT Init();

protected:
	//@cmember Converts position to bookmark
	inline ULONG Pos2Bmk(ULONG ulPos) { return (ulPos + NUM_OF_RESERVED_BOOKMARKS); }
	//@cmember Converts bookmark to position  
	inline ULONG Bmk2Pos(ULONG ulBmk) { return (ulBmk - NUM_OF_RESERVED_BOOKMARKS); }

	//Number of columns
	ULONG m_cCols;
	//Information about columns
	COLINFO* m_pColumns;
	
	//Current row
	DWORD m_lCurrentRow;
	//Number of rows
	ULONG m_cRows;

	//Meta data descriptions
	CSwstMetaHolder* m_pSwstMetaHolder;

	// Multirow fetching
	CRowInfo*		m_plRowPositions;

	// Sources data
	SOURCEITEMDATA*	m_pSourceItemData;

	FINISH_CLASS(); 
};


// Classes -------------------------------------------------------------------

//----------------------------------------------------------------------------
// @class CSources | Containing class for all interfaces on the data sources 
// enumerator object
//
class CSources : public IUnknown				//@base public | IUnknown
{
	START_CLASS(); 

// contained interfaces are friends
friend class CImpISourcesRowset;
friend class CImpIParseDisplayName;

protected: //@access protected
	//@cmember Reference count
	ULONG					m_cRef;	
	//@cmember Controlling IUnknown
	LPUNKNOWN					m_pUnkOuter;				

    //@member contained ISourceRowset
    PCIMPISOURCESROWSET			m_pISourcesRowset;
	//@member contained IParseDisplayName
	PCIMPIPARSEDISPLAYNAME		m_pIParseDisplayName;

public: //@access public
	//@cmember Constructor		 
	CSources(LPUNKNOWN);
	//@cmember Destructor
	~CSources();

	//@cmember Intitialization Routine
	BOOL Init( BOOL bMySqlMode );

	//	Object's base IUnknown
	//@cmember Request an Interface
	STDMETHODIMP			QueryInterface(REFIID, LPVOID *);
	//@cmember Increments the Reference count
	STDMETHODIMP_(ULONG)	AddRef(void);
	//@cmember Decrements the Reference count
	STDMETHODIMP_(ULONG)	Release(void);

	FINISH_CLASS(); 
};

typedef CSources *PCSOURCES;
