/*
 * Copyright (c)  2000
 * SWsoft  company
 *
 * This material is provided "as is", with absolutely no warranty expressed
 * or implied. Any use is at your own risk.
 *
 * Permission to use or copy this software for any purpose is hereby granted 
 * without fee, provided the above notices are retained on all copies.
 * Permission to modify the code and to distribute modified code is granted,
 * provided the above notices are retained, and a notice that the code was
 * modified is included with the above copyright notice.
 *
 */

#pragma once

#define sgn(a)	((a>0) ? 1 : ((a<0) ? -1 : 0))

#define abs(a)  ((a>=0) ? a : ((a == MINLONG) ? MAXLONG : -a))

// max size for characters of a string
#define MAXSTR(sz) (sizeof(sz)/sizeof(*sz)-1)

// strncpy + '\0'
inline char* strcpy0( char* strDst, const char* strSrc, int maxSize )
{ 
	strncpy( strDst, strSrc, maxSize); 
	strDst[ maxSize ] = '\0'; 
	return strDst;
}

inline WCHAR* wcscpy0( WCHAR* strDst, const WCHAR* strSrc, int maxSize )
{ 
	wcsncpy( strDst, strSrc, maxSize); 
	strDst[ maxSize ] = '\0'; 
	return strDst;
}


// simple calls for convertor functions
inline int W2A( const WCHAR* strWide, char* strANSI, int cchANSI )
{
    return WideCharToMultiByte( CP_ACP, 0, strWide, -1, strANSI, cchANSI+1, NULL, NULL );
}

inline int A2W( const char* strANSI, WCHAR* strWide, int cchWide )
{
	return MultiByteToWideChar( CP_ACP, MB_PRECOMPOSED, strANSI, -1, strWide, cchWide+1 );
}

// the same for arrays
#define W2Asz( strWide, strANSI ) W2A( strWide, strANSI, MAXSTR(strANSI) )

#define A2Wsz( strANSI, strWide ) A2W( strANSI, strWide, MAXSTR(strWide) )



#ifndef DEBUG

#define INTERFACE_METHOD_START(x)  try {
#define INTERFACE_METHOD_END() } catch(...) { } return E_ABORT; 

#else

struct autoprint{
	LPCSTR m_p;
	autoprint(LPCSTR p) : m_p(p) { TRACE( m_p ); }
	~autoprint() { TRACE("done %s", m_p ); }
};
#define INTERFACE_METHOD_START(x)  autoprint __rosti__(x); try { 
#define INTERFACE_METHOD_END() } catch(...) { TRACE("@@@@@ Exception at %s", __rosti__.m_p ); } return E_ABORT;

#endif