/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import processing.core.PApplet;

public class AbilityTimer
extends PApplet {
    int next_y = 5;
    int delta_y = 30;
    ArrayList<Timerbutton> buttons = new ArrayList();
    ArrayList<Mission> missions = new ArrayList();
    Timerdisplay tmdisp = new Timerdisplay(120, 10);
    Timerbar tmbar = new Timerbar(180, 5, 5, this.tmdisp);
    int previous_time = 0;

    public void setup() {
        this.surface.setAlwaysOnTop(true);
        this.missions.add(new Mission("Guild Order", 1));
        this.missions.add(new Mission("Event Quests", 3));
        this.missions.add(new Mission("Daily Mission", 1));
        this.missions.add(new Mission("Material Exchg", 1));
        this.missions.add(new Mission("Gem Gacha", 1));
        this.missions.add(new Mission("Gem Quest", 2));
        this.missions.add(new Mission("Raid Quests", 1));
        this.missions.add(new Mission("Accessory Que.", 3));
    }

    public void draw() {
        this.background(240);
        if (this.tmdisp.getVisible()) {
            this.tmdisp.render();
        } else {
            this.tmbar.render();
            int i = 0;
            while (i < this.buttons.size()) {
                this.buttons.get(i).render();
                ++i;
            }
            i = 0;
            while (i < this.missions.size()) {
                this.missions.get(i).render();
                ++i;
            }
            this.tmbar.textRender();
        }
    }

    public void mousePressed() {
        if (this.tmdisp.getVisible()) {
            this.tmdisp.press();
        } else {
            this.tmbar.press();
            int i = 0;
            while (i < this.buttons.size()) {
                Timerbutton b = this.buttons.get(i);
                b.press();
                ++i;
            }
            i = 0;
            while (i < this.missions.size()) {
                Mission m = this.missions.get(i);
                int j = 0;
                while (j < m.boxes.length) {
                    int k;
                    m.boxes[j].click();
                    if (m.boxes[j].get()) {
                        k = j - 1;
                        while (k >= 0) {
                            m.boxes[k].set();
                            --k;
                        }
                    }
                    if (!m.boxes[j].get()) {
                        k = j + 1;
                        while (k < m.boxes.length) {
                            m.boxes[k].reset();
                            ++k;
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public void mouseReleased() {
        int i = 0;
        while (i < this.buttons.size()) {
            Timerbutton b = this.buttons.get(i);
            b.release();
            ++i;
        }
    }

    public void settings() {
        this.size(240, 370);
        this.smooth();
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"AbilityTimer"};
        if (passedArgs != null) {
            PApplet.main((String[])AbilityTimer.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    class Checkbox {
        int x;
        int y;
        boolean b;

        Checkbox(int _x, int _y) {
            this.x = _x;
            this.y = _y;
            this.b = false;
        }

        public void render() {
            AbilityTimer.this.stroke(0);
            AbilityTimer.this.strokeWeight(1.0f);
            AbilityTimer.this.fill(this.isOver() ? 224 : 255);
            AbilityTimer.this.rect(this.x, this.y, 20.0f, 20.0f);
            if (this.b) {
                AbilityTimer.this.stroke(255.0f, 0.0f, 0.0f);
                AbilityTimer.this.strokeWeight(2.0f);
                AbilityTimer.this.line(this.x + 2, this.y + 10, this.x + 10, this.y + 15);
                AbilityTimer.this.line(this.x + 10, this.y + 15, this.x + 18, this.y + 2);
            }
        }

        public void click() {
            if (this.isOver()) {
                this.b = !this.b;
            }
        }

        public boolean get() {
            return this.b;
        }

        public void set() {
            this.b = true;
        }

        public void reset() {
            this.b = false;
        }

        public boolean isOver() {
            return AbilityTimer.this.mouseX > this.x && AbilityTimer.this.mouseX < this.x + 20 && AbilityTimer.this.mouseY > this.y && AbilityTimer.this.mouseY < this.y + 20;
        }
    }

    class Mission {
        String name;
        Checkbox[] boxes;
        int y;

        Mission(String _name, int _items) {
            this.name = _name;
            this.boxes = new Checkbox[_items];
            this.y = AbilityTimer.this.next_y;
            AbilityTimer.this.next_y += AbilityTimer.this.delta_y;
            int i = 0;
            while (i < this.boxes.length) {
                this.boxes[i] = new Checkbox(100 + 25 * i, this.y);
                ++i;
            }
        }

        public void render() {
            AbilityTimer.this.fill(0);
            AbilityTimer.this.textSize(12.0f);
            AbilityTimer.this.text(this.name, 10.0f, this.y + 15);
            int i = 0;
            while (i < this.boxes.length) {
                this.boxes[i].render();
                ++i;
            }
        }
    }

    class Timerbar {
        int seconds;
        int x;
        int y;
        Timerdisplay td;

        Timerbar(int _seconds, int _x, int _y, Timerdisplay _td) {
            this.seconds = _seconds;
            this.x = _x;
            this.y = _y;
            this.td = _td;
        }

        public void render() {
            AbilityTimer.this.stroke(224);
            AbilityTimer.this.strokeWeight(1.0f);
            AbilityTimer.this.fill(255);
            AbilityTimer.this.triangle(this.x, this.y, this.x, this.y + 360, this.x + 75, this.y + 360);
            AbilityTimer.this.fill(240);
            AbilityTimer.this.triangle(this.x, this.y, this.x + 75, this.y, this.x + 75, this.y + 360);
            if (this.isOver()) {
                AbilityTimer.this.fill(0.0f, 255.0f, 0.0f);
                AbilityTimer.this.triangle(this.x, this.y, this.x, AbilityTimer.this.mouseY, this.x + AbilityTimer.this.mouseY / 5, AbilityTimer.this.mouseY);
            }
        }

        public int computeSeconds() {
            int pos = AbilityTimer.this.mouseY / 2;
            if (pos >= 50) {
                pos = pos / 5 * 5;
            }
            return pos;
        }

        public void textRender() {
            if (this.isOver()) {
                AbilityTimer.this.fill(0.0f, 255.0f, 0.0f);
                AbilityTimer.this.textSize(24.0f);
                AbilityTimer.this.text(String.valueOf(AbilityTimer.str((int)this.computeSeconds())) + "sec", this.x + 105, AbilityTimer.this.mouseY);
            }
        }

        public void press() {
            if (this.isOver()) {
                this.td.start(this.computeSeconds());
            }
        }

        public boolean isOver() {
            return AbilityTimer.this.mouseX > this.x && AbilityTimer.this.mouseX < this.x + 75 && AbilityTimer.this.mouseY > this.y && AbilityTimer.this.mouseY < this.y + 360;
        }
    }

    class Timerbutton {
        int seconds;
        int x;
        int y;
        Timerdisplay td;
        boolean b;

        Timerbutton(int _seconds, int _x, int _y, Timerdisplay _td) {
            this.seconds = _seconds;
            this.x = _x;
            this.y = _y;
            this.td = _td;
            this.b = false;
        }

        public void render() {
            AbilityTimer.this.stroke(0);
            AbilityTimer.this.strokeWeight(1.0f);
            AbilityTimer.this.fill(this.isOver() ? 240 : 255);
            AbilityTimer.this.rect(this.x, this.y, 40.0f, 30.0f);
            AbilityTimer.this.stroke(64);
            AbilityTimer.this.rect(this.x + 1, this.y + 1, 37.0f, 27.0f);
            AbilityTimer.this.stroke(128);
            AbilityTimer.this.rect(this.x + 2, this.y + 2, 37.0f, 27.0f);
            if (this.b) {
                AbilityTimer.this.fill(0.0f, 255.0f, 0.0f);
            } else {
                AbilityTimer.this.fill(0);
            }
            AbilityTimer.this.textSize(12.0f);
            AbilityTimer.this.text(String.valueOf(AbilityTimer.str((int)this.seconds)) + "s", this.x + 5, this.y + 20);
        }

        public void press() {
            if (this.isOver()) {
                this.td.start(this.seconds);
                this.b = true;
            }
        }

        public void release() {
            if (this.isOver()) {
                this.b = false;
            }
        }

        public boolean isOver() {
            return AbilityTimer.this.mouseX > this.x && AbilityTimer.this.mouseX < this.x + 40 && AbilityTimer.this.mouseY > this.y && AbilityTimer.this.mouseY < this.y + 30;
        }
    }

    class Timerdisplay {
        int x;
        int y;
        int endTime;
        boolean visible;

        Timerdisplay(int _x, int _y) {
            this.x = _x;
            this.y = _y;
            this.endTime = 0;
            this.visible = false;
        }

        public void start(int seconds) {
            this.endTime = AbilityTimer.this.millis() + 1000 * seconds;
            this.visible = true;
        }

        public boolean getVisible() {
            return this.visible;
        }

        public void render() {
            AbilityTimer.this.fill(0);
            AbilityTimer.this.rect(this.x, this.y, 80.0f, 30.0f);
            AbilityTimer.this.textSize(24.0f);
            int currentTime = AbilityTimer.this.millis();
            int remainTime = this.endTime - currentTime;
            String msg = "000.0";
            if (remainTime <= 0) {
                AbilityTimer.this.fill(255.0f, 0.0f, 0.0f);
                this.visible = false;
            } else {
                AbilityTimer.this.fill(0.0f, 255.0f, 0.0f);
                int sec = remainTime / 1000;
                int dec = remainTime / 100 % 10;
                String zeros = "";
                if (sec < 10) {
                    zeros = "00";
                } else if (sec < 100) {
                    zeros = "0";
                }
                msg = String.valueOf(zeros) + AbilityTimer.str((int)sec) + "." + AbilityTimer.str((int)dec);
            }
            AbilityTimer.this.text(msg, this.x + 5, this.y + 22);
        }

        public void press() {
            if (this.isOver()) {
                this.visible = false;
            }
        }

        public boolean isOver() {
            return AbilityTimer.this.mouseX > this.x && AbilityTimer.this.mouseX < this.x + 80 && AbilityTimer.this.mouseY > this.y && AbilityTimer.this.mouseY < this.y + 30;
        }
    }
}

