/*
 * Copyright (C) 1997 Ichiro Satoh
 * All Rights Reserved.
 * written by Ichiro Satoh
 *
 * This program was developed by Ichiro Satoh at Ochanomizu University 
 * as a part of a mobile object system, titled "AgentSpace". All the 
 * programs of the system is developed by Ichiro Satoh and all rights 
 * are reserved by Ichiro Satoh. 
 *
 * Permission to use, copy, modify and distribute this software and
 * its documentation is hereby granted, provided that both the
 * copyright notice and this permission notice appear in all copies of
 * the software, derivative works or modified versions, and any
 * portions thereof, and that both notices appear in supporting 
 * documentation.
 *
 * FREE USE OF THIS SOFTWARE IS ALLOWED IN ITS "AS IS" CONDITION.
 * BUT WITHOUT WARRANTY. THE AUTHORS DISCLAIM ANY LIABILITY OF ANY 
 * KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS 
 * SOFTWARE.
 */


import agentspace.*;
import java.lang.*;
import java.util.*;
import java.io.*;
import java.awt.*;
import java.net.*;
import java.applet.*;
import java.io.ObjectOutputStream;

public class AppletLoader extends Agent {
  static final long serialVersionUID = 6820728286501225842L;
  private AppletLoaderFrame alf;
  private MenuBar menuBar = new MenuBar();
  private Menu fileMenu = new Menu("File");
  private Applet theApplet = null;
  private String fName = null;
  private String dName = null;
  private int width = 300;
  private int height = 300;

  public AppletLoader() {}
  public void init() {}
  public void create() {
    initWindow();
    show();
  }
  public void arrive() {
    if (theApplet != null) {
      theApplet.init();
      theApplet.start();
    }
    setMenuBar(menuBar);
    pack();
    setSize(width, height);
    show();
  }
  public void dispatch(URL url) {
    width  = size().width; 
    height = size().height;
    dispose();
  }
  public void resume() {
    setMenuBar(menuBar);
    pack();
    resize(width, height);
    show();
  }
  public void suspend() {
    width  = size().width; 
    height = size().height;
    if (theApplet != null) {
      theApplet.stop();
      theApplet.destroy();
    }
    dispose();
  }
  public void duplicate(){
    width  = size().width; 
    height = size().height;
  }
  public void child(AgentIdentifier aid) {
    setMenuBar(menuBar);
    pack();
    setSize(width, height);
    show();
  }
  public void destroy() {
    if (theApplet != null) {    
      theApplet.destroy();
    }
    dispose();
  }

  private void initWindow() {
    setTitle("AppletLoader Agent");
    setBackground(Color.lightGray);
    fileMenu.add("Open");
    menuBar.add(fileMenu);
    setMenuBar(menuBar);
    setSize(width, height);
    show();
  }

  public void showApplet(Applet a) {
    System.out.println("showApplet()");
    add("Center", a);
    setSize(width, height);    
    show();
  }

  public Applet appletLoad(String fileName, String dirName) {
    if (fileName.startsWith("class ")) {
      fileName = fileName.substring(6, fileName.length());
    }
    try {
      AppletClassLoader loader = 
	new AppletClassLoader(dirName);
      Class c = loader.loadClass(fileName, true);
      Object obj = c.newInstance();
      if (obj != null && obj instanceof Applet) {
	Applet a = (Applet)obj;
	a.init();
	a.start();
	return a;
      }
      else {
	System.err.println("not instance of Applet");
      }
    } 
    catch (ClassNotFoundException e) {
      System.err.println(e);
    } 
    catch (IllegalAccessException e) {
      System.err.println(e);
    } 
    catch (InstantiationException e) {
      System.err.println(e);
    }
    return null;
  }

  public boolean action(Event e, Object what) { 
    if ("Open".equals(what)) {
      String fileName = null;
      if (getFileName( "*.class" ) != null) {
	theApplet = appletLoad(fName, dName);
	showApplet(theApplet);
	show();
      }
    }      
    return true;
  }

  public String getFileName(String pattern) {
    FileDialog fd = new FileDialog(this, "Load Class");
    fd.setFile(pattern);
    fd.setDirectory( "." );
    fd.show();
    if (fd.getDirectory() != null && fd.getFile() != null) {
      fName = fd.getFile();
      dName = fd.getDirectory();
      return fd.getDirectory() + fd.getFile();
    }
    else {
      return null;
    }
  }
}

class AppletClassLoader extends ClassLoader {
  private Hashtable cache = new Hashtable();
  private File classdirfirst;
  private File classdirsecond;

  AppletClassLoader(String netaddress) {
    super();
    classdirfirst = new File(netaddress);
  }

  private byte[] loadClassData(String name) 
  throws ClassNotFoundException {
    File target  = null;
    if(name.endsWith(".class")) {
      target  = new File(classdirfirst, name);
    }
    else {
      target  = new File(classdirfirst, name + ".class");
    }
    byte[] data = null;
    try {
      long bytecount = target.length();
      if (bytecount > 0) {
	data = new byte[(int)bytecount];
	FileInputStream in = new FileInputStream(target);
	in.read(data);
	in.close();
	return data;
      }
    } catch (IOException e) {
      throw new ClassNotFoundException(name);
    }
    return null;
  }

  public synchronized Class loadClass(String name, boolean resolve)
  throws ClassNotFoundException {
    Class c = (Class) cache.get(name);
    if (c != null) {
      return c;
    }
    if (name.equals("Agent.class") || name.equals("Agent")) {
      System.out.println("Special Loading "+name+" in CLASSPATH."); 
      try {
	c = findSystemClass(name);
	if (c != null) {
	  return c;
	}
      }
      catch (ClassNotFoundException ce){}
    }

    byte[] data = loadClassData(name);
    if (data != null ){
      c = defineClass(data, 0, data.length);
      if (resolve && c != null) {
	resolveClass(c);
      }
      cache.put(name, c);
    }
    if (c == null) {
      try {
	c = findSystemClass(name);
      }
      catch (ClassNotFoundException ce){}
    }
    if (c == null) {
      throw new ClassNotFoundException(name);
    }
    return c;
  }
}
