import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;

//public class AppletLoaderFrame extends Frame implements Serializable {
public class AppletLoaderFrame extends Frame {
//  static final long serialVersionUID = 2600132404308835531L;
  private TextArea editArea;
  private TextField statusField;
  private String fileName = null;
  private String buffer = null;
  private CheckboxMenuItem fontItems[];
  private CheckboxMenuItem styleItems[];
  private CheckboxMenuItem sizeItems[];

  private String clipboard;
  private MenuBar menuBar = new MenuBar();
  private Menu compileMenu = new Menu("Compile");
  private Menu fileMenu = new Menu("File");
  private Menu editMenu = new Menu("Edit");
  private Menu helpMenu = new Menu("Help");

  private void initWindow() {
    setBackground(Color.lightGray);
    fileMenu.add("Open");
    fileMenu.add("Save");
    fileMenu.add("Save As");
    fileMenu.add("Exit");
    menuBar.add(fileMenu);

    editMenu.add("Copy");
    editMenu.add("Paste");
    editMenu.add("Cut");
    editMenu.add("Select All");
    menuBar.add(editMenu);

    compileMenu.add("Compile");
    compileMenu.disable();
    menuBar.add(compileMenu);

    helpMenu.add("Version");
    menuBar.add(helpMenu);
    setMenuBar(menuBar);

    editArea = new TextArea(25, 80);
    editArea.setText(buffer);
 //   Font f = new Font("Courier", Font.PLAIN, 12);
 //   editArea.setFont(f);
    statusField = new TextField(80);
    statusField.setText(
	"Tiny Java AppletLoaderFrame (ver. 0.1) Copyright (C) 1997 Ichiro Satoh.");
    statusField.setEditable(false);
    add("South",statusField);
    add("Center",editArea);
    pack();
    show();
  }
	
  public AppletLoaderFrame() {
    super("TinJE (Tiny Java AppletLoaderFrame)");
    initWindow();
  }
	
  public void store() {
    buffer = editArea.getText();
    dispose();
  }

  public void load() {
    editArea.setText(buffer);
    show();
  }

  public void quit() {
    dispose();
  }

  private void checkJavaFile(String fname) {
    if (fname.endsWith(".java")) {
      compileMenu.enable();
    }
    else {
      compileMenu.disable();
    }
  }

  private String getFileName(boolean isOpen) {
    FileDialog dialog = 
      new FileDialog(this,
		     isOpen ? "Open File" : "Save File",
		     isOpen ? FileDialog.LOAD : FileDialog.SAVE);
    dialog.show();
    statusField.setText("File: "+
			dialog.getDirectory() + "/" + dialog.getFile());
    if (dialog.getDirectory() != null && dialog.getFile() != null) {
      return dialog.getDirectory() + dialog.getFile();
    }
    else {
      return null;
    }
  }
	
  private void loadFile(String fileName) {
    statusField.setText("Open File");
    FileReader reader;
    try { 
      reader = new FileReader(fileName); 
    }
    catch(Exception e) { 
      statusField.setText("Run-Time Error: "+e.toString()); 
      return; 
    }
    statusField.setText(reader.getEncoding().toString());
    StringBuffer text = new StringBuffer();
    try {
      char [] buf = new char[32];
      while (reader.ready()) {
	int len = reader.read(buf, 0, 32);
	if (len == -1) {
	  break;
	}
	text.append(buf, 0, len);
      }
      reader.close();
      checkJavaFile(fileName);
      setTitle(fileName);

      statusField.setText("Successful: File Open");
    }
    catch(Exception e) { 
      statusField.setText("Run-Time Error: "+e.toString()); 
    }
    editArea.setText(text.toString());
  }
	
  private void saveFile(String fileName) {
    statusField.setText("Save File");
    FileWriter writer;
    try { 
      writer = new FileWriter(fileName); 
    }
    catch(Exception e) { 
      statusField.setText("Run-Time Error: "+e.toString()); 
      return; 
    }
    statusField.setText(writer.getEncoding().toString());
    String text = editArea.getText();
    try	{
      writer.write(text, 0, text.length());
      writer.close();
      statusField.setText("Successful: File Save");
    }
    catch(Exception e) { 
      statusField.setText("Run-Time Error: "+e.toString()); }
  }

  public boolean action(Event e, Object what) { 
    statusField.setText(what.toString());
    if ("Open".equals(what)) {
      String newname = getFileName(true);
      if (newname != null) {
	loadFile(newname);
	fileName = newname;
      }
      return true;
    }      
    else if ("Save".equals(what)) {
      if (fileName != null) {
	saveFile(fileName);
      }
      return true;
    }
    else if ("Save As".equals(what)) {
      String newname = getFileName(false);
      if (newname != null) {
	saveFile(newname);
	fileName = newname;
      }
      return true;
    }
    else if ("Exit".equals(what)) {
      this.dispose();
      return true;
    }
    else if ("Version".equals(what)) {
      statusField.setText(
	"Tiny Java AppletLoaderFrame (ver. 0.1) Copyright (C) 1997 Ichiro Satoh.");
      return true;
    }
    else if ("Copy".equals(what)) {
      clipboard = editArea.getSelectedText();
      statusField.setText("Copy");
      return true;
    }
    else if ("Paste".equals(what)) {
      int start = editArea.getSelectionStart();
      int end = editArea.getSelectionEnd();
      if (start == end) {
        editArea.insertText(clipboard, start);
      }
      else {
        editArea.replaceText(clipboard, start, end);
      }
      statusField.setText("Paste");
      return true;
    }
    else if ("Cut".equals(what)) {
      clipboard = editArea.getSelectedText();
      editArea.replaceText("", editArea.getSelectionStart(), 
      editArea.getSelectionEnd());
      return true;
    }
    else if ("Select All".equals(what)) {
      editArea.selectAll();
      return true;
    }
    else if ("Compile".equals(what)) {
      try {
	saveFile(fileName);
	Process ps = Runtime.getRuntime().exec("javac " + fileName);
      }
      catch (Exception err) {
	statusField.setText("Unkonwn Error: Java Compilation");
      }
      return true;
    }
    return false;
  }
  
  public static void main(String args[]) {
    new AppletLoaderFrame();
  }
}

