/*
 * Copyright (C) 1997 Ichiro Satoh
 * All Rights Reserved.
 * written by Ichiro Satoh
 *
 * This program was developed by Ichiro Satoh at Ochanomizu University 
 * as a part of a mobile object system, titled "AgentSpace". All the 
 * programs of the system is developed by Ichiro Satoh and all rights 
 * are reserved by Ichiro Satoh. 
 *
 * Permission to use, copy, modify and distribute this software and
 * its documentation is hereby granted, provided that both the
 * copyright notice and this permission notice appear in all copies of
 * the software, derivative works or modified versions, and any
 * portions thereof, and that both notices appear in supporting 
 * documentation.
 *
 * FREE USE OF THIS SOFTWARE IS ALLOWED IN ITS "AS IS" CONDITION.
 * BUT WITHOUT WARRANTY. THE AUTHORS DISCLAIM ANY LIABILITY OF ANY 
 * KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS 
 * SOFTWARE.
 */

import agentspace.*;
import java.awt.*;
import java.io.*;
import java.util.*;
import java.net.*;

public class Calculator extends Agent implements Serializable {  
  public Calculator() {}
  public void init() {}
  public void create() {
    initFrame();
    show();
  }
  public void arrive() {
    show();
  }
  public void dispatch(URL url) {
    dispose();
  }
  public void resume() {
    dispose();
  }
  public void suspend() {
    dispose();
  }
  public void destroy() {
    dispose();
  }

  public void initFrame() {
    setTitle("Calculator");
    Font fb = new Font("Courier", Font.BOLD,  16);
    Font ft = new Font("Courier", Font.PLAIN, 16);

    display = new TextField("0");
    display.setFont(fb);
    display.setEditable(false);
    add("North", display);
    Panel p = new Panel();
    p.setLayout(new GridLayout(4, 4));
    for (int i = 0; i <= 9; i++) {
      p.setFont(fb);
      p.add(new Button("" + (char)('0' + i)));      
    }
    p.add(new Button("+"));
    p.add(new Button("-"));
    p.add(new Button("*"));
    p.add(new Button("/"));
    p.add(new Button("%"));
    p.add(new Button("="));
    add("Center", p);
    pack();
  }
  


  public boolean handleEvent(Event evt) {  
    if (evt.id == Event.WINDOW_DESTROY) {
      dispose();
    }
    return super.handleEvent(evt);
  }
  
  public boolean action(Event evt, Object arg) {  
    if (arg instanceof String) {  
      String s = (String) arg;
      if ('0' <= s.charAt(0) && s.charAt(0) <= '9') {  
	if (start) {
	  display.setText(s);
	}
	else {
	  display.setText(display.getText() + s);
	}
	start = false;
      }
      else {  
	if (start) {  
	  if (s.equals("-")) { 
	    display.setText(s); start = false; 
	  }
	  else {
	    op = s;
	  }
	}
	else {
	  calculate((new Integer(display.getText())).intValue());
	  op = s;
	  start = true;
	}
      }
    }
    else {
      return super.action(evt, arg);
    }
    return true;
  }

  public void calculate(int n) { 
    if (op == "+") arg += n;
    else if (op == "-") {
      arg -= n;
    }
    else if (op == "*") {
      arg *= n;
    }
    else if (op == "/") {
      arg /= n;
    }
    else if (op == "%") {
      arg %= n;
    }
    else if (op == "=") {
      arg = n;
    }
    display.setText("" + arg);
  }
  
  public static void main(String[] args) {  
    Frame f = new Calculator();
    f.resize(300, 200);
    f.show();  
  }
   private TextField display;
   private int arg = 0;
   private String op = "=";
   private boolean start = true;
}



