/*
 * Chat.java	98/7/2
 * 
 * Copyright (c) 1998 Ichiro Satoh All Rights Reserved.
 * 
 * Permission to use, copy, modify, and distribute this 
 * software and its documentation for NON-COMMERCIAL purposes
 * and without fee is hereby granted provided that this 
 * copyright notice appears in all copies. 
 */

import agentspace.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;
import java.net.*;

public class Chat extends Agent 
implements ActionListener, WindowListener, KeyListener {
  private TextArea readArea;
  private TextArea writeArea;
  private TextField target;
  private Button startButton;
  private int width  = 600;
  private int height = 400;
  private String readbuffer;
  private String writebuffer;
  private String sendaddress = "localhost";
  private String recvaddress = "localhost";
  private int sendport = 5010;
  private int recvport = 5010;
  private boolean isChild = false;
  private transient ChatServer server;

  public Chat() {}
  public void init() {}
  public void create() {
    initWindow();
  }
  public void arrive() {
    readArea.setText(readbuffer);
    writeArea.setText(writebuffer);
    AgentContext ac = getAgentContext();
//  recvaddress = ac.getCurrentHost().getHost();
    server = new ChatServer(recvaddress, recvport, this);
    startButton.disable();
    pack();
    resize(width, height);
    show();
  }
  public void dispatch(URL url) {
    width  = size().width; 
    height = size().height;
    readbuffer = readArea.getText();
    writebuffer = writeArea.getText();
    dispose();
  }
  public void resume() {
    readArea.setText(readbuffer);
    writeArea.setText(writebuffer);
    pack();
    resize(width, height);
    show();
  }
  public void suspend() {
    width  = size().width; 
    height = size().height;
    readbuffer = readArea.getText();
    writebuffer = writeArea.getText();
    dispose();
  }
  public void destroy() {
    dispose();
  }
  public void duplicate(){
    width  = size().width; 
    height = size().height;
    readbuffer = readArea.getText();
    writebuffer = writeArea.getText();
    dispose();
  }
  public void parent(AgentIdentifier caid) {
    readArea.setText(readbuffer);
    writeArea.setText(writebuffer);
    sendport = 5010;
    recvport = 5011;
    sendaddress = target.getText();
    AgentContext ac = getAgentContext();
    recvaddress = ac.getCurrentHost().getHost();
    server = new ChatServer(recvaddress, recvport, this);
    startButton.disable();
    pack();
    resize(width, height);
    show();
  }
  public void child(AgentIdentifier paid) {
    isChild = true;
    AgentContext ac = getAgentContext();
    sendaddress = ac.getCurrentHost().getHost();
    recvaddress = target.getText();
    sendport = 5011;
    recvport = 5010;
    dispose();
    ac.dispatch(recvaddress);
  }
  public void keyPressed(KeyEvent e) {}
  public void keyReleased(KeyEvent e) {}
  public void keyTyped(KeyEvent e) {
    send(sendaddress, sendport, e.getKeyChar());
  }

  public void initWindow() {
    AgentContext ac = getAgentContext();
    setTitle("Chat");
    setBackground(Color.lightGray);
    readArea = new TextArea(8, 50);
    readArea.setText("");
    readArea.setEditable(false);
    writeArea = new TextArea(8, 50);
    writeArea.setText("");
    writeArea.addKeyListener(this);
    Panel panel = new Panel();
    startButton = new Button("Start");
    startButton.addActionListener(this);
    panel.add(startButton);
    target = new TextField("", 40);
    target.setText(ac.getCurrentHost().getHost());
    panel.add(target);

    Font f = new Font("Dialog", Font.PLAIN, 14);
    readArea.setFont(f);
    writeArea.setFont(f);
    add("North",readArea);
    add("Center",panel);
    add("South",writeArea);
    addWindowListener(this);
    resize(width, height);
    pack();
    show();
  }
  public void append(String msg) {
    readArea.append(msg);
  }

  public void windowOpened(WindowEvent e) {}
  public void windowActivated(WindowEvent e) {}
  public void windowDeactivated(WindowEvent e) {}
  public void windowClosed(WindowEvent e) {}
  public void windowIconified(WindowEvent e){}
  public void windowDeiconified(WindowEvent e){}
  public void windowClosing(WindowEvent e){
    dispose();
    AgentContext ac = getAgentContext();
    ac.send("destroy");
  }

  public void actionPerformed(ActionEvent e) {
    String command = e.getActionCommand();
    if (e.getID() == WindowEvent.WINDOW_CLOSING) {
      dispose();
      AgentContext ac = getAgentContext();
      ac.send("destroy");
    }
    else if (command.equals("Start")) {
      sendaddress = target.getText();
      if (sendaddress != null) {
	AgentContext ac = getAgentContext();
	ac.duplicate();
      }
    }
  }

  public void send(String hostname, int port, char ch) {
    try{
      InetAddress sAdr;
      sAdr = InetAddress.getByName(hostname);
      DatagramSocket theSock = new DatagramSocket();
      byte[] data = new byte[2];
      data[0] = (byte)ch;
      int len = data.length;
      DatagramPacket packet = new DatagramPacket(data, len, sAdr, port);
      theSock.send(packet);
    }catch(Exception e){
      System.out.println("Exception: "+e);
      return;
    }
  }

  public static void main(String args[]) {
    Chat chat = new Chat();
    chat.init();
    chat.create();
  }
}


