/*
 * ChatServer.java	98/7/3
 * 
 * Copyright (c) 1998 Ichiro Satoh All Rights Reserved.
 * 
 * Permission to use, copy, modify, and distribute this 
 * software and its documentation for NON-COMMERCIAL purposes
 * and without fee is hereby granted provided that this 
 * copyright notice appears in all copies. 
 */

import agentspace.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;
import java.net.*;

public class ChatServer extends Thread {
  String hostname = null;
  int port = -1;
  Chat chat;
  transient Thread aThread;
  public ChatServer(String hostname, int port, Chat chat) {
    this.hostname = hostname;
    this.port = port;
    this.chat = chat;
    aThread = new Thread(this);
    aThread.start();
  }
  public void end() {
    aThread.stop();
  }
  public void run() {
    System.out.println("Server starting"+port);
    receiver(hostname, port);
  }
  public void receiver(String hostname, int port) {
    try{
      DatagramSocket theSock;
      theSock = new DatagramSocket(port);
      System.out.println("localPort="+port);
      while(true) {
	String msg = null;
	DatagramPacket packet;
	byte[] buf= new byte[2];
	packet = new DatagramPacket(buf, 2);
	theSock.receive(packet);
	chat.append(new String(packet.getData()));
      }
    }
    catch(Exception e){
      System.out.println("Exception: "+e);
    }
  }
}
