/*
 * Copyright (C) 1997 Ichiro Satoh
 * All Rights Reserved.
 * written by Ichiro Satoh
 *
 * This program was developed by Ichiro Satoh at Ochanomizu University 
 * as a part of a mobile object system, titled "AgentSpace". All the 
 * programs of the system is developed by Ichiro Satoh and all rights 
 * are reserved by Ichiro Satoh. 
 *
 * Permission to use, copy, modify and distribute this software and
 * its documentation is hereby granted, provided that both the
 * copyright notice and this permission notice appear in all copies of
 * the software, derivative works or modified versions, and any
 * portions thereof, and that both notices appear in supporting 
 * documentation.
 *
 * FREE USE OF THIS SOFTWARE IS ALLOWED IN ITS "AS IS" CONDITION.
 * BUT WITHOUT WARRANTY. THE AUTHORS DISCLAIM ANY LIABILITY OF ANY 
 * KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS 
 * SOFTWARE.
 */

import agentspace.*;
import java.awt.*;
import java.io.*;
import java.net.*;
import java.util.*;

public class Clock extends Agent {
  private int seconds = 0;
  private final int LOCAL = 16;
  private final int XLOC = 10;
  private final int YLOC = 30;
  transient private ClockTick ct;
  public static void main(String[] args) {
    Clock c = new Clock();
    c.init();
    c.create();
  }
  public Clock() {}
  public void init() {}
  public void create() {
    setTitle("Clock Agent");
//    setBackground(Color.white);
    ct = new ClockTick(this, 1000);
    resize(120, 140);
    show();
  }
  public void arrive() {
    Toolkit.getDefaultToolkit().beep();
    ct = new ClockTick(this, 1000);
    show();
  }
  public void dispatch(URL url) {
    ct.destroy();
    dispose();
  }
  public void resume() {
    ct = new ClockTick(this, 1000);
    show();
  }
  public void suspend() {
    ct.destroy();
    dispose();
  }
  public void destroy() {
    ct.destroy();
    dispose();
  }
  public void duplicate(){
    ct.destroy();
    System.out.println("Duplicate: Stop thread");
    dispose();
  }
  public void child(AgentIdentifier paid) {
    ct = new ClockTick(this, 1000);
    show();
  }
  public void parent(AgentIdentifier caid) {
    ct = new ClockTick(this, 1000);
    show();
  }
  public void paint(Graphics g) {
    double hourAngle = 2 * Math.PI * (seconds - 3 * 60 * 60) / (12 * 60 * 60);
    double minuteAngle = 2 * Math.PI * (seconds - 15 * 60) / (60 * 60);
    double secondAngle = 2 * Math.PI * (seconds - 15) / 60;
    g.setColor(Color.darkGray);
    g.fillOval(0+XLOC, 0+YLOC, 100, 100);
    g.setColor(Color.red);
    g.drawLine(50+XLOC, 50+YLOC, 50+XLOC + (int)(30 * Math.cos(hourAngle)), 
	       50+YLOC + (int)(30 * Math.sin(hourAngle)));
    g.setColor(Color.cyan);
    g.drawLine(50+XLOC, 50+YLOC, 50+XLOC + (int)(40 * Math.cos(minuteAngle)), 
	       50+YLOC + (int)(40 * Math.sin(minuteAngle)));
    g.setColor(Color.white);
    g.drawLine(50+XLOC, 50+YLOC, 50+XLOC + (int)(45 * Math.cos(secondAngle)), 
	       50+YLOC + (int)(45 * Math.sin(secondAngle)));
  }
  public void tick() {
    Date d = new Date();
    seconds = (d.getHours() - LOCAL + 8)* 60 * 60 + d.getMinutes() * 60
      + d.getSeconds();
     repaint();
    if (d.getMinutes() == 0) {
      Toolkit.getDefaultToolkit().beep();
    }
  }
}

class ClockTick extends Thread implements Serializable {
  private int interval;
  Clock theClock;
  Thread t;
  public ClockTick(Clock c, int i) {
    theClock = c;
    interval = i;
//  setDaemon(true);
    t = new Thread(this);
    t.start();
  }
  public void destroy() {
    t.stop();
  }
  public void run() {
    while (true) {
      try {
	sleep(interval);
      } 
      catch(InterruptedException e) {}
      theClock.tick();
    }
  }
}




