/*
 * Copyright (C) 1997 Ichiro Satoh
 * All Rights Reserved.
 * written by Ichiro Satoh
 *
 * This program was developed by Ichiro Satoh at Ochanomizu University 
 * as a part of a mobile object system, titled "AgentSpace". All the 
 * programs of the system is developed by Ichiro Satoh and all rights 
 * are reserved by Ichiro Satoh. 
 *
 * Permission to use, copy, modify and distribute this software and
 * its documentation is hereby granted, provided that both the
 * copyright notice and this permission notice appear in all copies of
 * the software, derivative works or modified versions, and any
 * portions thereof, and that both notices appear in supporting 
 * documentation.
 *
 * FREE USE OF THIS SOFTWARE IS ALLOWED IN ITS "AS IS" CONDITION.
 * BUT WITHOUT WARRANTY. THE AUTHORS DISCLAIM ANY LIABILITY OF ANY 
 * KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS 
 * SOFTWARE.
 */

import java.lang.*;
import java.util.*;
import java.io.*;
import agentspace.*;

class FileClassLoader extends ClassLoader {
  private Hashtable cache = new Hashtable();
  private File classdirfirst;
  private File classdirsecond;

  FileClassLoader(String netaddress) {
    super();
    classdirfirst = new File(netaddress);
  }

  private byte[] loadClassData(String name) 
  throws ClassNotFoundException {
    File target  = null;
    if(name.endsWith(".class")) {
      target  = new File(classdirfirst, name);
    }
    else {
      target  = new File(classdirfirst, name + ".class");
    }
    byte[] data = null;
    try {
      long bytecount = target.length();
      if (bytecount > 0) {
	data = new byte[(int)bytecount];
	FileInputStream in = new FileInputStream(target);
	in.read(data);
	in.close();
	return data;
      }
    } catch (IOException e) {
      throw new ClassNotFoundException(name);
    }
    return null;
  }

  public synchronized Class loadClass(String name, boolean resolve)
  throws ClassNotFoundException {
    Class c = (Class) cache.get(name);
    if (c != null) {
      return c;
    }
    if (name.equals("Agent.class") || name.equals("Agent")) {
      System.out.println("Special Loading "+name+" in CLASSPATH."); 
      try {
	c = findSystemClass(name);
	if (c != null) {
	  return c;
	}
      }
      catch (ClassNotFoundException ce){}
    }

    byte[] data = loadClassData(name);
    if (data != null ){
      c = defineClass(data, 0, data.length);
      if (resolve && c != null) {
	resolveClass(c);
      }
      cache.put(name, c);
    }
    if (c == null) {
      try {
	c = findSystemClass(name);
      }
      catch (ClassNotFoundException ce){}
    }
    if (c == null) {
      throw new ClassNotFoundException(name);
    }
    return c;
  }
}
