/*
 * Copyright (C) 1997 Ichiro Satoh
 * All Rights Reserved.
 * written by Ichiro Satoh
 *
 * This program was developed by Ichiro Satoh at Ochanomizu University 
 * as a part of a mobile object system, titled "AgentSpace". All the 
 * programs of the system is developed by Ichiro Satoh and all rights 
 * are reserved by Ichiro Satoh. 
 *
 * Permission to use, copy, modify and distribute this software and
 * its documentation is hereby granted, provided that both the
 * copyright notice and this permission notice appear in all copies of
 * the software, derivative works or modified versions, and any
 * portions thereof, and that both notices appear in supporting 
 * documentation.
 *
 * FREE USE OF THIS SOFTWARE IS ALLOWED IN ITS "AS IS" CONDITION.
 * BUT WITHOUT WARRANTY. THE AUTHORS DISCLAIM ANY LIABILITY OF ANY 
 * KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS 
 * SOFTWARE.
 */

import agentspace.*;

import java.lang.*;
import java.util.*;
import java.io.*;
import java.awt.*;
import java.net.*;
import java.applet.*;

public class Gifshow extends Agent {
  private MenuBar menuBar = new MenuBar();
  private Menu fileMenu = new Menu("File");
  private String fName = null;
  private String dName = null;
  private Image theImage = null;
  private byte[] byteImage = null;
  private int width  = -1;
  private int height = -1;

  public static void main(String[] args) {
    Gifshow g = new Gifshow();
    g.init();
    g.create();
  }
  public Gifshow() {}
  public void init() {}
  public void create() {
    setTitle("Image Viewer Agent");
    setBackground(Color.lightGray);
    fileMenu.add("GIF Open");
    fileMenu.add("JPEG Open");
    menuBar.add(fileMenu);
    setMenuBar(menuBar);
    resize(200, 100);
    show();
  }
  public void arrive() {
    show();
  }
  public void dispatch(URL url) {
    theImage = null;
    dispose();
  }
  public void resume() {
    show();
  }
  public void suspend() {
    theImage = null;
    dispose();
  }
  public void destroy() {
    dispose();
  }
  public void duplicate(){
    theImage = null;
    dispose();
  }
  public void child(AgentIdentifier paid) {
    show();
  }
  public void parent(AgentIdentifier caid) {
    show();
  }
  public boolean handleEvent(Event evt) {
    if (evt.id == Event.WINDOW_DESTROY) {
      dispose();
      AgentContext ac = getAgentContext();
      ac.send("destroy");
    }
    return super.handleEvent(evt);
  }
  public void update(Graphics g) {
    if (byteImage == null) {
      return;
    }
    if (theImage == null) {
      theImage = Toolkit.getDefaultToolkit().createImage(byteImage);
    }
    if (width < 0 && height < 0) {
      width  = theImage.getWidth(this);
      height = theImage.getHeight(this);
      resize(width, height);
    }
    else {
      width  = size().width; 
      height = size().height;
    }
    g.drawImage(theImage, 0, 20, width, height, this);
  }
  public void paint(Graphics g) {
    update(g);
  }
  public boolean action(Event e, Object what) { 
    if ("GIF Open".equals(what)) {
      String fileName = null;
      if ((fileName = getFileName( "*.gif" )) != null) {
	byteImage = fileToByteArray(fileName);
	theImage = Toolkit.getDefaultToolkit().createImage(byteImage);
      }
      dispose();
      show();
      return true;
    }      
    if ("JPEG Open".equals(what)) {
      String fileName = null;
      if ((fileName = getFileName( "*.jpg" )) != null) {
	byteImage = fileToByteArray(fileName);
	theImage = Toolkit.getDefaultToolkit().createImage(byteImage);
      }
      dispose();
      show();
      return true;
    }      
    return false;
  }

  public String getFileName(String pattern) {
    FileDialog fd = new FileDialog(this, "Load Image File");
    fd.setFile(pattern);
    fd.setDirectory( "." );
    fd.show();
    if (fd.getDirectory() != null && fd.getFile() != null) {
      fName = fd.getFile();
      dName = fd.getDirectory();
      return fd.getDirectory() + fd.getFile();
    }
    else {
      return null;
    }
  }

  public byte[] fileToByteArray(String fileName) {
    byte[] data = null;
    try {
      FileInputStream inStream = new FileInputStream(fileName);
      ByteArrayOutputStream byteout = new ByteArrayOutputStream();
      byte[] bytes = new byte[1024];
      int count;
      while ((count = inStream.read(bytes)) != -1) {
	byteout.write(bytes, 0, count);
      }
      data = byteout.toByteArray();
      byteout.close();
      inStream.close();
    } catch (IOException e) {
      e.printStackTrace();
    }
    return data;
  }
}
