import agentspace.*;
import java.lang.*;
import java.io.*;
import java.net.*;
import java.util.*;
import java.awt.*;

public class Grep extends Agent {
  URL birthURL = null;
  Panel searchPanel = new Panel();
  Panel buttonPanel = new Panel();
  Panel resultPanel = new Panel();
  TextField fileField;
  TextField patternField;
  TextField addressField;
  String pattern  = "String";
  String filename = "Editor.java";
  String address = "";
  String[] result;

  public Grep() {}
  public void init() {}
  public void create() {
    AgentContext ac = getAgentContext();
    birthURL = ac.getCurrentHost();
    address = birthURL.getHost();
    initWindow();
  }
  public void arrive() {
    AgentContext ac = getAgentContext();
    URL arriveURL = ac.getCurrentHost();
    if (arriveURL.equals(birthURL)) {
      resultWindow();
    }
    else {
//      pattern  = patternField.getText();
//      filename = fileField.getText();
      result = search(filename, pattern);
      ac.send("dispatch", birthURL.getHost());
    }
  }
  public void dispatch(URL url) {
    AgentContext ac = getAgentContext();
    URL arriveURL = ac.getCurrentHost();
    if (arriveURL.equals(birthURL)) {
      pattern  = patternField.getText();
      filename = fileField.getText();
      address  = addressField.getText();
    }
    dispose();
  }
  public void resume() {}
  public void suspend() {}
  public void destroy() {}
  public void duplicate(){}
  public void child(AgentIdentifier paid) {}
  public void parent(AgentIdentifier caid) {}

  public void initWindow() {
    setTitle("Mobile Grep Agent");
    setBackground(Color.lightGray);
    Font f1 = new Font("Helvetica", Font.BOLD, 12);
    Font f2 = new Font("TimesRoman", Font.BOLD, 12);
    Font f3 = new Font("Courier", Font.BOLD, 12);
    fileField = new TextField(filename, 20);
    fileField.setFont(f3);
    patternField = new TextField(pattern, 20);
    patternField.setFont(f3);
    addressField = new TextField(address, 20);
    addressField.setFont(f3);

    Label patternLabel = new Label("Pattern:");
    Label fileLabel = new Label("File:");
    Label addressLabel = new Label("Address:");

    fileLabel.setFont(f2);
    patternLabel.setFont(f2);
    addressLabel.setFont(f2);

    Button quitButton = new Button("QUIT");
    Button sendButton = new Button("SEND");

    searchPanel.add(patternLabel);
    searchPanel.add(patternField);
    searchPanel.add(fileLabel);
    searchPanel.add(fileField);
    buttonPanel.add("West", addressLabel);
    buttonPanel.add("West", addressField);
    buttonPanel.add("East", sendButton);
    buttonPanel.add("East", quitButton);

    add("North",  searchPanel);
    add("Center", buttonPanel);
    add("South",  resultPanel);
    pack();
    show();
  }
  
  public String[] search(String fname, String pat) {
    Vector list = new Vector();
    DataInputStream in = null;
    try {
      in = new DataInputStream(new FileInputStream(fname));
    }
    catch (IOException e) {
      System.err.println(e);
    }
    String line = null;
    try {
      while((line = in.readLine()) != null) {
	if (line.indexOf(pat) != -1) {
	  list.addElement(line);
	  continue;
	}
      }
    }
    catch (IOException e) {
      System.err.println(e);
    }
    result = new String[list.size()];
    for (int i = 0 ; i < list.size() ; i++ ) {
      result[i] = (String)list.elementAt(i);
    }
    return result;
  }

  public void resultWindow() {
    String resultText = "";
    for (int i = 0 ; i < result.length ; i++ ) {
      resultText = resultText + result[i] + "\n";
    }
    TextArea rta = new TextArea(20, 80);
    rta.setText(resultText);
    rta.setEditable(false);
    rta.setBackground(Color.white);
    remove(resultPanel);
    resultPanel = new Panel();
    resultPanel.add(rta);
    add(resultPanel);
    pack();
    show();
  }

  public void send() {
    pattern  = patternField.getText();
    filename = fileField.getText();
    address  = addressField.getText();
    AgentContext ac = getAgentContext();
    ac.send("dispatch", address);
  }

  public boolean action(Event evt, Object what) {
    if ("SEND".equals(what)) {
      send();
      return true;
    }
    if ("QUIT".equals(what)) {
      AgentContext ac = getAgentContext();
      ac.send("destroy");
      dispose();
      return true;
    }
    return false;
  }

  public boolean handleEvent(Event evt) {
    if (evt.id == Event.WINDOW_DESTROY) {
      dispose();
      AgentContext ac = getAgentContext();
      ac.send("destroy");
    }
    return super.handleEvent(evt);
  }
}


