/*
 * ImageMail.java	97/10/05
 * 
 * Copyright (c) 1997 Ichiro Satoh All Rights Reserved.
 * 
 */
import agentspace.*;
import java.awt.*;
import java.net.*;
import java.util.*;
import java.lang.*;

public class ImageMail extends Agent {
  private AgentIdentifier aid = null;
  static final int MAXPOINTS = 1000;
  int xpoints[] = new int[MAXPOINTS];
  int ypoints[] = new int[MAXPOINTS];
  int xprevs[]  = new int[MAXPOINTS];
  int yprevs[]  = new int[MAXPOINTS];
  int xlasts[]  = new int[MAXPOINTS];
  int ylasts[]  = new int[MAXPOINTS];
  int lastx = -1;
  int lasty = -1;
  int prevx = -1;
  int prevy = -1;
  int npoints = 0;
  private String title = "";
  private String address = "";
  private TextField addressField;
  
  public ImageMail() {}
  public void init() {}
  public void create() {
    setTitle("ImageMail Agent");
    resize(400, 400);
    Panel buttonPanel = new Panel();
    buttonPanel.setLayout (new FlowLayout());
    buttonPanel.add(new Button("Send To:"));
    Font f = new Font("Dialog", Font.PLAIN, 12);
    addressField = new TextField(address, 12);
    buttonPanel.add(addressField);
    add("North", buttonPanel);
    add("South", new Button("Clear"));
    setBackground(Color.white);
    for (int i = 0 ; i < MAXPOINTS ; i++ ) {
      xprevs[i] = 0;
      yprevs[i] = 0;
      xlasts[i] = 0;
      ylasts[i] = 0;
    }
    show();
  }

  public void destroy() {
    removetitle();
    dispose();
  }
  public void arrive() {
    addtitle();
    show();
  }
  public void suspend() {
    removetitle();
    dispose();
  }
  public void resume() {
    addtitle();
    show();
  }
  public void child(AgentIdentifier aid) {
    show();
  }
  public void dispatch(URL url) {
    removetitle();
    dispose();
  }

  public void update(Graphics g) {
    for (int i = 0 ; i < npoints ; i++ ) {
      g.setColor(Color.black);
      if (i == 0) {
	g.drawLine(xlasts[0], ylasts[0], xlasts[0], ylasts[0]);	
      }
      else if (xlasts[i] == -1 && ylasts[i] == -1) {
	g.drawLine(xprevs[i], yprevs[i], xprevs[i], yprevs[i]);
      }
      else {
	g.drawLine(xprevs[i-1], yprevs[i-1], xlasts[i], ylasts[i]);
      }
    }
  }

  public void paint(Graphics g) {
    update(g);
  }

  public boolean mouseDown (Event evt, int x, int y) {
    if (npoints < MAXPOINTS) {
      xlasts[npoints] = -1;
      ylasts[npoints] = -1;
      xprevs[npoints] = x;
      yprevs[npoints] = y;
      npoints++;
    }
    return true;
  }

  public boolean mouseDrag(Event evt, int x, int y) {
    if ((x != lastx || y != lasty) && npoints < MAXPOINTS) {
      xlasts[npoints] = x;
      ylasts[npoints] = y;
      xprevs[npoints] = x;
      yprevs[npoints] = y;
      npoints++;
      repaint();
    }
    return true;
  }

  public boolean action(Event e, Object what) { 
    if ("Clear".equals(what)) {
      npoints = 0;
      dispose();
      show();
      return true;
    }
    else if ("Send To:".equals(what)) {
      move_as_new_mail(addressField.getText());
    } 
    return false;
  }

  public void move_as_new_mail(String address) {
    AgentContext ac = getAgentContext();
    ac.send("dispatch", address);
  }
  public void move_as_reply_mail(String address) {
    AgentContext ac = getAgentContext();
    ac.send("dispatch", address);
  }
  public void move_only(String address) {
    AgentContext ac = getAgentContext();
    ac.send("dispatch", address);
  }
  public void trash() {
    AgentContext ac = getAgentContext();
    ac.send("destroy");
  }
  public static void main (String args[]) {
    ImageMail painter = new ImageMail();
  }
  private void removetitle() {
    AgentContext ac = getAgentContext();
    Enumeration e = ac.getAgents("MailBox");
    while(e.hasMoreElements()) {
      aid = (AgentIdentifier)e.nextElement();
      String title = "Hello, Dear Duke.." + " from: " 
	+  ac.getIdentifier() + " at " +  ac.getCurrentHost().getHost();
      ac.send(aid, "remove", ac.getIdentifier());
    }
  }
  private void addtitle() {
    AgentContext ac = getAgentContext();
    Enumeration e = ac.getAgents("MailBox");
    while(e.hasMoreElements()) {
      aid = (AgentIdentifier)e.nextElement();
      ac.send(aid, "add", ac.getIdentifier(), title);
    }
  }
}
