import agentspace.*;
import java.io.*;
import java.net.*;
import java.awt.*;

public class LifeGame extends Agent {
  CellGround cg;
  Dimension groundSize;
  int cellSize; 
  Scrollbar vert,horz;
  Button buttonNext;
  String IDbuttonNext="next";
  Button buttonStart;
  String IDbuttonStart="start";
  Button buttonStop;
  String IDbuttonStop="stop";
  Checkbox checkWall;
  String IDcheckWall="wall";
  Label labelPositionX,labelPositionY;
  boolean flag = false;
  transient private ThreadTick tt;
  public LifeGame(){}
  public void init(){}

  public void create(){
    setTitle("Life Game Agent");
    setBackground(Color.lightGray);
    int w = 300;
    int h = 300;
    groundSize=new Dimension();
    groundSize.width =100;
    groundSize.height=100;
    cellSize=8;
//    setLayout(null);
    Panel p = new Panel();
    cg=new CellGround(groundSize,cellSize);
    p.add(cg);
    cg.reshape(0,20,w-15,h-55);
    buttonNext=new Button(IDbuttonNext);
    p.add(buttonNext);
    buttonNext.reshape(0,h-20,40,20);
    
    buttonStart=new Button(IDbuttonStart);
    p.add(buttonStart);
    buttonStart.reshape(50,h-20,40,20);
    
    buttonStop=new Button(IDbuttonStop);
    p.add(buttonStop);
    buttonStop.reshape(100,h-20,40,20);
    
    checkWall=new Checkbox(IDcheckWall);
    p.add(checkWall);
    checkWall.reshape(150,h-20,50,20);
    
    labelPositionX=new Label("");
    p.add(labelPositionX);
    labelPositionX.reshape(0,0,30,20);
    
    labelPositionY=new Label("");
    p.add(labelPositionY);
    labelPositionY.reshape(35,0,30,20);
    
    horz=new Scrollbar(Scrollbar.HORIZONTAL);
    vert=new Scrollbar(Scrollbar.VERTICAL);
    horz.reshape(0,h-35,w-15,15);
    vert.reshape(w-15,20,15,h-55);
//    p.add(horz);
//    p.add(vert);

    add("Center", p);

    buttonNext.enable();
    buttonStart.enable();
    buttonStop.disable();
    cg.setChangeable(true);
    cg.setDrawGrid(true);

    setSize(300,310);
    show();
  }
  public void arrive() {
    if (flag) {
      tt = new ThreadTick(this, 50);
    }
    show();
  }
  public void dispatch(URL url) {
    if (tt != null) {
      tt.destroy();
    }
    dispose();
  }
  public void resume() {
    if (flag) {
      tt = new ThreadTick(this, 50);
    }
    show();
  }
  public void suspend() {
    if (tt != null) {
      tt.destroy();
    }
    dispose();
  }
  public void destroy() {
    if (tt != null) {
      tt.destroy();
    }
    dispose();
  }
  public void duplicate(){
    if (tt != null) {
      tt.destroy();
    }
    dispose();
  }
  public void child(AgentIdentifier paid) {
    tt = new ThreadTick(this, 50);
    show();
  }
  public void parent(AgentIdentifier caid) {
    tt = new ThreadTick(this, 50);
    show();
  }
  public void tick(){
    int n;
    n=cg.size().width/cellSize;
    if ( groundSize.width<n ) n=groundSize.width;
    horz.setValues(0,0,0,groundSize.width-n);
    
    n=cg.size().height/cellSize;
    if ( groundSize.height<n ) n=groundSize.height;
    vert.setValues(0,0,0,groundSize.height-n);
    
    buttonNext.enable();
    buttonStart.enable();
    buttonStart.disable();
    cg.next();
  }
  
  public boolean action(Event e,Object o){
    if (e.target instanceof Button){
      Button b=(Button)e.target;
      if (IDbuttonNext.equals(b.getLabel())){
	cg.next();
	return true;
      }
      if (IDbuttonStart.equals(b.getLabel())){
	buttonNext.disable();
	buttonStart.disable();
	buttonStop.enable();
	cg.setChangeable(false);
	cg.setDrawGrid(false);
	if (tt == null) {
	  tt = new ThreadTick(this, 50);
	}
	flag = true;
	return true;
      }
      if (IDbuttonStop.equals(b.getLabel())){
	buttonNext.enable();
	buttonStart.enable();
	buttonStop.disable();
	cg.setChangeable(true);
	cg.setDrawGrid(true);
	if (tt != null) {
	  tt.destroy();
	}
	flag = false;
	tt = null;
	return true;
      }
    }
    if (e.target instanceof Checkbox){
      Checkbox c=(Checkbox)e.target;
      if (IDcheckWall.equals(c.getLabel())){
	cg.setWall(c.getState());
	return true;
      }
    }
    return false;
  }
  
  public boolean handleEvent(Event e){
    if (e.id == Event.WINDOW_DESTROY) {
      dispose();
      AgentContext ac = getAgentContext();
      ac.send("destroy");
    }
    else if (e.target instanceof Scrollbar){
      cg.setTranslate(horz.getValue(),vert.getValue());
      return true;
    }
    return super.handleEvent(e);
  }
  public boolean mouseMove(Event e,int x,int y){
    if (cg.cursorOnCellGround(x-0,y-20)){
      labelPositionX.setText(""+cg.cursorPosX);
      labelPositionY.setText(""+cg.cursorPosY);
    }else{
      labelPositionX.setText("");
      labelPositionY.setText("");
    }
    return true;
  }

/*  
  public void stop(){
    buttonNext.enable();
    buttonStart.enable();
    buttonStop.disable();
    cg.setChangeable(true);
    cg.setDrawGrid(true);
    if (th!=null){
      th.stop();
      th=null;
    }
  }
*/  
}

class ThreadTick extends Thread implements Serializable {
  private int interval;
  LifeGame theLifeGame;
  Thread t;
  public ThreadTick(LifeGame l, int i) {
    theLifeGame = l;
    interval = i;
    t = new Thread(this);
    t.start();
  }
  public void destroy() {
    t.stop();
  }
  public void run() {
    while (true) {
      try {
	sleep(interval);
      } 
      catch(InterruptedException e) {}
      theLifeGame.tick();
    }
  }
}


class CellGround extends Canvas {
  Dimension groundSize,viewSize;
  int cellSize;
  boolean map[][];
  byte weight[][];
  int oX,oY;
  int cursorPosX,cursorPosY;
  boolean changeable,wall,drawGrid;
  int viewLeft,viewRight,viewTop,viewBottom;
  
  public CellGround(Dimension gs,int cs){
    groundSize=gs;
    cellSize=cs;
    
    viewSize=new Dimension();
    
    map=new boolean[groundSize.width][groundSize.height];
    weight=new byte[groundSize.width+2][groundSize.height+2];
    for (int x=0;x<groundSize.width;++x){
      for (int y=0;y<groundSize.height;++y){
	map[x][y]=false;
      }
    }
    
    oX=0;
    oY=0;
    
    setBackground(Color.white);
    setForeground(Color.gray);
    
    changeable=true;
    wall=false;
    drawGrid=true;
    cursorPosX=-1;
    cursorPosY=-1;
  }
  
  public boolean cursorOnCellGround(int x,int y){
    x/=cellSize;
    y/=cellSize;
    if (viewLeft<=x && x<viewRight && viewTop<=y && y<viewBottom){
      cursorPosX=x+oX;
      cursorPosY=y+oY;
      return true;
    }
    return false;
  }
  
  public void setWall(boolean f){
    wall=f;
  }
  
  public void setDrawGrid(boolean f){
    drawGrid=f;
    repaint();
  }
  
  public void setChangeable(boolean f){
    changeable=f;
  }
  
  public boolean mouseUp(Event e,int x,int y){
    if (changeable){
      int cx=x/cellSize;
      int cy=y/cellSize;
      if (cx<viewSize.width && cy<viewSize.height){
	cx+=oX;
	cy+=oY;
	//System.out.println("mouseUp:"+cx+","+cy);
	if (0<=cx && cx<groundSize.width && 0<=cy && cy<groundSize.height){
	  if (map[cx][cy]){
	    map[cx][cy]=false;
	  }else{
	    map[cx][cy]=true;
	  }
	  repaint();
	}
      }
    }
    return true;
  }
  
  public void setTranslate(int x,int y){
    oX=x;
    oY=y;
    repaint();
  }
  
  transient Image BackScreen=null;
  transient Graphics bg;
  
  public void update(Graphics g){
    paint(g);
  }
  
  public void paint(Graphics g){
    Dimension d=this.size();
    
    viewSize.width=d.width/cellSize;
    viewSize.height=d.height/cellSize;
    
    if (BackScreen==null){
      BackScreen=createImage(d.width,d.height);
      bg=BackScreen.getGraphics();
    }
    bg.setColor(Color.gray);
    bg.fillRect(0,0,d.width,d.height);
    
    int x,y,nx,ny,tx,ty;
    while(true){
      if (oX<0 && viewSize.width<=-oX) break;
      if (groundSize.width<=oX) break;
      if (oY<0 && viewSize.height<=-oY) break;
      if (groundSize.height<=oY) break;
      
      viewLeft=0;nx=oX;
      if (oX<0){ viewLeft=-oX; nx=0; }
      viewRight=viewSize.width;
      if (groundSize.width-oX<viewSize.width) viewRight=groundSize.width-oX;
      
      viewTop=0;ny=oY;
      if (oY<0){ viewTop=-oY; ny=0; }
      viewBottom=viewSize.height;
      if (groundSize.height-oY<viewSize.height) viewBottom=groundSize.height-oY;
      
      //System.out.println(viewLeft+","+viewTop+":"+viewRight+","+viewBottom);
      bg.setColor(getBackground());
      bg.fillRect(viewLeft*cellSize,viewTop*cellSize,(viewRight-viewLeft)*cellSize,(viewBottom-viewTop)*cellSize);
      
      if (drawGrid){
	bg.setColor(getForeground());
	for (x=viewLeft;x<=viewRight;++x){
	  bg.drawLine(x*cellSize,viewTop*cellSize,x*cellSize,viewBottom*cellSize);
	}
	for (y=viewTop;y<=viewBottom;++y){
	  bg.drawLine(viewLeft*cellSize,y*cellSize,viewRight*cellSize,y*cellSize);
	}
      }
      bg.setColor(Color.red);
      tx=nx;
      for (x=viewLeft;x<viewRight;++x){
	ty=ny;
	for (y=viewTop;y<viewBottom;++y){
	  if (map[tx][ty]){
	    bg.fillRect(x*cellSize+1,y*cellSize+1,cellSize-1,cellSize-1);
	  }
	  ++ty;
	}
	++tx;
      }
      break;
    }
    
    g.drawImage(BackScreen,0,0,null);
  }
  
  public synchronized void next(){
    int x,y;
    
    for (x=0;x<groundSize.width+2;++x){
      for (y=0;y<groundSize.height+2;++y){
	weight[x][y]=0;
      }
    }
    for (x=0;x<groundSize.width;++x){
      for (y=0;y<groundSize.height;++y){
	if (map[x][y]){
	  ++weight[x-1+1][y-1+1];
	  ++weight[x  +1][y-1+1];
	  ++weight[x+1+1][y-1+1];
	  ++weight[x-1+1][y  +1];
	  ++weight[x+1+1][y  +1];
	  ++weight[x-1+1][y+1+1];
	  ++weight[x  +1][y+1+1];
	  ++weight[x+1+1][y+1+1];
	}
      }
    }
    if (!wall){
      for (x=0;x<groundSize.width;++x){
	weight[x+1][1]+=weight[x+1][groundSize.height+1];
	weight[x+1][groundSize.height]+=weight[x+1][0];
      }
      for (y=0;y<groundSize.height;++y){
	weight[1][y+1]+=weight[groundSize.width+1][y+1];
	weight[groundSize.width][y+1]+=weight[0][y+1];
      }
      weight[groundSize.width][groundSize.height]+=weight[0][0];
      weight[1][1]+=weight[groundSize.width+1][groundSize.height+1];
      weight[groundSize.width][1]+=weight[0][groundSize.height+1];
      weight[1][groundSize.height]+=weight[groundSize.width+1][0];
    }
    for (x=0;x<groundSize.width;++x){
      for (y=0;y<groundSize.height;++y){
	switch (weight[x+1][y+1]){
	case 3:		//	born cell
	  map[x][y]=true;
	  break;
	case 2:		//	no change
	  break;
	default:	//	Die cell
	  map[x][y]=false;
	  break;
	}
      }
    }
    repaint();
  }
}

