/*
 * Copyright (C) 1997 Ichiro Satoh
 * All Rights Reserved.
 * written by Ichiro Satoh
 *
 * This program was developed by Ichiro Satoh at Ochanomizu University 
 * as a part of a mobile object system, titled "AgentSpace". All the 
 * programs of the system is developed by Ichiro Satoh and all rights 
 * are reserved by Ichiro Satoh. 
 *
 * Permission to use, copy, modify and distribute this software and
 * its documentation is hereby granted, provided that both the
 * copyright notice and this permission notice appear in all copies of
 * the software, derivative works or modified versions, and any
 * portions thereof, and that both notices appear in supporting 
 * documentation.
 *
 * FREE USE OF THIS SOFTWARE IS ALLOWED IN ITS "AS IS" CONDITION.
 * BUT WITHOUT WARRANTY. THE AUTHORS DISCLAIM ANY LIABILITY OF ANY 
 * KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS 
 * SOFTWARE.
 */

import agentspace.*;
import java.lang.*;
import java.io.*;
import java.net.*;
import java.util.*;
import java.awt.*;
import java.awt.event.*;

public class Loader extends Agent 
implements ActionListener, Runnable, WindowListener {
  private Button loadButton;
  private Button saveButton;
  private Button destroyButton;
  private Button dispatchButton;
  private Button quitButton;

  private Panel listPanel;
  private TextField nameField;
  private int currentAgentNumber = 0;
  private int listMaxNumber = 0;
  private List agentList;
  private TextField tf;
  private String fileName = null;
  private String dirName = null;
  private URL birthURL = null;
  private Vector list;

  public Loader() {}
  public void init() {}
  public void create() {
    AgentContext ac = getAgentContext();
    AgentIdentifier aid = ac.getIdentifier();
    list = new Vector();
    initWindow(aid);
  }

  private void initWindow(AgentIdentifier aid) {
    setTitle ("Mobile Agent Loader: ("+aid+")");	
    setLayout (new BorderLayout());
    setBackground(Color.lightGray);
    Panel buttonPanel = new Panel();
    buttonPanel.setLayout (new FlowLayout());
    buttonPanel.add(loadButton = new Button("Load Agent"));
    buttonPanel.add(saveButton = new Button("Save"));
    buttonPanel.add(destroyButton = new Button("Destroy"));
    buttonPanel.add(dispatchButton = new Button("Dispatch"));
    buttonPanel.add(quitButton = new Button("Quit"));

    AgentContext ac = getAgentContext();
    birthURL = ac.getCurrentHost();
    buttonPanel.add(tf = new TextField(birthURL.getHost(), 16));

    loadButton.addActionListener(this);
    saveButton.addActionListener(this);
    destroyButton.addActionListener(this);
    dispatchButton.addActionListener(this);
    quitButton.addActionListener(this);

    agentList = new List(5, false);
    Font f = new Font("Courier", Font.BOLD, 12);
    agentList.setFont(f);
    agentList.addActionListener(this);

    add("North",  buttonPanel);
    add("Center", agentList);
    addWindowListener(this);
    pack();
    show();
  }

  public String getFileName() {
    FileDialog dialog = new FileDialog(this, "Save File", FileDialog.SAVE);
    dialog.show();
    if (dialog.getDirectory() != null && dialog.getFile() != null) {
      return dialog.getDirectory() + dialog.getFile();
    }
    else {
      return null;
    }
  }

  public String getDirectory() {
    return dirName;
  }

  public String getFile() {
    return fileName;
  }

  public String getFileName(String pattern) {
    FileDialog fd = new FileDialog(this, "Load Class");
    fd.setFile(pattern);
    fd.setDirectory( "." );
    fd.show();
    if (fd.getDirectory() != null && fd.getFile() != null) {
      fileName = fd.getFile();
      dirName  = fd.getDirectory();
      return fd.getDirectory() + fd.getFile();
    }
    else {
      return null;
    }
  }
  public void windowOpened(WindowEvent e) {}
  public void windowActivated(WindowEvent e) {}
  public void windowDeactivated(WindowEvent e) {}
  public void windowClosed(WindowEvent e) {}
  public void windowIconified(WindowEvent e){}
  public void windowDeiconified(WindowEvent e){}
  public void windowClosing(WindowEvent e){
    AgentContext ac = getAgentContext();
    ac.send("destroy");
    dispose();
  }

  private void loadAgent(String name) {
    AgentContext ac = getAgentContext();
    AgentIdentifier aid = ac.create(name);
    if (aid == null) {
      return;
    }
    list.addElement(aid);
    String item = ac.getAgentName(aid) + " " + aid;
    agentList.addItem(item);
    show();
  }

  private void dispatchAgent(int pos) {
    AgentIdentifier aid = (AgentIdentifier)list.elementAt(pos);
    AgentContext ac = getAgentContext();
    ac.send(aid, "dispatch", tf.getText());
    agentList.remove(pos);
    list.removeElementAt(pos);
    show();
  }

  private void duplicateAgent(int pos) {
    AgentIdentifier aid = (AgentIdentifier)list.elementAt(pos);
    AgentContext ac = getAgentContext();
    AgentIdentifier childaid = (AgentIdentifier)ac.duplicate();
    list.addElement(childaid);
    String item = ac.getAgentName(aid) + " " + aid;
    agentList.addItem(item);
    show();
  }

  private void destroyAgent(int pos) {
    AgentIdentifier aid = (AgentIdentifier)list.elementAt(pos);
    AgentContext ac = getAgentContext();
    ac.send(aid, "destroy");
    agentList.remove(pos);
    list.removeElementAt(pos);
    show();
  }

  public void actionPerformed(ActionEvent e) {
    String command = e.getActionCommand();
    if (e.getID() == WindowEvent.WINDOW_CLOSING) {
      AgentContext ac = getAgentContext();
      ac.send("destroy");
      dispose();
    }
    else if (command.equals("Load Agent")) {
      if (getFileName( "*.agent" ) != null) {
	loadAgent(dirName+fileName);
      }
    } 
    else if (command.equals("Save")) {
      int i = agentList.getSelectedIndex();
      System.out.println("Save Agent: "+agentList.getItem(i));
    } 
    else if (command.equals("Destroy")) {
      int i = agentList.getSelectedIndex();
      destroyAgent(i);
    } 
    else if (command.equals("Dispatch")) {
      int i = agentList.getSelectedIndex();
      dispatchAgent(i);
    } 
    else if (command.equals("Duplicate")) {
      int i = agentList.getSelectedIndex();
      duplicateAgent(i);
    } 
    else if (command.equals("Quit")) {
      AgentContext ac = getAgentContext();
      ac.send("destroy");
      dispose();
    } 
  } 
  public void arrive() {
    AgentContext ac = getAgentContext();
    for (int i = 0 ; i < list.size() ; i++ ) {
      AgentIdentifier aid = (AgentIdentifier)list.elementAt(i);
      if (ac.getAgentName(aid) == null ) {
	agentList.remove(i);
	list.removeElementAt(i);
      }
    }
    show();
  }
  public void dispatch(URL url) {
    AgentContext ac = getAgentContext();
    for (int i = 0 ; i < list.size() ; i++ ) {
      AgentIdentifier aid = (AgentIdentifier)list.elementAt(i);
      System.out.println("dispatch: AgentIdentifier("+i+"): "+aid);
      ac.send(aid, "dispatch", url.getHost());
    }
    dispose();
  }
  public void resume() {
    show();
  }
  public void suspend() {
    dispose();
  }
  public void destroy() {
    dispose();
  }
  public void duplicate(){
    dispose();
  }
  public void child(AgentIdentifier paid) {
    show();
  }
  public void parent(AgentIdentifier caid) {
    show();
  }
}


