/*
 * Copyright (C) 1997 Ichiro Satoh
 * All Rights Reserved.
 * written by Ichiro Satoh
 *
 * This program was developed by Ichiro Satoh at Ochanomizu University 
 * as a part of a mobile object system, titled "AgentSpace". All the 
 * programs of the system is developed by Ichiro Satoh and all rights 
 * are reserved by Ichiro Satoh. 
 *
 * Permission to use, copy, modify and distribute this software and
 * its documentation is hereby granted, provided that both the
 * copyright notice and this permission notice appear in all copies of
 * the software, derivative works or modified versions, and any
 * portions thereof, and that both notices appear in supporting 
 * documentation.
 *
 * FREE USE OF THIS SOFTWARE IS ALLOWED IN ITS "AS IS" CONDITION.
 * BUT WITHOUT WARRANTY. THE AUTHORS DISCLAIM ANY LIABILITY OF ANY 
 * KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS 
 * SOFTWARE.
 */

import agentspace.*;
import java.lang.*;
import java.io.*;
import java.net.*;
import java.util.*;
import java.awt.*;

public class MGrep extends Agent {
  URL birthURL = null;
  Panel searchPanel = new Panel();
  Panel buttonPanel = new Panel();
  Panel resultPanel = new Panel();
  TextField fileField;
  TextField patternField;
  TextField addressField;
  TextArea rta;
  String pattern  = "String";
  String filename = "Editor.java";
  String address = "";
  byte[] data;

  public MGrep() {}
  public void init() {}
  public void create() {
    AgentContext ac = getAgentContext();
    birthURL = ac.getCurrentHost();
    address = birthURL.getHost();
    data = fileToByteArray("GrepRobot.agent");
    initWindow();
  }
  public void arrive() {
    show();
  }
  public void dispatch(URL url) {
    dispose();
  }
  public void resume() {
    show();
  }
  public void suspend() {
    dispose();
  }
  public void destroy() {
    dispose();
  }
  public void duplicate(){}
  public void child(AgentIdentifier paid) {
    show();
  }
  public void parent(AgentIdentifier caid) {
    show();
  }
  public void reply(String location, String[] result) {
    System.out.println("MGrep: reply() called");
    resultWindow(location, result);
  }

  private byte[] fileToByteArray(String fileName) {
    byte[] data = null;
    try {
      FileInputStream inStream = new FileInputStream(fileName);
      ByteArrayOutputStream byteout = new ByteArrayOutputStream();
      byte[] bytes = new byte[1024];
      int count;
      while ((count = inStream.read(bytes)) != -1) {
	byteout.write(bytes, 0, count);
      }
      data = byteout.toByteArray();
      byteout.close();
      inStream.close();
    } catch (IOException e) {
      e.printStackTrace();
    }
    return data;
  }

  private void initWindow() {
    setTitle("Mobile Grep Launcher");
    setBackground(Color.lightGray);
    Font f1 = new Font("Helvetica", Font.BOLD, 12);
    Font f2 = new Font("TimesRoman", Font.BOLD, 12);
    Font f3 = new Font("Courier", Font.BOLD, 12);
    fileField = new TextField(filename, 20);
    fileField.setFont(f3);
    patternField = new TextField(pattern, 20);
    patternField.setFont(f3);
    addressField = new TextField(address, 20);
    addressField.setFont(f3);

    Label patternLabel = new Label("Pattern:");
    Label fileLabel = new Label("File:");
    Label addressLabel = new Label("Address:");

    fileLabel.setFont(f2);
    patternLabel.setFont(f2);
    addressLabel.setFont(f2);

    Button quitButton = new Button("QUIT");
    Button sendButton = new Button("SEND");

    searchPanel.add(patternLabel);
    searchPanel.add(patternField);
    searchPanel.add(fileLabel);
    searchPanel.add(fileField);
    buttonPanel.add("West", addressLabel);
    buttonPanel.add("West", addressField);
    buttonPanel.add("East", sendButton);
    buttonPanel.add("East", quitButton);

    rta = new TextArea(20, 80);
    rta.setText("");
    rta.setEditable(false);
    rta.setBackground(Color.white);
    resultPanel.add(rta);

    add("North",  searchPanel);
    add("Center", buttonPanel);
    add("South",  resultPanel);
    pack();
    show();
  }
  
  private void resultWindow(String location, String[] result) {
    String resultText = "";
    for (int i = 0 ; i < result.length ; i++ ) {
      resultText = resultText + location + "> "+result[i] + "\n";
    }
    rta.append(resultText);
    rta.setEditable(false);
    rta.setBackground(Color.white);
    remove(resultPanel);
    resultPanel = new Panel();
    resultPanel.add(rta);
    add("South",  resultPanel);
    pack();
    show();
  }

  private void transfer() {
    pattern  = patternField.getText();
    filename = fileField.getText();
    address  = addressField.getText();
    AgentContext ac = getAgentContext();
    AgentIdentifier aid = ac.create(data);
    AgentIdentifier myid = ac.getIdentifier();
    ac.send(aid, "search", myid, address, filename, pattern);
  }

  public boolean action(Event evt, Object what) {
    if ("SEND".equals(what)) {
      transfer();
      return true;
    }
    if ("QUIT".equals(what)) {
      AgentContext ac = getAgentContext();
      ac.send("destroy");
      dispose();
      return true;
    }
    return false;
  }

  public boolean handleEvent(Event evt) {
    if (evt.id == Event.WINDOW_DESTROY) {
      dispose();
      AgentContext ac = getAgentContext();
      ac.send("destroy");
    }
    return super.handleEvent(evt);
  }
}


