/*
 * Copyright (C) 1997 Ichiro Satoh
 * All Rights Reserved.
 * written by Ichiro Satoh
 *
 * This program was developed by Ichiro Satoh at Ochanomizu University 
 * as a part of a mobile object system, titled "AgentSpace". All the 
 * programs of the system is developed by Ichiro Satoh and all rights 
 * are reserved by Ichiro Satoh. 
 *
 * Permission to use, copy, modify and distribute this software and
 * its documentation is hereby granted, provided that both the
 * copyright notice and this permission notice appear in all copies of
 * the software, derivative works or modified versions, and any
 * portions thereof, and that both notices appear in supporting 
 * documentation.
 *
 * FREE USE OF THIS SOFTWARE IS ALLOWED IN ITS "AS IS" CONDITION.
 * BUT WITHOUT WARRANTY. THE AUTHORS DISCLAIM ANY LIABILITY OF ANY 
 * KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS 
 * SOFTWARE.
 */

import agentspace.*;
import java.lang.*;
import java.io.*;
import java.net.*;
import java.util.*;
import java.awt.*;
import java.awt.event.*;

public class Mail extends Agent 
implements ActionListener, Runnable, WindowListener {
  private Button sendButton;
  private Button replyButton;
  private Button trashButton;
  private TextArea editArea;
  private TextField addressField;
  private TextField titleField;
  private URL birthURL = null;
  private AgentIdentifier aid = null;
  private String buffer = "";
  private String title = "";
  private String address = "";
  private Label toAddress;
  private boolean newMail = true;
  public Mail() {}
  public static void main(String args[]) {
    Mail m = new Mail();
    m.create();
  }
  public void init() {}
  public void create() {
    AgentContext ac = getAgentContext();
    birthURL = ac.getCurrentHost();
    address = birthURL.getHost();
    initWindow();
    sendButton.enable();
    replyButton.disable();
    trashButton.enable();
    show();
  }
  public void arrive() {
    newMail = false;
    addtitle();
    titleField.setText("Re: "+title);
    toAddress.setText("Reply To: ");
//  editArea.setText(buffer);
    String line = "";
    try {
      StringReader sr = new StringReader(buffer);
      BufferedReader bf = new BufferedReader(sr);
      while(true) {
	String s = bf.readLine();
	if (s == null) {
	  break;
	}
	line = line + "> "+s+"\n";
      }
    }
    catch(IOException e) {}
    editArea.setText(line);
//  editArea.setEditable(false);

    sendButton.disable();
    replyButton.enable();
    trashButton.enable();
    System.out.println("arrive() done");
    show();
  }
  public void dispatch(URL url) {
    if (newMail) {
      title  = titleField.getText();
    }
    buffer = editArea.getText();
    removetitle();
    dispose();
  }
  public void resume() {
    titleField.setText(title);
    addressField.setText(address);
    editArea.setText(buffer);
    show();
  }
  public void suspend() {
    buffer = editArea.getText();
    address = addressField.getText();
    title = titleField.getText();
    dispose();
  }
  public void destroy() {
    removetitle();
    dispose();
  }
  public void duplicate(){
    dispose();
  }
  public void child(AgentIdentifier paid) {
    show();
  }
  public void parent(AgentIdentifier caid) {
    show();
  }
  public void front_to_window() {
    toFront();
    show();
  }
  public void move_as_new_mail(String address) {
    AgentContext ac = getAgentContext();
    ac.send("dispatch", address);
  }
  public void move_as_reply_mail(String address) {
    AgentContext ac = getAgentContext();
    ac.send("dispatch", address);
  }
  public void move_only(String address) {
    AgentContext ac = getAgentContext();
    ac.send("dispatch", address);
  }
  public void trash() {
    AgentContext ac = getAgentContext();
    ac.send("destroy");
  }
  private void removetitle() {
    AgentContext ac = getAgentContext();
    Enumeration e = ac.getAgents("MailBox");
    while(e.hasMoreElements()) {
      aid = (AgentIdentifier)e.nextElement();
      String title = "Hello, Dear Duke.." + " from: " 
	+  ac.getIdentifier() + " at " +  ac.getCurrentHost().getHost();
      ac.send(aid, "remove", ac.getIdentifier());
    }
  }
  private void addtitle() {
    AgentContext ac = getAgentContext();
    Enumeration e = ac.getAgents("MailBox");
    while(e.hasMoreElements()) {
      aid = (AgentIdentifier)e.nextElement();
      ac.send(aid, "add", ac.getIdentifier(), title);
    }
  }
  private void initWindow() {
    setTitle ("Mail Agent");
    setLayout (new BorderLayout());
    setBackground(SystemColor.menu);
    Panel buttonPanel = new Panel();
    buttonPanel.setLayout (new FlowLayout());
    buttonPanel.add(sendButton = new Button("Send"));
    buttonPanel.add(replyButton = new Button("Reply"));
    buttonPanel.add(trashButton = new Button("To Trash"));
    sendButton.addActionListener(this);
    replyButton.addActionListener(this);
    trashButton.addActionListener(this);

    Font f = new Font("Dialog", Font.PLAIN, 12);
    Panel addressPanel = new Panel();
    addressPanel.setLayout (new GridLayout());
    toAddress = new Label("Send To: ");
    addressPanel.add(toAddress);
    addressField = new TextField(address, 12);
    addressField.setFont(f);
    addressPanel.add(addressField, "East");
    Panel titlePanel = new Panel();
    titlePanel.setLayout (new GridLayout());
    titlePanel.add("West", new Label("Title:  "));
    titleField = new TextField(title, 12);
    titleField.setFont(f);
    titlePanel.add("East", titleField);

    Panel headerPanel = new Panel();
    headerPanel.setLayout (new BorderLayout());
    headerPanel.add("North", addressPanel);
    headerPanel.add("South", titlePanel);

    Panel editPanel = new Panel();
    editArea = new TextArea(10, 40);
    editPanel.setFont(f);
    editArea.setText(buffer);
    editPanel.add("Center", editArea);

    add("North",  buttonPanel);
    add("Center", headerPanel);
    add("South",  editPanel);
    addWindowListener(this);
    pack();
    show();
  }

  public void windowOpened(WindowEvent e) {}
  public void windowActivated(WindowEvent e) {}
  public void windowDeactivated(WindowEvent e) {}
  public void windowClosed(WindowEvent e) {}
  public void windowIconified(WindowEvent e){}
  public void windowDeiconified(WindowEvent e){}
  public void windowClosing(WindowEvent e){
    AgentContext ac = getAgentContext();
    ac.send("destroy");
    dispose();
  }

  public void actionPerformed(ActionEvent e) {
    String command = e.getActionCommand();
    if (e.getID() == WindowEvent.WINDOW_CLOSING) {
      dispose();
      AgentContext ac = getAgentContext();
      ac.send("destroy");
    }
    else if (command.equals("Send")) {
      move_as_new_mail(addressField.getText());
    } 
    else if (command.equals("Reply")) {
      move_as_reply_mail(addressField.getText());
    } 
    else if (command.equals("Trash")) {
      dispose();
      AgentContext ac = getAgentContext();
      ac.send("destroy");
    } 
  }
}
