/*
 * Copyright (C) 1997 Ichiro Satoh
 * All Rights Reserved.
 * written by Ichiro Satoh
 *
 * This program was developed by Ichiro Satoh at Ochanomizu University 
 * as a part of a mobile object system, titled "AgentSpace". All the 
 * programs of the system is developed by Ichiro Satoh and all rights 
 * are reserved by Ichiro Satoh. 
 *
 * Permission to use, copy, modify and distribute this software and
 * its documentation is hereby granted, provided that both the
 * copyright notice and this permission notice appear in all copies of
 * the software, derivative works or modified versions, and any
 * portions thereof, and that both notices appear in supporting 
 * documentation.
 *
 * FREE USE OF THIS SOFTWARE IS ALLOWED IN ITS "AS IS" CONDITION.
 * BUT WITHOUT WARRANTY. THE AUTHORS DISCLAIM ANY LIABILITY OF ANY 
 * KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS 
 * SOFTWARE.
 */

import agentspace.*;
import java.lang.*;
import java.io.*;
import java.net.*;
import java.util.*;
import java.awt.*;
import java.awt.event.*;

public class MailBox extends Agent 
implements ActionListener, Runnable, WindowListener {
  private Button mailButton;
  private Button loadButton;
  private Button destroyButton;
  private Button dispatchButton;
  private TextField nameField;
  private int currentAgentNumber = 0;
  private int listMaxNumber = 0;
  private List mailList;
  private TextField tf;
  private String fileName = null;
  private String dirName = null;
  private URL birthURL = null;
  private Vector list;

  public MailBox() {}
  public void init() {}
  public void create() {
    AgentContext ac = getAgentContext();
    AgentIdentifier aid = ac.getIdentifier();
    list = new Vector();
    initWindow(aid);
  }
  public void arrive() {
    AgentContext ac = getAgentContext();
    for (int i = 0 ; i < list.size() ; i++ ) {
      AgentIdentifier aid = (AgentIdentifier)list.elementAt(i);
      if (ac.getAgentName(aid) == null ) {
	mailList.remove(i);
	list.removeElementAt(i);
      }
    }
    show();
  }
  public void dispatch(URL url) {
    AgentContext ac = getAgentContext();
    for (int i = 0 ; i < list.size() ; i++ ) {
      AgentIdentifier aid = (AgentIdentifier)list.elementAt(i);
      ac.send(aid, "move_only", url.getHost());
    }
    dispose();
  }
  public void resume() {
    show();
  }
  public void suspend() {
    dispose();
  }
  public void destroy() {
    dispose();
  }
  public void duplicate(){
    dispose();
  }
  public void child(AgentIdentifier paid) {
    show();
  }
  public void parent(AgentIdentifier caid) {
    show();
  }
  public void add(AgentIdentifier aid, String title) {
    if (aid == null) {
      return;
    }
    list.addElement(aid);
    String item = title + " (" + aid + ") ";
    mailList.addItem(item);
    show();
  }
  public void remove(AgentIdentifier aid) {
    if (aid == null) {
      return;
    }
    int pos = list.indexOf(aid);
    list.removeElement(aid);
    mailList.remove(pos);
    show();
  }

  private void open(String name) {
    AgentContext ac = getAgentContext();
    AgentIdentifier aid = ac.create(name);
    if (aid == null) {
      return;
    }
  }

  private void send(int pos) {
    AgentIdentifier aid = (AgentIdentifier)list.elementAt(pos);
    AgentContext ac = getAgentContext();
    ac.send(aid, "move_as_new_mail", tf.getText());
    mailList.remove(pos);
    list.removeElementAt(pos);
    show();
  }

  private void trash(int pos) {
    AgentIdentifier aid = (AgentIdentifier)list.elementAt(pos);
    AgentContext ac = getAgentContext();
    ac.send(aid, "trash");
    mailList.remove(pos);
    list.removeElementAt(pos);
    show();
  }

  private void initWindow(AgentIdentifier aid) {
    setTitle ("Mobile Mail Box");
    setLayout (new BorderLayout());
    setBackground(SystemColor.menu);
    Panel buttonPanel = new Panel();
    buttonPanel.setLayout (new FlowLayout());
    buttonPanel.add(mailButton = new Button("New Mail"));
    buttonPanel.add(loadButton = new Button("Open Mail"));
    buttonPanel.add(destroyButton = new Button("To Trash"));
    buttonPanel.add(dispatchButton = new Button("Reply"));
    mailButton.addActionListener(this);
    loadButton.addActionListener(this);
    destroyButton.addActionListener(this);
    dispatchButton.addActionListener(this);

    Panel addrPanel = new Panel();
    buttonPanel.add(new Label("Reply To: "));
    AgentContext ac = getAgentContext();
    birthURL = ac.getCurrentHost();
    buttonPanel.add(tf = new TextField(birthURL.getHost(), 20));

    Font f = new Font("Courier", Font.BOLD, 12);
    mailList = new List(5, false);
    mailList.setFont(f);
    mailList.addActionListener(this);

    add("North",  buttonPanel);
    add("Center", addrPanel);
    add("South",  mailList);
    addWindowListener(this);
    pack();
    show();
  }

  private String getFileName() {
    FileDialog dialog = new FileDialog(this, "Save File", FileDialog.SAVE);
    dialog.show();
    if (dialog.getDirectory() != null && dialog.getFile() != null) {
      return dialog.getDirectory() + dialog.getFile();
    }
    else {
      return null;
    }
  }

  private String getDirectory() {
    return dirName;
  }
  private String getFile() {
    return fileName;
  }

  private String getFileName(String pattern) {
    FileDialog fd = new FileDialog(this, "Load Class");
    fd.setFile(pattern);
    fd.setDirectory( "." );
    fd.show();
    if (fd.getDirectory() != null && fd.getFile() != null) {
      fileName = fd.getFile();
      dirName  = fd.getDirectory();
      return fd.getDirectory() + fd.getFile();
    }
    else {
      return null;
    }
  }

  public void windowOpened(WindowEvent e) {}
  public void windowActivated(WindowEvent e) {}
  public void windowDeactivated(WindowEvent e) {}
  public void windowClosed(WindowEvent e) {}
  public void windowIconified(WindowEvent e){}
  public void windowDeiconified(WindowEvent e){}
  public void windowClosing(WindowEvent e){
    AgentContext ac = getAgentContext();
    ac.send("destroy");
    dispose();
  }

  public void actionPerformed(ActionEvent e) {
    String command = e.getActionCommand();
    if (e.getID() == WindowEvent.WINDOW_CLOSING) {
      AgentContext ac = getAgentContext();
      ac.send("destroy");
      dispose();
    }
    else if (command.equals("New Mail")) {
      open("Mail.agent");
    } 
    else if (command.equals("Open Mail")) {
      if (getFileName( "*.agent" ) != null) {
	open(dirName+fileName);
      }
    } 
    else if (command.equals("To Trash")) {
      int i = mailList.getSelectedIndex();
      trash(i);
    } 
    else if (command.equals("Reply")) {
      int i = mailList.getSelectedIndex();
      send(i);
    } 
  } 
}


