import java.lang.*;
import java.io.*;
import java.net.*;
import java.util.*;
import java.util.zip.*;
import java.awt.*;
import agentspace.*;

class MakeAgent extends Agent {
  Frame f1 = new Frame("Make Agent Tool by Ichiro Satoh");
  List ltList = new List(16, true);
  List rtList = new List( 0, true);
  List ctList = new List( 0, true);
  TextField tf1 = new TextField(20);
  TextField tf2 = new TextField(20);
  GridBagLayout gbl = new GridBagLayout();
  Vector fileList;
  boolean commandLine = false;

  public void init(){}
  public void create(){
    selectClassesWindow();
  }
  public void destroy(){
    dispose();
  }
  public void dispatch(URL url){
    dispose();
  }
  public void arrive(){
    pack();
    show();
  }
  public void suspend(){
    dispose();
  }
  public void resume(){
    makeFileList();
    pack();
    show();
  }
  MakeAgent() {
    this((String[])null);
  }
  MakeAgent(String[] args) {
    if (args == null) {
    }
    else if (args.length >= 2) {
      commandLine = true;
      String[] files = new String[args.length-2];
      for(int i = 0 ; i < args.length - 2; i++ ) {
	files[i] = args[i+2];
      }
      makeAgent(args[0], args[1], files);
      System.exit(0);
    }
    else {
      commandLine = true;
      selectClassesWindow();
    }
  }

  private void selectClassesWindow() {
    setTitle("Make Agent Tool by Ichiro Satoh");
    Label title = new Label("Select Class Files");
    Panel top = new Panel();
    top.add("Center", title);
    Label ltop = new Label("    Not Selected Classes    ");
    Label rtop = new Label("    Selected Classes        ");

    Panel lfield = new Panel();
    Panel rfield1= new Panel();
    Panel rfield2 = new Panel();
    TextField tl = new TextField(30);

    lfield.add("Center",   tl);
    rfield1.add("Center", tf1);
    rfield2.add("Center", tf2);

    Panel bot = new Panel();
    Button b1 = new Button("OK");
    Button b2 = new Button("Cancel");
    Button b0 = new Button("Update");
    bot.add("East", b0);
    bot.add("Center", b1);
    bot.add("West", b2);

    Panel select = new Panel();
    Button b = new Button("Select");
    select.add("Center", b);

    rtList.setMultipleMode(false);

    setBackground(Color.lightGray);
    GridBagLayout gbl = new GridBagLayout();
    setLayout(gbl);
    add(            top,  0, 0, 3, 1, 1.0, 1.0);
    add(           ltop,  0, 1, 1, 1, 1.0, 1.0);
    add(           rtop,  2, 1, 1, 1, 1.0, 1.0);
    add(ltList,           0, 2, 1,15, 1.0, 1.0);
    add(rtList,           2, 2, 1, 8, 1.0, 1.0);
    add(new Button(">"),  1, 3, 1, 1,   0, 1.0);
    add(new Button("<"),  1, 4, 1, 1,   0, 1.0);
    add(new Label(""),    1, 5, 1, 1,   0, 1.0);
    add(new Button(">>"), 1, 6, 1, 1,   0, 1.0);
    add(new Button("<<"), 1, 7, 1, 1,   0, 1.0);
    add(new Button("!"),  1, 8, 1, 1,   0, 1.0);
    add(new Label(""),    1, 9, 1, 1,   0, 1.0);
    add(new Label(""),    1,10, 1, 1,   0, 1.0);
    add(lfield,           0,11, 1, 1, 1.0, 1.0);
    add(select,           2,10, 1, 1,   0, 1.0);
    add(new Label("  Invoker Class"),    2,11, 1, 1,   0, 1.0);
    add(rfield1,          2,12, 1, 1, 1.0, 1.0);
    add(new Label("  Agent Name"),    2, 13, 1, 1,   0, 1.0);
    add(rfield2,          2,14, 1, 1, 1.0, 1.0);
    add(            bot,  2,16, 3, 1, 1.0, 1.0);
    makeFileList();
    resize(300,500);
    pack();
    lfield.hide();
    show();
  }

  private void makeFileList() {
    File fileSet = new File(".");
    String[] fileList;
    fileList = fileSet.list();
    for ( int i = 0 ; fileList != null && i < fileList.length ; i++ ) {
      if (fileList[i].endsWith(".class")) {
	ltList.addItem(fileList[i]);
      }
    }
  }
  
  void add(Component comp,
	   int x, int y, int w, int h, double weightx, double weighty) {
    GridBagLayout gbl = (GridBagLayout)getLayout();
    GridBagConstraints c = new GridBagConstraints();
    
    c.fill = GridBagConstraints.BOTH;
    c.gridx = x;
    c.gridy = y;
    c.gridwidth = w;
    c.gridheight = h;
    c.weightx = weightx;
    c.weighty = weighty;
    add(comp);
    gbl.setConstraints(comp, c);
  }
  
  void reverseSelections(List l) {
    for (int i=0; i<l.countItems(); i++) {
      if (l.isSelected(i)) {
	l.deselect(i);
      } else {
	l.select(i);
      }
    }
  }
  
  void deselectAll(List l) {
    for (int i=0; i<l.countItems(); i++) {
      l.deselect(i);
    }
  }
  
  void move(List l1, List l2, boolean all) {
    if (all) {
      for (int i=0; i<l1.countItems(); i++) {
	l2.addItem(l1.getItem(i));
      }
      l1.delItems(0, l1.countItems()-1);    // or l1.clear();
    } else {
      String[] items = l1.getSelectedItems();
      int[] itemIndexes = l1.getSelectedIndexes();
      
      deselectAll(l2);
      for (int i=0; i<items.length; i++) {
	l2.addItem(items[i]);        // add it
	l2.select(l2.countItems()-1);// and select it
	if (i == 0) {
	  l2.makeVisible(l2.countItems()-1);
	}
      }
      for (int i=itemIndexes.length-1; i>=0; i--) {
	l1.delItem(itemIndexes[i]);
      }
    }
  }
  
  public boolean action(Event evt, Object arg) {
    if (">".equals(arg)) {
      move(ltList, rtList, false);
    } 
    else if (">>".equals(arg)) {
      move(ltList, rtList, true);
    } 
    else if ("<".equals(arg)) {
      move(rtList, ltList, false);
    } 
    else if ("<<".equals(arg)) {
      move(rtList, ltList, true);
    } 
    else if ("!".equals(arg)) {
      if (ltList.getSelectedItems().length > 0) {
	reverseSelections(ltList);
      } 
      else if (rtList.getSelectedItems().length > 0) {
	reverseSelections(rtList);
      }
    } 
    else if ("Select".equals(arg)) {
      String invokerClass  = rtList.getSelectedItem();
      String agentFileName = rtList.getSelectedItem();
      if (agentFileName.endsWith(".class")) {
	agentFileName = 
	  invokerClass.substring(0, invokerClass.length() - 6);
      }
      tf1.setText(invokerClass);
      tf2.setText(agentFileName+".agent");
    } 
    else if ("OK".equals(arg)) {
      String[] fileNames = new String[rtList.countItems()];
      for (int i = 0 ; i < rtList.countItems() ; i++ ) {
	fileNames[i] = rtList.getItem(i);
      }
      String agentFileName = rtList.getSelectedItem();
      if (agentFileName.endsWith(".class")) {
	agentFileName = 
	  agentFileName.substring(0, agentFileName.length() - 6);
      }
      makeAgent(tf1.getText(), tf2.getText(), fileNames);
    } 
    else if ("Cancel".equals(arg)) {
    } 
    else if ("Update".equals(arg)) {
      makeFileList();
      pack();
      show();
    } 
    else {
      return false;
    }
    return true;
  }

  public boolean handleEvent(Event evt) {
    if (evt.id == Event.LIST_SELECT
	|| evt.id == Event.LIST_DESELECT) {
      if (evt.target == ltList) {
	deselectAll(rtList);
      } else if (evt.target == rtList) {
	deselectAll(ltList);
      }
      return true;
    }
    return super.handleEvent(evt);
  }
  
  private URL makeLocalURL() {
    URL url = null;
    try {
      url = new URL("http://"+(InetAddress.getLocalHost()).getHostAddress());
    }
    catch (UnknownHostException e) {
      System.err.println(e); 	 
    }
    catch (MalformedURLException e) {
      System.err.println(e); 	 
    }
    return url;
  }

  private Agent makeInitializedAgent(String className) {
    Agent anAgent = null;
    try{
      if (className.endsWith(".class")) {
	className = className.substring(0, className.length() - 6);
      }
      Class c = Class.forName(className);
      Object obj = c.newInstance();
      if (obj != null && obj instanceof Agent) {
	anAgent = (Agent)obj;
	anAgent.setAgentContext(null);
	anAgent.init();
      }
    } 
    catch (IllegalAccessException e) {
      System.err.println(e);
    } 
    catch (InstantiationException e) {
      System.err.println(e);
    }
    catch (ClassNotFoundException e) {
      System.err.println(e);
    } 
    return anAgent;
  }

  private void makeAgent(String invokerFileName, String agentFileName, 
			 String[] classFileNames) {

    URL url = makeLocalURL();
    byte[] zipcode = AgentByteCode.filesToZipByteArray(classFileNames);
    Agent anAgent = makeInitializedAgent(invokerFileName);

    AgentInfo ainfo = new AgentInfo();
    ainfo.setIdentifier(new AgentIdentifier());
    ainfo.setAgent(anAgent);
    ainfo.setName(invokerFileName);
    ainfo.setOriginalHost(url);
    ainfo.setCurrentHost(url);
    ainfo.setPreviousHost(url);
    ainfo.setCodeBaseHost(url);
    ainfo.setAgentStatus(AgentStatus.PREINIT);
    ainfo.setAgentCode(zipcode);
    ainfo.addParentList(AgentIdentifier.GeneralManager());
    ainfo.setAgentThread(Thread.currentThread());

    try {
      FileOutputStream fis = new FileOutputStream(agentFileName);
      AgentWriteStream aws = new AgentWriteStream(fis);
      aws.storeAgent(ainfo);
      fis.close();
    } catch (IOException e) { 	 
      System.err.println(e); 	 
    } 
  }
  public static void main(String args[]) {
    if (args.length == 0) {
      new MakeAgent(args);
    }
    else if (args.length <= 2) {
      System.out.println("usage: java MakeAgent InvokedClassName "
			 +"AgentFileName Classfile [Classfile...]");
    }
    else if (args.length > 2) {
      new MakeAgent(args);
    }
  }
}
