/*
 * Copyright (C) 1997 Ichiro Satoh
 * All Rights Reserved.
 * written by Ichiro Satoh
 *
 * This program was developed by Ichiro Satoh at Ochanomizu University 
 * as a part of a mobile object system, titled "AgentSpace". All the 
 * programs of the system is developed by Ichiro Satoh and all rights 
 * are reserved by Ichiro Satoh. 
 *
 * Permission to use, copy, modify and distribute this software and
 * its documentation is hereby granted, provided that both the
 * copyright notice and this permission notice appear in all copies of
 * the software, derivative works or modified versions, and any
 * portions thereof, and that both notices appear in supporting 
 * documentation.
 *
 * FREE USE OF THIS SOFTWARE IS ALLOWED IN ITS "AS IS" CONDITION.
 * BUT WITHOUT WARRANTY. THE AUTHORS DISCLAIM ANY LIABILITY OF ANY 
 * KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS 
 * SOFTWARE.
 */

import agentspace.*;
import java.lang.*;
import java.io.*;
import java.net.*;
import java.util.*;
import java.awt.*;

public class MobileGrep extends Agent {
  private URL birthURL = null;
  private List list;
  private Panel searchPanel = new Panel();
  private Panel buttonPanel = new Panel();
  private Panel resultPanel = new Panel();
  private Button quitButton = new Button("QUIT");
  private Button sendButton = new Button("SEARCH START");
  private Button appendButton = new Button("APPEND");
  private Button editButton = new Button("EDIT");
  private Button deleteButton = new Button("DELETE");
  private TextField fileField;
  private TextField patternField;
  private TextField addressField;
  private TextArea rta;
  private String pattern  = "String";
  private String filename = "Editor.java";
  private String address = "";
  private int currentList;
  private String message = "";

  public MobileGrep() {}
  public void init() {}
  public void create() {
    AgentContext ac = getAgentContext();
    birthURL = ac.getCurrentHost();
    address = birthURL.getHost();
    initWindow();
  }
  public void arrive() {
    show();
  }
  public void dispatch(URL url) {
    dispose();
  }
  public void resume() {
    show();
  }
  public void suspend() {
    dispose();
  }
  public void destroy() {
    dispose();
  }
  public void duplicate(){}
  public void child(AgentIdentifier paid) {
    show();
  }
  public void parent(AgentIdentifier caid) {
    show();
  }
  public synchronized void reply(String location, String[] result) {
    System.out.println("MGrep: reply() called");
    resultWindow(location, result);
  }

  private void initWindow() {
    setTitle("Mobile Grep Launcher");
    setBackground(Color.lightGray);

    list = new List();
    Panel hostPanelButton = new Panel();
    hostPanelButton.add(appendButton);
    hostPanelButton.add(editButton);
    hostPanelButton.add(deleteButton);
    list.setBackground(Color.white);
    Panel hostPanel = new Panel();
    hostPanel.setBackground(Color.lightGray);
    hostPanel.add("North", new Label("Host:"));
    hostPanel.add("North", list);
    hostPanel.add("South", hostPanelButton);

    Panel grepPanel = new Panel();
    Panel patternPanel = new Panel();
    Panel filePanel = new Panel();
    Panel buttonPanel = new Panel();
    Font f1 = new Font("Helvetica", Font.BOLD, 12);
    Font f2 = new Font("TimesRoman", Font.BOLD, 12);
    Font f3 = new Font("Courier", Font.BOLD, 12);
    fileField = new TextField(filename, 20);
    fileField.setFont(f3);
    patternField = new TextField(pattern, 20);
    patternField.setFont(f3);
    Label patternLabel = new Label("Pattern:");
    patternPanel.add("West", patternLabel);
    patternPanel.add("East", patternField);
    Label fileLabel = new Label("File:");
    filePanel.add("West", fileLabel);
    filePanel.add("East", fileField);
    buttonPanel.add("West", sendButton);
    buttonPanel.add("East", quitButton);
    grepPanel.add("North", patternPanel);
    grepPanel.add("Center", filePanel);
    grepPanel.add("South", buttonPanel);

    rta = new TextArea(20,50);
    rta.setText("");
    rta.setEditable(false);
    rta.setBackground(Color.white);

    add("North",  grepPanel);
    add("Center", hostPanel);
    add("South",  rta);
    pack();
    show();
  }
 
  private void resultWindow(String location, String[] result) {
    String resultText = "";
    for (int i = 0 ; i < result.length ; i++ ) {
      resultText = resultText + location + "> "+result[i] + "\n";
    }
    rta.append(resultText);
    rta.setEditable(false);
    rta.setBackground(Color.white);
    pack();
    show();
  }
  public void transfer(String target) {
    AgentContext ac = getAgentContext();
    AgentIdentifier aid = ac.create("GrepRobot.agent");
    AgentIdentifier myid = ac.getIdentifier();
    ac.send(aid, "search", myid, target, filename, pattern);
  }

  public boolean action(Event evt, Object what) {
    if (evt.target instanceof List) {
      System.out.println(what);
      return true;
    }
    if ("SEARCH START".equals(what)) {
      sendButton.disable();
      pattern  = patternField.getText();
      filename = fileField.getText();
      AgentContext ac = getAgentContext();
      for (int i = 0 ; i < list.countItems() ; i++ ) {
	transfer(list.getItem(i));
      }
      sendButton.enable();
      return true;
    }
    if ("QUIT".equals(what)) {
      AgentContext ac = getAgentContext();
      ac.destroy();
      dispose();
      return true;
    }
    if ("APPEND".equals(what)) {
      currentList = -1;
      list.select(currentList);
      Point mPoint = appendButton.getLocationOnScreen();
      new GrepAddressDialog(this, "New Search Host Name", "", mPoint);
      return true;
    }
    if ("EDIT".equals(what)) {
      if ((currentList = list.getSelectedIndex()) >= 0) {
	message = (String)list.getItem(currentList);
	Point mPoint = editButton.getLocationOnScreen();
	new GrepAddressDialog(this, "Edit Search Host Name", message, mPoint);
	show();
      }
      return true;
    }
    if ("DELETE".equals(what)) {
      if ((currentList = list.getSelectedIndex()) >= 0) {
	list.remove(currentList);
	show();
      }
      return true;
    }
    if ("OK".equals(what)) {
      dispose();
      return true;
    }
    return false;
  }

  public void result(String message) {
    if ((currentList = list.getSelectedIndex()) >= 0) {
      list.replaceItem(message, currentList);
    }
    else {
      if (message != "") {
	list.addItem(message);
      }
    }
    show();
  }
  public boolean handleEvent(Event evt) {
    if (evt.id == Event.WINDOW_DESTROY) {
      AgentContext ac = getAgentContext();
      ac.send("destroy");
      dispose();
      dispose();
    }
    return super.handleEvent(evt);
  }
}

class GrepAddressDialog extends Dialog {
  String message;
  TextField textField;
  MobileGrep callBack;
  public GrepAddressDialog(MobileGrep parentFrame, 
			   String label, String message, Point point) {
    super(parentFrame, "Input Host Name", true);
    callBack = parentFrame;
    this.message = message;
    setBackground(Color.lightGray);

    textField = new TextField(20);
    Font f = new Font("Courier", Font.PLAIN, 12);
    textField.setFont(f);
    textField.setText(this.message);

    Panel p = new Panel();
    p.add("Center", new Button("OK"));

    add("North", new Label(label));
    add("Center", textField);
    add("South", p);
//  Point point = getLocation();
    Dimension d = getSize();
    setLocation(point.x - d.width/2, point.y - d.height/2);
    pack();
    show();
  }

  public boolean handleEvent(Event evt) {
    switch(evt.id) {
      case Event.ACTION_EVENT: {
	if("OK".equals(evt.arg)) {
	  callBack.result(textField.getText());
	  dispose();
	  return true;
	}
      }
    }
    return false;
  }
}
