/*
 * Painter.java	97/10/05
 * 
 * Copyright (c) 1997 Ichiro Satoh All Rights Reserved.
 * 
 */
import agentspace.*;
import java.awt.*;
import java.net.*;

public class Painter extends Agent {
  static final int MAXPOINTS = 1000;
  int xpoints[] = new int[MAXPOINTS];
  int ypoints[] = new int[MAXPOINTS];
  int xprevs[]  = new int[MAXPOINTS];
  int yprevs[]  = new int[MAXPOINTS];
  int xlasts[]  = new int[MAXPOINTS];
  int ylasts[]  = new int[MAXPOINTS];
  int lastx = -1;
  int lasty = -1;
  int prevx = -1;
  int prevy = -1;
  int npoints = 0;
  
  public Painter() {}
  public void init() {}
  public void create() {
    setTitle("Painter Agent");
    resize(400, 400);
    add("South", new Button("Clear"));
    setBackground(Color.white);
    for (int i = 0 ; i < MAXPOINTS ; i++ ) {
      xprevs[i] = 0;
      yprevs[i] = 0;
      xlasts[i] = 0;
      ylasts[i] = 0;
    }
    show();
  }

  public void destroy() {
    dispose();
  }
  public void arrive() {
    show();
  }
  public void suspend() {
    dispose();
  }
  public void resume() {
    show();
  }
  public void child(AgentIdentifier aid) {
    show();
  }
  public void dispatch(URL url) {
    dispose();
  }

  public void update(Graphics g) {
    for (int i = 0 ; i < npoints ; i++ ) {
      g.setColor(Color.black);
      if (i == 0) {
	g.drawLine(xlasts[0], ylasts[0], xlasts[0], ylasts[0]);	
      }
      else if (xlasts[i] == -1 && ylasts[i] == -1) {
	g.drawLine(xprevs[i], yprevs[i], xprevs[i], yprevs[i]);
      }
      else {
	g.drawLine(xprevs[i-1], yprevs[i-1], xlasts[i], ylasts[i]);
      }
    }
  }

  public void paint(Graphics g) {
    update(g);
  }

  public boolean mouseDown (Event evt, int x, int y) {
    if (npoints < MAXPOINTS) {
      xlasts[npoints] = -1;
      ylasts[npoints] = -1;
      xprevs[npoints] = x;
      yprevs[npoints] = y;
      npoints++;
    }
    return true;
  }

  public boolean mouseDrag(Event evt, int x, int y) {
    if ((x != lastx || y != lasty) && npoints < MAXPOINTS) {
      xlasts[npoints] = x;
      ylasts[npoints] = y;
      xprevs[npoints] = x;
      yprevs[npoints] = y;
      npoints++;
      repaint();
    }
    return true;
  }

  public boolean action(Event e, Object what) { 
    if ("Clear".equals(what)) {
      npoints = 0;
      dispose();
      show();
      return true;
    }
    return false;
  }

  public static void main (String args[]) {
    Painter painter = new Painter();
  }
}
