//  Created by Ichiro Satoh, 1997/9/28
//
import agentspace.*;
import java.lang.*;
import java.util.*;
import java.io.*;
import java.awt.*;
import java.net.*;
import java.io.ObjectOutputStream;

public class Present extends Agent {
  Panel p;
  private String fName = null;
  private String dName = null;
  private Image theImage = null;
  private byte[] byteImage = null;
  private int width  = -1;
  private int height = -1;
  private boolean flag = false;
  private String colorName = null;

  static final int MAXPOINTS = 1000;
  int xpoint[] = new int[MAXPOINTS];
  int ypoint[] = new int[MAXPOINTS];
  Color colors[]  = new Color[MAXPOINTS];
  int lastx;
  int lasty;
  int prevx;
  int prevy;
  int npoints = 0;

  public static void main(String[] args) {
    Present g = new Present();
    g.init();
    g.create();
  }
  public Present() {}
  public void init() {}
  public void create() {
    initWindow();
  }
  public void arrive() {
    Toolkit.getDefaultToolkit().beep();
    show();
  }
  public void dispatch(URL url) {
    theImage = null;
    dispose();
  }
  public void resume() {
    show();
  }
  public void suspend() {
    theImage = null;
    dispose();
  }
  public void destroy() {
    dispose();
  }
  public void initWindow() {
    setTitle("Image Board Agent");
    p = new Panel();
    p.add("West", new Button("GIF Load"));
    p.add("Center", new Button("JPEG Load"));
    p.add("East", new Button("Exit"));
    add("South", p);
    setBackground(Color.lightGray);
    resize(200, 80);
    for (int i = 0 ; i < MAXPOINTS ; i++ ) {
      xpoint[i] = 0;
      ypoint[i] = 0;
    }
    show();
    Toolkit.getDefaultToolkit().beep();
  }

  public void newButton() {  
    remove(p);
    p = new Panel();
    p.add("West", new Button("Clear"));
    p.add("Center", new Button("Red"));
    p.add("East", new Button("Blue"));
    add("South", p);
    show();
  }

  public void update(Graphics g) {
    if (flag == false || npoints == 0) {
      if (theImage == null ) {  
	if (byteImage == null) { 
	  System.err.println("Error: cannot open any image file.");
	}
	else {
	  theImage = Toolkit.getDefaultToolkit().createImage(byteImage);
	  if (width < 0 && height < 0) {
	    width  = theImage.getWidth(this);
	    height = theImage.getHeight(this);
	    resize(width, height+40);
	    g.drawImage(theImage, 0, 20, width, height, this);
	  }
	  else {
	    g.drawImage(theImage, 0, 20, width, height, this);	    
	  }
	}
      }
      else {
	width  = size().width; 
	height = size().height - 40;
	g.drawImage(theImage, 0, 20, width, height, this);
      }
    }
    for (int i = 0 ; i < npoints ; i++ ) {
      if (colors[i] != null) {
	g.setColor(colors[i]);
	g.fillOval(xpoint[i], ypoint[i], 10, 10);
      }
    }
  }

  public void paint(Graphics g) {
    update(g);
  }

  public boolean mouseUp(Event evt, int x, int y) {
    flag = false;
    return true;
  }

  public boolean mouseDrag(Event evt, int x, int y) {
    if (npoints < MAXPOINTS) {
      xpoint[npoints] = x;
      ypoint[npoints] = y;
      if (colorName.equals("RED")) {
	colors[npoints] = Color.red;
      }
      else if (colorName.equals("BLUE")) {
	colors[npoints] = Color.blue;
      }
      else {
	colors[npoints] = null;
      }
      flag = true;
      npoints++;
      repaint();
    }
    return true;
  }

  public boolean action(Event e, Object what) { 
    if ("GIF Load".equals(what)) {
      String fileName = null;
      if ((fileName = getFileName( "*.gif" )) != null) {
	byteImage = fileToByteArray(fileName);
	theImage = Toolkit.getDefaultToolkit().createImage(byteImage);
      }
      newButton();
      show();
      return true;
    }      
    else if ("JPEG Load".equals(what)) {
      String fileName = null;
      if ((fileName = getFileName( "*.jpg" )) != null) {
	byteImage = fileToByteArray(fileName);
	theImage = Toolkit.getDefaultToolkit().createImage(byteImage);
      }
      newButton();
      show();
      return true;
    }      
    else if ("Clear".equals(what)) {
      npoints = 0;
      dispose();
      show();
      return true;
    }
    else if ("Red".equals(what)) {
      colorName = "RED";
      return true;
    }
    else if ("Blue".equals(what)) {
      colorName = "BLUE";
      return true;
    }
    else if ("Exit".equals(what)) {
      dispose();
      AgentContext ac = getAgentContext();
      ac.send("destroy");
      return true;
    }
    return false;
  }

  public boolean handleEvent(Event evt) {
    if (evt.id == Event.WINDOW_DESTROY) {
      dispose();
      AgentContext ac = getAgentContext();
      ac.send("destroy");
    }
    return super.handleEvent(evt);
  }
  
  public String getFileName(String pattern) {
    FileDialog fd = new FileDialog(this, "Load Class");
    fd.setFile(pattern);
    fd.setDirectory( "." );
    fd.show();
    if (fd.getDirectory() != null && fd.getFile() != null) {
      fName = fd.getFile();
      dName = fd.getDirectory();
      return fd.getDirectory() + fd.getFile();
    }
    else {
      return null;
    }
  }

  public byte[] fileToByteArray(String fileName) {
    byte[] data = null;
    try {
      FileInputStream inStream = new FileInputStream(fileName);
      ByteArrayOutputStream byteout = new ByteArrayOutputStream();
      byte[] bytes = new byte[1024];
      int count;
      while ((count = inStream.read(bytes)) != -1) {
	byteout.write(bytes, 0, count);
      }
      data = byteout.toByteArray();
      byteout.close();
      inStream.close();
    } catch (IOException e) {
      e.printStackTrace();
    }
    return data;
  }
}





