/**
 * The RoundTriper class is the abstract base class for RoundTriper objects. 
 * Use this class to create your own personalized RoundTripers.
 * @version     0.01    97/9/10
 * @author      Ichiro Satoh
 */

import agentspace.*;
import java.lang.*;
import java.io.*;
import java.awt.*;
import java.net.*;

public class RoundTriper extends Agent {
  private long total = 0;
  private int count = 0;
  private boolean flag = false;
  private Panel p1 = new Panel();
  private Panel p2 = new Panel();
  private Panel p3 = new Panel();
  private TextField addtf = null;
  private TextField restf = null;
  private TextArea resArea = null;
  private Button b1 = new Button("START");
  private Button b2 = new Button("STOP");
  private Button b3 = new Button("QUIT");
  private String address;
  private byte[] data;
  public RoundTriper(){}
  public void init(){}
  public void destroy(){
    dispose();
  }
  public void suspend(){}
  public void resume(){}
  public void create(){
    AgentContext ac = getAgentContext();
    setTitle("Round Trip Time");
    setBackground(Color.lightGray);
    Font f14 = new Font("Helvetica", Font.BOLD, 14);
    p1.add(new Label("Address:"));
    addtf = new TextField(ac.getCurrentHost().getHost(), 20);
    addtf.setFont(f14);
    p1.add(addtf);
    restf = new TextField("", 8);
    restf.setFont(f14);
    p2.add("West",   b1);
    p2.add("Center", b2);
    p2.add("East",   b3);
    p2.add("East",   restf);
    b2.disable();
    resArea = new TextArea(10, 30);
    resArea.setText("");
    resArea.setEditable(false);
    resArea.setBackground(Color.white);
    Font f12 = new Font("Courier",  Font.PLAIN, 12);
    resArea.setFont(f12);
    p3.add(resArea);
    add("North",  p1);
    add("Center", p2);
    add("South",  p3);
    pack();
    show();
    data = fileToByteArray("Triper.agent");
  }
  public void dispatch(URL url){
    dispose();
  }
  public void arrive(){
    show();
  }
  public void reply(Long result) {
    count++;
    String numString = ""+count;
    for ( int i = numString.length() ; i < 6 ; i++ ) {
      numString = " " + numString;
    }
    String resultString = ""+result;
    for ( int i = resultString.length() ; i < 8 ; i++ ) {
      resultString = " " + resultString;
    }
    resArea.append(numString+": "+resultString+" ms"+"\n");
    total = total + result.longValue();
    restf.setText(""+(total/count)+" ms");
    show();
    try{
      Thread.sleep( 5000 );
    } catch (Exception e) {}
    transfer();
  }
  public synchronized void transfer() {
    if (flag){
      AgentContext ac = getAgentContext();
      AgentIdentifier aid = ac.create(data);
      ac.send(aid, "go", ac.getIdentifier(), address);
    }
  }
  public boolean action(Event evt, Object what) {
    AgentContext ac = getAgentContext();
    if ("QUIT".equals(what)) {
      ac.send("destroy");
      return true;
    }
    if ("STOP".equals(what)) {
      b1.enable();
      b2.disable();
      flag = false;
      return true;
    }
    if ("START".equals(what)) {
      b1.disable();
      b2.enable();
      flag = true;
      address = addtf.getText();
      transfer();
      return true;
    }
    return false;
  }
  private byte[] fileToByteArray(String fileName) {
    byte[] data = null;
    try {
      FileInputStream inStream = new FileInputStream(fileName);
      ByteArrayOutputStream byteout = new ByteArrayOutputStream();
      byte[] bytes = new byte[1024];
      int count;
      while ((count = inStream.read(bytes)) != -1) {
	byteout.write(bytes, 0, count);
      }
      data = byteout.toByteArray();
      byteout.close();
      inStream.close();
    } catch (IOException e) {
      e.printStackTrace();
    }
    return data;
  }
}
