/*
 * Copyright (C) 1997 Ichiro Satoh
 * All Rights Reserved.
 * written by Ichiro Satoh
 *
 * This program was developed by Ichiro Satoh at Ochanomizu University 
 * as a part of a mobile object system, titled "AgentSpace". All the 
 * programs of the system is developed by Ichiro Satoh and all rights 
 * are reserved by Ichiro Satoh. 
 *
 * Permission to use, copy, modify and distribute this software and
 * its documentation is hereby granted, provided that both the
 * copyright notice and this permission notice appear in all copies of
 * the software, derivative works or modified versions, and any
 * portions thereof, and that both notices appear in supporting 
 * documentation.
 *
 * FREE USE OF THIS SOFTWARE IS ALLOWED IN ITS "AS IS" CONDITION.
 * BUT WITHOUT WARRANTY. THE AUTHORS DISCLAIM ANY LIABILITY OF ANY 
 * KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS 
 * SOFTWARE.
 */



import agentspace.*;
import java.lang.*;
import java.io.*;
import java.net.*;

public class Triper extends Agent implements Serializable {
  URL birthURL = null;
  long startTime;
  long currentTime;
  AgentIdentifier aid;
  public Triper(){}
  public void init(){}
  public void destroy(){}
  public void suspend(){}
  public void resume(){}
  public void duplicate(){}
  public void child(AgentIdentifier paid) {}
  public void parent(AgentIdentifier caid) {}
  public void create(){
    AgentContext ac = getAgentContext();
    birthURL = ac.getCurrentHost();
  }
  public void dispatch(URL url){
    AgentContext ac = getAgentContext();
    URL arriveURL = ac.getCurrentHost();
    if (arriveURL.equals(birthURL)) {
      startTime = System.currentTimeMillis();
    }
  }
  public void arrive(){
    AgentContext ac = getAgentContext();
    URL arriveURL = ac.getCurrentHost();
    if (arriveURL.equals(birthURL)) {
      currentTime = System.currentTimeMillis();
      System.out.println("===============================");
      System.out.println("Round-trip Time = "+(currentTime - startTime)+" ms");
      System.out.println("===============================");
      Long result = new Long(currentTime - startTime);
      if (aid != null) {
	ac.send(aid, "reply", result);
	ac.send("destroy");
      }
    }
    else {
      System.out.println(">>>>>>>>Hello!<<<<<<<<");
      ac.send("dispatch", birthURL.getHost());
    }
  }
  public void go(AgentIdentifier aid, String addr) {
    this.aid = aid;
    AgentContext ac = getAgentContext();
    ac.send("dispatch", addr);
  }
}
