/*
 * Copyright (c) 1997 Ichiro Satoh
 * All Rights Reserved.
 * written by Ichiro Satoh
 *
 * This program was developed by Ichiro Satoh at Ochanomizu University 
 * as a part of a mobile object system, titled "AgentSpace". All the 
 * programs of the system is developed by Ichiro Satoh and all rights 
 * are reserved by Ichiro Satoh. 
 *
 * Permission to use, copy, modify and distribute this software and
 * its documentation is hereby granted, provided that both the
 * copyright notice and this permission notice appear in all copies of
 * the software, derivative works or modified versions, and any
 * portions thereof, and that both notices appear in supporting 
 * documentation.
 *
 * FREE USE OF THIS SOFTWARE IS ALLOWED IN ITS "AS IS" CONDITION.
 * BUT WITHOUT WARRANTY. THE AUTHORS DISCLAIM ANY LIABILITY OF ANY 
 * KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS 
 * SOFTWARE.
 */

/*
 * The Agent class is the abstract base class for Agent objects. 
 * Use this class to create your own personalized agents.
 * @version     0.01    97/9/10
 * @author      Ichiro Satoh
 */

package agentspace;

import java.awt.*;
import java.lang.*;
import java.io.*;
import java.net.*;

public class Agent extends Frame implements Serializable {
  static final long serialVersionUID = 3350253579874903361L;
  transient public AgentContext context = null;
  public Agent() {
    System.out.println("Agent: an instance created.");
  }
  public void init() {
    System.out.println("Agent: method init() called");
  }
  public void stop() {
    System.out.println("Agent: method stop() called");
  }
  public void run() {
    System.out.println("Agent: method run() called");
  }
  public void create(){
    System.out.println("Agent: method destory() called");
  }
  public void destroy(){
    System.out.println("Agent: method destroy() called");
  }
  public void dispatch(URL url){
    System.out.println("Agent: method dispatch() called");
  }
  public void arrive(){
    System.out.println("Agent: method arrive() called");
  }
  public void suspend(){
    System.out.println("Agent: method suspend() called");
  }
  public void resume(){
    System.out.println("Agent: method resume() called");
  }
  public void duplicate(){
    System.out.println("Agent: method duplicate() called");
  }
  public void parent(AgentIdentifier aid){
    System.out.println("Agent: method parent() called");
  }
  public void child(AgentIdentifier aid){
    System.out.println("Agent: method child() called");
  }
  public boolean except(String message) {
    System.out.println("Agent: method except() called with "+message);
    return true;
  }
  public void setAgentContext(AgentContext agentContext) {
    context = agentContext;
  }
  public final AgentContext getAgentContext() {
    return context;
  }
}
