/*
 * Copyright (C) 1997 Ichiro Satoh
 * All Rights Reserved.
 * written by Ichiro Satoh
 *
 * This program was developed by Ichiro Satoh at Ochanomizu University 
 * as a part of a mobile object system, titled "AgentSpace". All the 
 * programs of the system is developed by Ichiro Satoh and all rights 
 * are reserved by Ichiro Satoh. 
 *
 * Permission to use, copy, modify and distribute this software and
 * its documentation is hereby granted, provided that both the
 * copyright notice and this permission notice appear in all copies of
 * the software, derivative works or modified versions, and any
 * portions thereof, and that both notices appear in supporting 
 * documentation.
 *
 * FREE USE OF THIS SOFTWARE IS ALLOWED IN ITS "AS IS" CONDITION.
 * BUT WITHOUT WARRANTY. THE AUTHORS DISCLAIM ANY LIABILITY OF ANY 
 * KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS 
 * SOFTWARE.
 */

package agentspace;

import java.awt.*;
import java.lang.*;
import java.io.*;
import java.net.*;
import java.util.*;

class AgentAboutDialog extends Dialog {
  public AgentAboutDialog(Frame parentFrame, String title, Enumeration msgs) {
    super(parentFrame, title, false);
    initWindow(msgs);
  }

  private void initWindow(Enumeration enum) {
    setBackground(SystemColor.menu);
    TextArea textArea = new TextArea(20, 60);
    Font f = new Font("Courier", Font.PLAIN, 12);
    textArea.setFont(f);
    while(enum.hasMoreElements()) {
      textArea.appendText(enum.nextElement() + "\n");
    }
    textArea.setEditable(false);
    add("North", textArea);

    Panel p = new Panel();
    p.add(new Button("OK"));
    add("South", p);
    pack();
    show();
  }

  public boolean handleEvent(Event evt) {
    switch(evt.id) {
      case Event.ACTION_EVENT: {
	if("OK".equals(evt.arg)) {
	  dispose();
	  return true;
	}
      }
    }
    return false;
  }
/*
  public boolean handleEvent(Event evt, Object what) {
    if("OK".equals(what)) {
      System.out.println("AboutDialog: push OK button");
      dispose();
      return true;
    }
    return false;
  }
*/
}

