/*
 * Copyright (C) 1997 Ichiro Satoh
 * All Rights Reserved.
 * written by Ichiro Satoh
 *
 * This program was developed by Ichiro Satoh at Ochanomizu University 
 * as a part of a mobile object system, titled "AgentSpace". All the 
 * programs of the system is developed by Ichiro Satoh and all rights 
 * are reserved by Ichiro Satoh. 
 *
 * Permission to use, copy, modify and distribute this software and
 * its documentation is hereby granted, provided that both the
 * copyright notice and this permission notice appear in all copies of
 * the software, derivative works or modified versions, and any
 * portions thereof, and that both notices appear in supporting 
 * documentation.
 *
 * FREE USE OF THIS SOFTWARE IS ALLOWED IN ITS "AS IS" CONDITION.
 * BUT WITHOUT WARRANTY. THE AUTHORS DISCLAIM ANY LIABILITY OF ANY 
 * KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS 
 * SOFTWARE.
 */

package agentspace;

import java.lang.*;
import java.util.*;
import java.io.*;
import java.io.ObjectOutputStream;
import java.util.zip.*;

public class AgentByteCode {
  public AgentByteCode() {}

  public static Object byteArrayToObject(byte[] data) {
    Object newObject = null;
    try {
//      System.out.println("byteArrayToObject: data.lenght =  "+data.length);
      ByteArrayInputStream bytein = new ByteArrayInputStream(data);
      ObjectInputStream objin = new ObjectInputStream(bytein);
      newObject = objin.readObject();
      objin.close();
      bytein.close();
    } 
    catch (IOException e) {
      e.printStackTrace();
    }
    catch (ClassNotFoundException e) {
      e.printStackTrace();
    }
    return newObject;
  }

  public static byte[] objectToByteArray(Object obj) {
    byte[] data = null;
    try {
      ByteArrayOutputStream byteout = new ByteArrayOutputStream();
      ObjectOutputStream objout = new ObjectOutputStream(byteout);
      objout.writeObject(obj);
      objout.flush();
      data = byteout.toByteArray();
//      System.out.println(""+obj.getClass()+" : data.lenght =  "+data.length);
      objout.close();
      byteout.close();
    } catch (IOException e) {
      e.printStackTrace();
    }
    return data;
  }


  public static void objectToFile(String fileName, Object obj) {
    try {
      FileOutputStream outStream = new FileOutputStream(fileName);
      ObjectOutputStream objout = new ObjectOutputStream(outStream);
      objout.writeObject(obj);
      objout.flush();
      objout.close();
      outStream.close();
    } catch (IOException e) {
      e.printStackTrace();
    }
  }

  public static Object fileToObject(String fileName) {
    Object newObject = null;
    try {
      FileInputStream inStream = new FileInputStream(fileName);
      ObjectInputStream objin = new ObjectInputStream(inStream);
      newObject = objin.readObject();
      objin.close();
      inStream.close();
    } 
    catch (IOException e) {
      e.printStackTrace();
    }
    catch (ClassNotFoundException e) {
      e.printStackTrace();
    }
    return newObject;
  }

  public static byte[] fileToByteArray(String fileName) {
    byte[] data = null;
    try {
      FileInputStream inStream = new FileInputStream(fileName);
      ByteArrayOutputStream byteout = new ByteArrayOutputStream();
      byte[] bytes = new byte[1024];
      int count;
      while ((count = inStream.read(bytes)) != -1) {
	byteout.write(bytes, 0, count);
      }
      data = byteout.toByteArray();
//      System.out.println(fileName+" : data.lenght =  "+data.length);
      byteout.close();
      inStream.close();
    } catch (IOException e) {
      e.printStackTrace();
    }
    return data;
  }

  public static void byteArrayToFile(String fileName, byte[] data) {
    try {
      FileOutputStream outStream = new FileOutputStream(fileName);
      outStream.write(data, 0, data.length);
    } catch (IOException e) {
      e.printStackTrace();
    }
  }

  public static String byteArrayToString(byte[] data) {
    return new String(data, 0);
  }

  public static byte[] stringToByteArray(String str) {
    byte[] buf = new byte[str.length()];
    str.getBytes(0, str.length(), buf, 0);
    return buf;
  }

  public static byte[] streamToByteArray(InputStream is) {
    byte[] data = null;
    try {
      DataInputStream netis = new DataInputStream(is);
      ByteArrayOutputStream byteout = new ByteArrayOutputStream();
      byte[] buffer = new byte[1024];
      int count;
      while ((count = netis.read(buffer)) != -1) {
	byteout.write(buffer, 0, count);
      }
      data = byteout.toByteArray();
      byteout.close();
      netis.close();
    }
    catch (Exception e) {
      e.printStackTrace();
    }
    return data;
  }

  public static byte[] filesToZipByteArray(String[] fileNames) {
    byte[] data = null;
    try{
      ByteArrayOutputStream baos = new ByteArrayOutputStream();
      ZipOutputStream zipostream = new ZipOutputStream(baos);
      for(int i = 0 ; i < fileNames.length ; i++ ) {
	byte[] code = fileToByteArray(fileNames[i]);
	zipostream.putNextEntry(new ZipEntry(fileNames[i]));
	zipostream.write(code, 0, code.length);
	System.out.println("code.length = "+code.length+" name = "
			   +fileNames[i]);
      }
      zipostream.close();
      data = baos.toByteArray();
      baos.close();
      System.out.println("data.length = "+data.length);
    } catch (IOException e) { 	 
      System.err.println(e); 	 
    } 
    return data;
  }
}


