/*
 * Copyright (C) 1997 Ichiro Satoh
 * All Rights Reserved.
 * written by Ichiro Satoh
 *
 * This program was developed by Ichiro Satoh at Ochanomizu University 
 * as a part of a mobile object system, titled "AgentSpace". All the 
 * programs of the system is developed by Ichiro Satoh and all rights 
 * are reserved by Ichiro Satoh. 
 *
 * Permission to use, copy, modify and distribute this software and
 * its documentation is hereby granted, provided that both the
 * copyright notice and this permission notice appear in all copies of
 * the software, derivative works or modified versions, and any
 * portions thereof, and that both notices appear in supporting 
 * documentation.
 *
 * FREE USE OF THIS SOFTWARE IS ALLOWED IN ITS "AS IS" CONDITION.
 * BUT WITHOUT WARRANTY. THE AUTHORS DISCLAIM ANY LIABILITY OF ANY 
 * KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS 
 * SOFTWARE.
 */

package agentspace;

import java.io.*;
import java.util.*;
import java.util.zip.*;
import java.net.*;

public class AgentClassLoader extends ClassLoader {
  private URL baseURL;
  private String fileName = null;
  private Hashtable cache;

  public AgentClassLoader(URL url) {
    cache = new Hashtable();
    baseURL = url;
  }

  public AgentClassLoader(String str) throws MalformedURLException {
    this(new URL(str));
  }

  public void remove() {
    cache.clear();
    cache = null;
    baseURL = null;
    fileName = null;
  }

  public Hashtable agentClassDataLoad(byte[] data) {
    try {
      ByteArrayInputStream byteInStream = new ByteArrayInputStream(data);
      ZipInputStream zipInStream = new ZipInputStream(byteInStream);
      ZipEntry zipEnt;
      while ((zipEnt = zipInStream.getNextEntry()) != null) {
	String entryName = zipEnt.getName();
	if (entryName.startsWith("META-INF")) {
	  continue;
	}
	int count;
	ByteArrayOutputStream byteOutStream = new ByteArrayOutputStream();
	byte[] classBytes = new byte[1024];
	while ((count = zipInStream.read(classBytes)) != -1) {
	  byteOutStream.write(classBytes, 0, count);
	}
	byte[] bytes = byteOutStream.toByteArray();
//	byte[] code = new byte[bytes.length];
//	System.arraycopy(bytes, 0, code, 0, bytes.length);
//	System.out.println("entry name = "+entryName);
	cache.put(entryName, bytes);
      }
      zipInStream.close();
      byteInStream.close(); 	 
    } catch (IOException e) { 	 
      System.err.println(e); 	 
    } 
    return cache;
  }

  public synchronized Class loadClass(String className) 
  throws ClassNotFoundException {
    return loadClass(className, true);
  }

  public synchronized Class loadClass(String name, boolean resolve)
  throws ClassNotFoundException {
//    System.out.println("Loading: trying "+name+" from myloader");
    Class c = null;
    byte[] data = (byte[])cache.get(name);
    if (data == null) {
      if (!(name.endsWith(".class"))) {
	String className = name + ".class";
	data = (byte[])cache.get(className);
      }
    }
    if (data != null) {
//    System.out.println("Loading: "+name+" from cache");
      c = defineClass(data, 0, data.length);
      if (c != null && c instanceof Class) {
	if (resolve) {
	  resolveClass(c);
	}
// System.out.println("Loading: "+name+" Succeed from "+baseURL+fileName);
	return c;
      }
    }
    try {
      c = findSystemClass(name);
    }
    catch(ClassNotFoundException e) {}
    if (c != null && c instanceof Class) {
//System.out.println("Loading: "+name+" Succeed from CLASSPATH");
      return c;
    }
    data = loadClassData(name);
    if (data == null) {
      data = loadClassData("agentspace/"+name);
    }
// System.out.println("ZipClassLoader: loadClassData(): data = "+data.length);
    c = defineClass(data, 0, data.length);
    if (c != null && c instanceof Class) {
      if (resolve) {
	resolveClass(c);
      }
//System.out.println("Loading: "+name+" Succeed....");
      if (name.endsWith(".class")) {
	cache.put(name, data);
      }
      else {
	name = name + ".class";
	cache.put(name, data);
      }
      return c;
    }
    else {
      throw new ClassNotFoundException(name);
    }
  }

  private byte[] loadClassData(String name) {
    String className;
    if(name.endsWith(".class")) {
      className = name;
    }
    else {
      className = name + ".class";
    }
    try {
//System.out.println("loadClassData = "+className);
      File classFile = new File(className);
      byte[] data = null;
      long bytecount = classFile.length();
      if (bytecount > 0) {
	data = new byte[(int)bytecount];
	FileInputStream in = new FileInputStream(classFile);
	in.read(data);
	in.close();
//System.out.println("Loading "+name);
	return data;
      }
    }
    catch(FileNotFoundException e) {
      return null;
    }
    catch (IOException e) {
// System.out.println("IO error: " + e);
      e.printStackTrace();
      return null;
    } 
    catch (Throwable e) {
//System.out.println("error: findClass() " + e.toString());
      e.printStackTrace();
      return null;
    }
    return null;
  }
}
