/*
 * Copyright (C) 1997 Ichiro Satoh
 * All Rights Reserved.
 * written by Ichiro Satoh
 *
 * This program was developed by Ichiro Satoh at Ochanomizu University 
 * as a part of a mobile object system, titled "AgentSpace". All the 
 * programs of the system is developed by Ichiro Satoh and all rights 
 * are reserved by Ichiro Satoh. 
 *
 * Permission to use, copy, modify and distribute this software and
 * its documentation is hereby granted, provided that both the
 * copyright notice and this permission notice appear in all copies of
 * the software, derivative works or modified versions, and any
 * portions thereof, and that both notices appear in supporting 
 * documentation.
 *
 * FREE USE OF THIS SOFTWARE IS ALLOWED IN ITS "AS IS" CONDITION.
 * BUT WITHOUT WARRANTY. THE AUTHORS DISCLAIM ANY LIABILITY OF ANY 
 * KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS 
 * SOFTWARE.
 */

package agentspace;

import java.lang.*;
import java.util.*;
import java.io.*;
import java.net.*;

public class AgentClone extends Thread {
  AgentInfo theParentInfo = null;
  AgentInfo theChildInfo = null;
  AgentManager theAgentManager = null;
  AgentIdentifier childIdentifier = null;
  public AgentClone(AgentManager am) {
    theAgentManager = am;
  }

  public synchronized AgentInfo cloneAgent(AgentInfo painfo) {

    byte[] temp = painfo.getAgentCode();
    byte[] code = new byte[temp.length];
    System.arraycopy(temp, 0, code, 0, temp.length);
    AgentInfo cinfo = makeCloneAgent(painfo);
    cinfo.setAgentCode(code);
    cinfo.setAgentStatus(AgentStatus.CHILD);
    cinfo.setOriginalIdentifier(painfo.getOriginalIdentifier());
    cinfo.setOriginalHost(painfo.getOriginalHost());
    cinfo.setCurrentHost(painfo.getCurrentHost());
    cinfo.setPreviousHost(painfo.getPreviousHost());
    cinfo.setCodeBaseHost(painfo.getCodeBaseHost());
    cinfo.setAgentThread(Thread.currentThread());
    cinfo.setParentList(painfo.getParentList());
    cinfo.addParentList(painfo.getIdentifier());

    if (cinfo.getName() == null) {
      String name = ((cinfo.getAgent()).getClass()).toString();
      if (name.startsWith("class ")) {
	name = name.substring(6,name.length());
      }
      cinfo.setName(name);
    }
    return theAgentManager.registry(cinfo);
  }

  private AgentInfo makeCloneAgent(AgentInfo ainfo) {
    AgentInfo cinfo = new AgentInfo();
    Agent anAgent = null;
    byte context[] = AgentByteCode.objectToByteArray(ainfo.getAgent());
    byte code[] = ainfo.getAgentCode();
    URL codeBaseHost = ainfo.getCodeBaseHost();
    AgentLoader agentLoader = new AgentLoader();
    Object obj = agentLoader.loadAgent(context, code, codeBaseHost);
    if (obj != null && obj instanceof Agent) {
      anAgent = (Agent)obj;
      cinfo.setAgent(anAgent);
    }
    cinfo.setAgentLoader(agentLoader);
    return cinfo;
  }
}
