/*
 * Copyright (C) 1997 Ichiro Satoh
 * All Rights Reserved.
 * written by Ichiro Satoh
 *
 * This program was developed by Ichiro Satoh at Ochanomizu University 
 * as a part of a mobile object system, titled "AgentSpace". All the 
 * programs of the system is developed by Ichiro Satoh and all rights 
 * are reserved by Ichiro Satoh. 
 *
 * Permission to use, copy, modify and distribute this software and
 * its documentation is hereby granted, provided that both the
 * copyright notice and this permission notice appear in all copies of
 * the software, derivative works or modified versions, and any
 * portions thereof, and that both notices appear in supporting 
 * documentation.
 *
 * FREE USE OF THIS SOFTWARE IS ALLOWED IN ITS "AS IS" CONDITION.
 * BUT WITHOUT WARRANTY. THE AUTHORS DISCLAIM ANY LIABILITY OF ANY 
 * KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS 
 * SOFTWARE.
 */

package agentspace;
import java.awt.*;
import java.awt.event.*;
import java.lang.*;
import java.io.*;
import java.net.*;
import java.util.*;

class AgentDestDialog extends Dialog 
implements ActionListener {
//implements ActionListener, WindowListener, MouseListener {
  private TextField addrField;
  private TextField portField;
  private AgentManager theAgentManager;
  private AgentInfo theInfo;
  private String destAddress;
  private Point mousePoint;

  public AgentDestDialog(Frame parentFrame, AgentManager amgr, 
			 AgentInfo ainfo, Point mPoint) {
    super(parentFrame, "Destination Agent Server", true);
    theAgentManager = amgr;
    theInfo = ainfo;
    destAddress = null;
    mousePoint = mPoint;
    initWindow();
  }

  private void initWindow() {
    setBackground(SystemColor.menu);
    setLocation(mousePoint);
    TextArea textArea = new TextArea(20, 60);
    Font f = new Font("Courier", Font.PLAIN, 12);
    textArea.setFont(f);

    Panel addr = new Panel();
    addr.setLayout(new GridLayout());
    addr.add(new Label("Destination IP Address: "), "East");
    addr.add(addrField = new TextField(AgentServer.theSendHost, 20));

    Panel port = new Panel();
    port.setLayout(new GridLayout());
    port.add(new Label("Port: "), "East");
    port.add(portField = new TextField(""+AgentServer.theSendPort, 20));

    Panel butt = new Panel();
    butt.setLayout(new FlowLayout());
    Button cancelButton = new Button("Cancel");
    Button movetoButton = new Button("Move To");
    butt.add(cancelButton);
    butt.add(movetoButton);
    cancelButton.addActionListener(this);
    movetoButton.addActionListener(this);

//  addMouseListener(this);    
//  addWindowListener(this);

    add("North",  addr);
    add("Center", port);
    add("South",  butt);
    pack();

    Point p = getLocation();
    Dimension d = getSize();
    setLocation(p.x - d.width/2, p.y - d.height/2);
    show();
  }

  public void mouseClicked(MouseEvent e) {}
  public void mouseEntered(MouseEvent e) {}
  public void mouseExited(MouseEvent e) {}
  public void mousePressed(MouseEvent e) {}
  public void mouseReleased(MouseEvent e) {}
  public void windowOpened(WindowEvent e) {}
  public void windowActivated(WindowEvent e) {}
  public void windowDeactivated(WindowEvent e) {}
  public void windowClosed(WindowEvent e) {dispose();}
  public void windowIconified(WindowEvent e){}
  public void windowDeiconified(WindowEvent e){}
  public void windowClosing(WindowEvent e){dispose();}

  public void actionPerformed(ActionEvent evt) {
    String command = evt.getActionCommand();
    if (evt.getID() == WindowEvent.WINDOW_CLOSING) {
      dispose();
    }
    else if (command.equals("Move To")) {
      try {
	AgentServer.theSendHost = addrField.getText();
	dispose();
	AgentServer.theSendPort = Integer.parseInt(portField.getText()); 
	AgentRuntime art = theInfo.getAgentRuntime();
	art.dispatchRequest(AgentServer.theSendHost);
      }      
      catch (NumberFormatException e) {
	addrField.setText("Illugeal Address");	
	show();
      }
    } 
    else if (command.equals("Cancel")) {
      dispose();
    }
  }
}

