/*
 * Copyright (C) 1997 Ichiro Satoh
 * All Rights Reserved.
 * written by Ichiro Satoh
 *
 * This program was developed by Ichiro Satoh at Ochanomizu University 
 * as a part of a mobile object system, titled "AgentSpace". All the 
 * programs of the system is developed by Ichiro Satoh and all rights 
 * are reserved by Ichiro Satoh. 
 *
 * Permission to use, copy, modify and distribute this software and
 * its documentation is hereby granted, provided that both the
 * copyright notice and this permission notice appear in all copies of
 * the software, derivative works or modified versions, and any
 * portions thereof, and that both notices appear in supporting 
 * documentation.
 *
 * FREE USE OF THIS SOFTWARE IS ALLOWED IN ITS "AS IS" CONDITION.
 * BUT WITHOUT WARRANTY. THE AUTHORS DISCLAIM ANY LIABILITY OF ANY 
 * KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS 
 * SOFTWARE.
 */

package agentspace;

import java.lang.*;
import java.io.*;
import java.net.*;
import java.util.*;

public class AgentFile {
  private AgentManager theAgentManager;
  public AgentFile(AgentManager am) {
    theAgentManager = am;
  }

  public byte[] save(AgentInfo ainfo) {
    byte[] data = null;
    try {
      ByteArrayOutputStream bos = new ByteArrayOutputStream();
      AgentWriteStream sos = new AgentWriteStream(bos);
      sos.storeAgent(ainfo);
      bos.flush();
      data = bos.toByteArray();
    }
    catch (IOException e) { 	 
      System.err.println(e); 	 
    } 
    return data;
  }

  public void save(String fileName, AgentInfo ainfo) {
    try {
      FileOutputStream fos = new FileOutputStream(fileName); 
      AgentWriteStream sos = new AgentWriteStream(fos);
      sos.storeAgent(ainfo);
      fos.close();
    } catch (IOException e) { 	 
      System.err.println(e); 	 
    } 
  }

  public synchronized AgentInfo load(String fileName) {
    byte[] data = AgentByteCode.fileToByteArray(fileName);
    return load(data);
  }

  public synchronized AgentInfo load(byte[] data) {
    AgentPacketReader apr = new AgentPacketReader(data);
    return theAgentManager.registry(apr.getAgentData());
  }
}
