/*
 * Copyright (C) 1997 Ichiro Satoh
 * All Rights Reserved.
 * written by Ichiro Satoh
 *
 * This program was developed by Ichiro Satoh at Ochanomizu University 
 * as a part of a mobile object system, titled "AgentSpace". All the 
 * programs of the system is developed by Ichiro Satoh and all rights 
 * are reserved by Ichiro Satoh. 
 *
 * Permission to use, copy, modify and distribute this software and
 * its documentation is hereby granted, provided that both the
 * copyright notice and this permission notice appear in all copies of
 * the software, derivative works or modified versions, and any
 * portions thereof, and that both notices appear in supporting 
 * documentation.
 *
 * FREE USE OF THIS SOFTWARE IS ALLOWED IN ITS "AS IS" CONDITION.
 * BUT WITHOUT WARRANTY. THE AUTHORS DISCLAIM ANY LIABILITY OF ANY 
 * KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS 
 * SOFTWARE.
 */

package agentspace;

import java.lang.*;
import java.util.*;
import java.io.*;

public class AgentIdentifier implements Serializable {
  private long theIdentifier = 0;
  private static long count = 0;
  final private static long GENERAL_MANAGER  = 00000000001L;
  final private static long RESOURCE_MANAGER = 00000000002L;
  final private static long NETWORK_MANAGER  = 00000000003L;
  final private static long FILE_MANAGER     = 00000000004L;
  final private static long IO_MANAGER       = 00000000005L;
  final private static long AGENT_MANAGER    = 00000000006L;
  final private static long PLACE_MANAGER    = 00000000007L;

  public AgentIdentifier(long id) {
    theIdentifier = createIdentifier(id);
  }

  public AgentIdentifier() {
    this(0);
  }

  public long getIdentifier() {
    return theIdentifier;
  }

  public static AgentIdentifier GeneralManager() {
    AgentIdentifier aid = new AgentIdentifier(GENERAL_MANAGER);
    return aid;
  }

  private long createIdentifier(long n) {
    if ( n != 0 ) {
      return n;
    }
    synchronized(AgentIdentifier.class) {
      count++;
    }
    long top;
    Random gen = new Random(count+(System.currentTimeMillis()%100));
    while((top = gen.nextLong() % 10) < 1){}
    theIdentifier = (top * 1000000 + (gen.nextLong() % 1000000)) * 1000000000
      + (System.currentTimeMillis()+count) % 1000000000;
    return theIdentifier;    
  }

  public String toString() {
    return new Long(theIdentifier).toString();
  }

  public void copyTo(AgentIdentifier aid) {
    aid.theIdentifier = theIdentifier;
  }

  public boolean equals(Object object) {
    if (object instanceof AgentIdentifier) {
      long num = ((AgentIdentifier)object).getIdentifier();
      if (num == theIdentifier) {
	return true;
      }
    }
    return false;
  }

  public int hashCode() {
    return (int)theIdentifier;
  }
}


