package agentspace;

import java.io.*;
import java.net.*;
import java.lang.*;
import java.util.*;

public class AgentInfo {
  private Agent theAgent = null;
  private AgentRuntime theAgentRuntime = null;
  private String theName = null;
  private AgentIdentifier theIdentifier = null;
  private AgentIdentifier theOriginalIdentifier = null;
  private AgentContext theAgentContext = null;
  private Date theBirthday = null;
  private Date theLastModified = null;
  private String theStatus = null;
  private URL theOriginalHostURL = null;
  private URL theCurrentHostURL = null;
  private URL thePreviousHostURL = null;
  private URL theCodeBaseHostURL = null;
  private byte[] theCode;
  private Thread theThread;
  private String theError = null;
  private AgentLoader theLoader = null;
  private Vector theParentList = null;

  public AgentInfo(Agent anAgent) {
    theStatus = AgentStatus.PREINIT; 
    theAgent = anAgent;
    theBirthday = new Date();
    theParentList = new Vector();
  }

  public AgentInfo() {
    this(null);
  }

  public AgentRuntime getAgentRuntime() {
    return theAgentRuntime;
  }

  public void setAgentRuntime(AgentRuntime art) {
    theAgentRuntime = art;
  }

  public void setAgent(Agent anAgent) {
    theAgent = anAgent;
  }

  public Agent getAgent() {
    return theAgent;
  }

  public void setIdentifier(AgentIdentifier id) {
    theIdentifier = id;
  }

  public AgentIdentifier getIdentifier() {
    return theIdentifier;
  }

  public void setAgentContext(AgentContext ac) {
    theAgentContext = ac;
  }

  public AgentContext getAgentContext() {
    return theAgentContext;
  }

  public void setName(String name) {
    theName = name;
  }

  public String getName() {
    return theName;
  }

  public void setOriginalHost(URL url) {
    theOriginalHostURL = url;
  }

  public URL getOriginalHost() {
    return theOriginalHostURL;
  }

  public void setCurrentHost(URL url) {
    theCurrentHostURL = url;
  }

  public URL getCurrentHost() {
    return theCurrentHostURL;
  }

  public void setPreviousHost(URL url) {
    thePreviousHostURL = url;
  }

  public URL getPreviousHost() {
    return thePreviousHostURL;
  }

  public void setCodeBaseHost(URL url) {
    theCodeBaseHostURL = url;
  }

  public URL getCodeBaseHost() {
    return theCodeBaseHostURL;
  }

  public Date getBirthday() {
    return theBirthday;
  }

  public String getAgentStatus() {
    return theStatus;
  }

  public void setAgentStatus(String status) {
    theStatus = status;
  }

  public void setAgentCode(byte[] code) {
    theCode = code;
  }

  public byte[] getAgentCode() {
    return theCode;
  }

  public void setOriginalIdentifier(AgentIdentifier id) {
    theOriginalIdentifier = id;
  }

  public AgentIdentifier getOriginalIdentifier() {
    return theOriginalIdentifier;
  }

  public void setAgentThread(Thread thrd) {
    theThread = thrd;
  }

  public Thread getAgentThread() {
    return theThread;
  }

  public synchronized void addParentList(AgentIdentifier aid) {
    theParentList.addElement(aid.toString());
  }

  public synchronized Vector getParentList() {
    return theParentList;
  }

  public synchronized AgentIdentifier getParentIdentifier() {
    String idString = (String)(theParentList.lastElement());
    long id = (new Long(idString)).longValue();
    AgentIdentifier aid = new AgentIdentifier(id);
    return aid;
  }

  public void setParentList(Vector stk) {
    theParentList.removeAllElements();
    if (stk == null) {
      return;
    }
    if (!(stk.isEmpty())) {
      for (int i = 0 ; i < stk.size() ; i++ ) {
	theParentList.addElement(stk.elementAt(i));
      }
    }
  }

  public boolean isInParentList(AgentIdentifier aid) {
    for (int i = 0 ; i < theParentList.size() ; i++ ) {
      if (((String)(theParentList.elementAt(i))).equals(aid.toString())) {
	return true;
      }
    }      
    return false;
  }

  public boolean hasCapability(AgentIdentifier aid) {
    if (theIdentifier.equals(aid) || isInParentList(aid)) {
      return true;
    }      
    return false;
  }

  public void setAgentLoader(AgentLoader al) {
    theLoader = al;
  }

  public String getAgentError() {
    return theError;
  }

  public void setAgentError(String status) {
    theError = status;
  }

  public String getInfoString() {
    StringBuffer sb = new StringBuffer();
    if (theName != null) {
      sb.append(theName).append(" ");
    }
    if (theIdentifier != null) {
      sb.append("("+theIdentifier+")").append(" ");
    }
    if (theStatus != null) {
      sb.append("["+theStatus+"]").append(" ");
    }
    if (thePreviousHostURL != null) {
      sb.append("from "+thePreviousHostURL).append(" ");
    }
    if (theBirthday!= null) {
      sb.append("at "+theBirthday).append(" ");
    }
    if (theOriginalHostURL != null) {
      sb.append("("+theOriginalHostURL+")").append(" ");
    }
    return sb.toString();
  }

  public Enumeration getInfoList() {
    Vector list = new Vector();
    if (theName != null) {
      list.addElement("My Name:            "+theName);
    }
    if (theStatus != null) {
      list.addElement("My Status:          "+theStatus);
    }
    if (theBirthday!= null) {
      list.addElement("Created Date:       "+theBirthday.toString());
    }
    if (theIdentifier != null) {
      list.addElement("My Identifier:      "+theIdentifier.toString());
    }
    for (int i = 0 ; i < theParentList.size() ; i++ ) {
      list.addElement("Parent ID List("+i+"):  "+
		      theParentList.elementAt(i));
    }      
    if (theCurrentHostURL != null) {
      list.addElement("Current  Host:      "+theCurrentHostURL.toString());
    }
    if (thePreviousHostURL != null) {
      list.addElement("Previous Host:      "+thePreviousHostURL.toString());
    }
    if (theOriginalHostURL != null) {
      list.addElement("Original Host:      "+theOriginalHostURL.toString());
    }
    if (theCodeBaseHostURL != null) {
      list.addElement("Codebase Host:      "+theCodeBaseHostURL.toString());
    }
    if (theCode != null) {
      list.addElement("Code Size:          "+theCode.length);
    }
    if (theAgent != null) {
      try {
	byte context[] = AgentByteCode.objectToByteArray(theAgent);
	list.addElement("Context Size:       "+context.length);      
      }
      catch(Exception e){}
    }
    Class c = null;
    try {
      c = Class.forName(theName);
    } 
    catch (ClassNotFoundException e) {}
    if (c != null && c instanceof Class) {
      AgentInspect aInspect = new AgentInspect();
      Enumeration e = (Enumeration)aInspect.getMethods(c);
      while(e.hasMoreElements()) {
	list.addElement("Public Method:      "+e.nextElement());
      }
    }
    return list.elements();
  }

  public void clearAgentInfo() {
/*
    if (theError != null) {
      return;
    }
*/
    theParentList.removeAllElements();
    theParentList = null;
    theLoader.remove();
    theLoader = null;
    theAgent = null;
    theAgentRuntime = null;
    theAgentContext = null;
    theIdentifier = null;
    theStatus = null;
    theThread = null;
    theName = null;
    theOriginalIdentifier = null;
    theBirthday = null;
    theLastModified = null;
    theOriginalHostURL = null;
    theCurrentHostURL = null;
    thePreviousHostURL = null;
    theCodeBaseHostURL = null;
    theCode = null;
    theError = null;
  }

  public String toString() {
    return ""+theIdentifier;
  }
}

