/*
 * Copyright (C) 1997 Ichiro Satoh
 * All Rights Reserved.
 * written by Ichiro Satoh
 *
 * This program was developed by Ichiro Satoh at Ochanomizu University 
 * as a part of a mobile object system, titled "AgentSpace". All the 
 * programs of the system is developed by Ichiro Satoh and all rights 
 * are reserved by Ichiro Satoh. 
 *
 * Permission to use, copy, modify and distribute this software and
 * its documentation is hereby granted, provided that both the
 * copyright notice and this permission notice appear in all copies of
 * the software, derivative works or modified versions, and any
 * portions thereof, and that both notices appear in supporting 
 * documentation.
 *
 * FREE USE OF THIS SOFTWARE IS ALLOWED IN ITS "AS IS" CONDITION.
 * BUT WITHOUT WARRANTY. THE AUTHORS DISCLAIM ANY LIABILITY OF ANY 
 * KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS 
 * SOFTWARE.
 */

package agentspace;

import java.lang.reflect.*;
import java.util.*;

public class AgentInspect {
  private Constructor cn[];
  private Class cc[];
  private Method mm[];
  private Field ff[];
  private Class c = null;
  private Class supClass;
  private String x, y, s1, s2, s3;
  private Hashtable classRef = new Hashtable();

  public AgentInspect() {}

  public Enumeration getMethods(Class c) {
    String[] result = null;
    Vector list = new Vector();
    mm = c.getDeclaredMethods();
    for (int i = 0; i < mm.length; i++) {
      String tmp = "";
      int md = mm[i].getModifiers();
      if (Modifier.PUBLIC == md) {
	tmp = tmp + typeName(mm[i].getReturnType().getName(), null)
	  +" "+mm[i].getName();
	Class cx[] = mm[i].getParameterTypes();
	tmp = tmp + "(";
	if (cx.length > 0) {
	  for (int j = 0; j < cx.length; j++) {
	    tmp = tmp + typeName(cx[j].getName(), classRef);
	    if (j < (cx.length - 1)) {
	      tmp = tmp + ", ";
	    }
	  }
	}
	tmp = tmp + ") ";
	list.addElement(tmp);
      }
    }
    return list.elements();
  }

  static String typeName(String nm, Hashtable ht) {
    String yy;
    String arr;
    if (nm.charAt(0) != '[') {
      int i = nm.lastIndexOf(".");
      if (i == -1) {
	return nm;
      }
      else {
	yy = nm.substring(i+1);
	if (ht != null) {
	  ht.put(nm, yy); // note class types in the hashtable.
	}
	return yy;
      }
    }
    arr = "[]";
    if (nm.charAt(1) == '[') {
      yy = typeName(nm.substring(1), ht);
    }
    else {
      switch (nm.charAt(1)) {
      case 'L' :
	yy = typeName(nm.substring(nm.indexOf("L")+1, nm.indexOf(";")), ht);
	break;
      case 'I':
	yy = "int";
	break;
      case 'V':
	yy = "void";
	break;
      case 'C':
	yy = "char";
	break;
      case 'D':
	yy = "double";
	break;
      case 'F':
	yy = "float";
	break;
      case 'J':
	yy = "long";
	break;
      case 'S':
	yy = "short";
	break;
      case 'Z':
	yy = "boolean";
	break;
      case 'B':
	yy = "byte";
	break;
      default:
	yy = "UNKNOWN:"+nm;
	break;
      }
    }
    return yy+arr;
  }
}
