/*
 * Copyright (C) 1997 Ichiro Satoh
 * All Rights Reserved.
 * written by Ichiro Satoh
 *
 * This program was developed by Ichiro Satoh at Ochanomizu University 
 * as a part of a mobile object system, titled "AgentSpace". All the 
 * programs of the system is developed by Ichiro Satoh and all rights 
 * are reserved by Ichiro Satoh. 
 *
 * Permission to use, copy, modify and distribute this software and
 * its documentation is hereby granted, provided that both the
 * copyright notice and this permission notice appear in all copies of
 * the software, derivative works or modified versions, and any
 * portions thereof, and that both notices appear in supporting 
 * documentation.
 *
 * FREE USE OF THIS SOFTWARE IS ALLOWED IN ITS "AS IS" CONDITION.
 * BUT WITHOUT WARRANTY. THE AUTHORS DISCLAIM ANY LIABILITY OF ANY 
 * KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS 
 * SOFTWARE.
 */

package agentspace;

import java.io.*;
import java.util.*;
import java.lang.*;
import java.net.*;

class AgentList {
  private Vector agentList;
  private AgentManager theManager;

  public AgentList() {
    agentList = new Vector();
  }

  public void setAgentManager(AgentManager am) {
    theManager = am;
  }

  public AgentInfo getAgentInfo(int loc) {
    AgentInfo ainfo = null;
    try {
      ainfo = (AgentInfo)agentList.elementAt(loc);
    }
    catch(ArrayIndexOutOfBoundsException e){}
    return ainfo;
  }

  public AgentInfo getAgentInfo(AgentIdentifier aid) {
    AgentInfo ainfo = null;
    for(int i = 0 ; i < agentList.size() ; i++ ) {
      ainfo = getAgentInfo(i);
      if (ainfo.getIdentifier().equals(aid)) {
	break;
      }
    }
    return ainfo;
  }

  public synchronized void addAgentInfo(AgentInfo ainfo) {
    if( ainfo != null ) {
      agentList.addElement(ainfo);
    }
  }

  public synchronized void removeAgentInfo(AgentInfo ainfo) {
    if( ainfo != null ) {
      agentList.removeElement(ainfo);
      ainfo.clearAgentInfo();
    }
  }

  public synchronized void removeAgentInfo(AgentIdentifier aid) {
    AgentInfo ainfo = getAgentInfo(aid);
    if( ainfo != null ) {
      removeAgentInfo(ainfo);
    }
  }

  public synchronized void removeFromAgentInfo(AgentInfo ainfo) {
    if( ainfo != null ) {
      agentList.removeElement(ainfo);
    }
  }

  public synchronized int agentInfoSize() {
    return agentList.size();
  }

  public AgentRuntime getAgentRuntime(AgentIdentifier aid) {
    AgentInfo ainfo = getAgentInfo(aid);
    if (ainfo != null) {
      return ainfo.getAgentRuntime();
    }
    return null;
  }

  public String getAgentStatus(AgentIdentifier aid) {
    AgentInfo ainfo = getAgentInfo(aid);
    if (ainfo != null) {
      return ainfo.getAgentStatus();
    }
    return null;
  }

  public String getAgentStatusString(AgentIdentifier aid) {
    AgentInfo ainfo = getAgentInfo(aid);
    if (ainfo != null) {
      return ainfo.getInfoString();
    }
    return null;
  }

  public AgentContext getAgentContext(AgentIdentifier aid) {
    AgentInfo ainfo = getAgentInfo(aid);
    if (ainfo != null) {
      return ainfo.getAgentContext();
    }
    return null;
  }
}
