/*
 * Copyright (C) 1997 Ichiro Satoh
 * All Rights Reserved.
 * written by Ichiro Satoh
 *
 * This program was developed by Ichiro Satoh at Ochanomizu University 
 * as a part of a mobile object system, titled "AgentSpace". All the 
 * programs of the system is developed by Ichiro Satoh and all rights 
 * are reserved by Ichiro Satoh. 
 *
 * Permission to use, copy, modify and distribute this software and
 * its documentation is hereby granted, provided that both the
 * copyright notice and this permission notice appear in all copies of
 * the software, derivative works or modified versions, and any
 * portions thereof, and that both notices appear in supporting 
 * documentation.
 *
 * FREE USE OF THIS SOFTWARE IS ALLOWED IN ITS "AS IS" CONDITION.
 * BUT WITHOUT WARRANTY. THE AUTHORS DISCLAIM ANY LIABILITY OF ANY 
 * KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS 
 * SOFTWARE.
 */

package agentspace;

import java.io.*;
import java.net.*;
import java.util.*;
import java.lang.*;
import java.lang.reflect.*;

public class AgentLoader {
  AgentClassLoader loader = null;
  public AgentLoader() {}
  public Object loadAgent(byte[] context, byte[] code, URL url) {
    Object obj = null;
    try {
      loader = new AgentClassLoader(url);
      loader.agentClassDataLoad(code);
      Class subClass = loader.loadClass("AgentLoaderStub.class", true);
      Object agentLauncher = newAgentLauncher(subClass, context);
      obj = invokeLoadMethod(agentLauncher);
    }
    catch (ClassNotFoundException e) {
      e.printStackTrace();
    }
    catch (Exception e) {
      e.printStackTrace();
    }
    return obj;
  }

  public void remove() {
    loader.remove();
    loader = null;
  }

  private Object newAgentLauncher(Class c, byte[] context) {
    try {
      Class[] classArgs = {context.getClass()};
      Object[] objArgs  = {context};
      Constructor cst = c.getConstructor(classArgs);
      return cst.newInstance(objArgs);
    }
    catch (NoSuchMethodException e) {
      e.printStackTrace();
    }
    catch (InstantiationException e) {
      e.printStackTrace();
    }
    catch (IllegalAccessException e) { 
      e.printStackTrace();
    }
    catch (IllegalArgumentException e) { 
      e.printStackTrace();
    }
    catch (InvocationTargetException e) { 
      e.printStackTrace();
    }
    return null;
  }

  private Object invokeLoadMethod(Object obj) {
    try {
      Object[] argObjects = {};
      Class[]  argClasses  = {};
      Method mth = obj.getClass().getMethod("load", argClasses);
      return mth.invoke(obj, (Object[])argObjects);
    }
    catch (NoSuchMethodException e) {
      e.printStackTrace();
    }
    catch (IllegalAccessException e) {
      e.printStackTrace();
    }
    catch (IllegalArgumentException e) {
      e.printStackTrace();
    }
    catch (InvocationTargetException e) {
      e.printStackTrace();
    }
    return null;
  }
}

