/*
 * Copyright (C) 1997 Ichiro Satoh
 * All Rights Reserved.
 * written by Ichiro Satoh
 *
 * This program was developed by Ichiro Satoh at Ochanomizu University 
 * as a part of a mobile object system, titled "AgentSpace". All the 
 * programs of the system is developed by Ichiro Satoh and all rights 
 * are reserved by Ichiro Satoh. 
 *
 * Permission to use, copy, modify and distribute this software and
 * its documentation is hereby granted, provided that both the
 * copyright notice and this permission notice appear in all copies of
 * the software, derivative works or modified versions, and any
 * portions thereof, and that both notices appear in supporting 
 * documentation.
 *
 * FREE USE OF THIS SOFTWARE IS ALLOWED IN ITS "AS IS" CONDITION.
 * BUT WITHOUT WARRANTY. THE AUTHORS DISCLAIM ANY LIABILITY OF ANY 
 * KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS 
 * SOFTWARE.
 */

package agentspace;

import java.io.*;
import java.util.*;
import java.lang.*;

public class AgentMessageQueue {
  protected AgentQueue queue;

  public AgentMessageQueue() {
    queue = new AgentQueue();
  }

  public void putMessage(Message msg) {
//  System.out.println("MessageQueue: putMessage()");
    showMessage("putMessage");
    queue.put(msg);
  }

  public void pushMessage(Message msg) {
//  System.out.println("MessageQueue: getMessage()");
    showMessage("getMessage");
    queue.push(msg);
  }

  public void removeMessage(Message msg) {
//  System.out.println("MessageQueue: removeMessage()");
    queue.remove(msg);
  }

  public Message getMessage() {
    return (Message)queue.get();
  }

  public String showMessage(String s) {
    String message = "";
    for (int i = 1 ; i < queue.size() ; i++ ) {
      message = message + " " + queue.show(i);
    }
//  System.out.println("MessageQueue: "+s+" "+message);
    return message;
  }

  public boolean isEmpty() {
    if (queue == null) {
      return true;
    }
    return queue.empty();
  }

  public void clear() {
    queue.removeAllElements();
    queue = null;
  }
}

