/*
 * Copyright (C) 1998 Ichiro Satoh
 * All Rights Reserved.
 * written by Ichiro Satoh
 *
 * This program was developed by Ichiro Satoh at Ochanomizu University 
 * as a part of a mobile object system, titled "AgentSpace". All the 
 * programs of the system is developed by Ichiro Satoh and all rights 
 * are reserved by Ichiro Satoh. 
 *
 * Permission to use, copy, modify and distribute this software and
 * its documentation is hereby granted, provided that both the
 * copyright notice and this permission notice appear in all copies of
 * the software, derivative works or modified versions, and any
 * portions thereof, and that both notices appear in supporting 
 * documentation.
 *
 * FREE USE OF THIS SOFTWARE IS ALLOWED IN ITS "AS IS" CONDITION.
 * BUT WITHOUT WARRANTY. THE AUTHORS DISCLAIM ANY LIABILITY OF ANY 
 * KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS 
 * SOFTWARE.
 */

package agentspace;

import java.io.*;
import java.net.*;
import java.util.*;
import java.lang.*;
import java.lang.reflect.*;

public class AgentMethod {

  public static Object invokeMethod(AgentInfo ainfo, Message msg) throws 
  NoSuchMethodException, IllegalArgumentException, 
  IllegalAccessException, InvocationTargetException {
    Object[] argObjects = new Object[msg.getArgCount()];
    Class[]  argClasses  = new Class[msg.getArgCount()];
    for (int i = 0 ; i < msg.getArgCount() ; i++ ) {
      Object obj = msg.getArg(i);
      argObjects[i] = obj;
      argClasses[i] = obj.getClass();
    }
    Agent anAgent = ainfo.getAgent();
    Method mth = anAgent.getClass().getMethod(msg.getName(), argClasses);
    Object obj = mth.invoke((Object)anAgent, (Object[])argObjects);
    return obj;
  }

  public static void isMethod(AgentInfo ainfo, Message msg) throws 
  NoSuchMethodException, IllegalArgumentException, 
  IllegalAccessException {
    if (!(isSystemMethod(msg))) {
      hasMethod(ainfo, msg);
    }
  }

  public static void hasMethod(AgentInfo ainfo, Message msg) throws 
  NoSuchMethodException, IllegalArgumentException, 
  IllegalAccessException {
    Object[] argObjects = new Object[msg.getArgCount()];
    Class[]  argClasses  = new Class[msg.getArgCount()];
    for (int i = 0 ; i < msg.getArgCount() ; i++ ) {
      Object obj = msg.getArg(i);
      argObjects[i] = obj;
      argClasses[i] = obj.getClass();
    }
    Agent anAgent = ainfo.getAgent();
    Method mth = anAgent.getClass().getMethod(msg.getName(), argClasses);
  }

  public static boolean isSystemMethod(Message msg) {
    if ((msg.getName()).equals("dispatch") && msg.getArgCount() == 1 
	&& msg.getArg(0) instanceof URL) {
      return true;
    }
    if ((msg.getName()).equals("dispatch") && msg.getArgCount() == 1 
	&& msg.getArg(0) instanceof String) {
      return true;
    }
    if ((msg.getName()).equals("destroy") && msg.getArgCount() == 0) {
      return true;
    }
    if ((msg.getName()).equals("create") && msg.getArgCount() == 1 
	&& msg.getArg(0) instanceof String) {
      return true;
    }
    if ((msg.getName()).equals("parent") && msg.getArgCount() == 1) {
      return true;
    }
    if ((msg.getName()).equals("duplicate") && msg.getArgCount() == 0) {
      return true;
    }
    if ((msg.getName()).equals("suspend")) {
      if (msg.getArgCount() == 0) {
	return true;
      }
      if (msg.getArgCount() == 1 && msg.getArg(0) instanceof String) {
	return true;
      }
    }
    return false;
  }
}

