/*
 * Copyright (C) 1997 Ichiro Satoh
 * All Rights Reserved.
 * written by Ichiro Satoh
 *
 * This program was developed by Ichiro Satoh at Ochanomizu University 
 * as a part of a mobile object system, titled "AgentSpace". All the 
 * programs of the system is developed by Ichiro Satoh and all rights 
 * are reserved by Ichiro Satoh. 
 *
 * Permission to use, copy, modify and distribute this software and
 * its documentation is hereby granted, provided that both the
 * copyright notice and this permission notice appear in all copies of
 * the software, derivative works or modified versions, and any
 * portions thereof, and that both notices appear in supporting 
 * documentation.
 *
 * FREE USE OF THIS SOFTWARE IS ALLOWED IN ITS "AS IS" CONDITION.
 * BUT WITHOUT WARRANTY. THE AUTHORS DISCLAIM ANY LIABILITY OF ANY 
 * KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS 
 * SOFTWARE.
 */

package agentspace;
import java.awt.*;
import java.awt.event.*;
import java.lang.*;
import java.io.*;
import java.net.*;
import java.util.*;

public class AgentMonitor extends Frame 
implements ActionListener, WindowListener, MouseListener, AgentListener {
  private MenuBar menuBar = new MenuBar();
  private Menu fileMenu = new Menu("File");
  private Menu contMenu = new Menu("Control");
  private Point locationPoint = null;
  private String fileName = null;
  private String dirName = null;
  private Button loadButton;
  private Button openButton;
  private Button createButton;
  private Button quitButton;
  private Button moveButton;
  private Button copyButton;
  private Button saveButton;
  private Button infoButton;
  private Button haltButton;
  private Button shutButton;
//private JButton shutButton;
  private Panel listPanel;
  private TextField nameField;
  private int currentAgentNumber = 0;
  private int listMaxNumber = 0;
  private List agentList;
  private TextField addrField;
  private TextField portField;
  private String address = AgentServer.theHost;
  private AgentManager amgr;
  private AgentList alist;
  private boolean isFront = false;
  private boolean isDialog = false;
  private PopupMenu popup;
  private Point mPoint;
  private int previousPos = -1;

  public AgentMonitor(AgentManager am, AgentList al) {
    int i;
    amgr = am;
    alist = al;

    setTitle ("Mobile Agent Monitor");	
    setLayout (new BorderLayout());
    setBackground(SystemColor.menu);
    Panel buttonPanel = new Panel();
    buttonPanel.setLayout(new BorderLayout());
    Panel leftButtonPanel = new Panel();
    leftButtonPanel.add(loadButton = new Button("Load"));
    leftButtonPanel.add(shutButton = new Button("Shutdown"));
    buttonPanel.add(leftButtonPanel,  "West");
    buttonPanel.add(new Label ("              "), "Center");
    Panel rightButtonPanel = new Panel();
    rightButtonPanel.setLayout(new FlowLayout());
    addrField= new TextField(" "+AgentServer.theHost+" ");
    addrField.setEditable(false);
    rightButtonPanel.add(new Label("Address:"), "East");
    rightButtonPanel.add(addrField);
    portField= new TextField(" "+AgentServer.theReceivePort+" ");
    portField.setEditable(false);
    rightButtonPanel.add(new Label("Port:"), "East");
    rightButtonPanel.add(portField);
    buttonPanel.add(rightButtonPanel, "East");


    Panel fieldPanel = new Panel();
    fieldPanel.setLayout (new FlowLayout());
    
    fieldPanel.add(quitButton = new Button("Stop"));
    fieldPanel.add(saveButton = new Button("Save"));
    fieldPanel.add(moveButton = new Button("Move"));
    fieldPanel.add(copyButton = new Button("Copy"));
    fieldPanel.add(infoButton = new Button("Info"));
    fieldPanel.add(haltButton = new Button("Halt"));


    agentList = new AgentMonitorList(this, 10, false);
    Font f = new Font("Courier", Font.BOLD, 12);
    agentList.setFont(f);
//  agentList.addActionListener(this);
    agentList.addMouseListener(this);    

    loadButton.enable();
    shutButton.enable();
    saveButton.disable();
    quitButton.disable();
    moveButton.disable();
    copyButton.disable();
    infoButton.disable();
    haltButton.disable();

    loadButton.addActionListener(this);
    shutButton.addActionListener(this);

    saveButton.addActionListener(this);
    quitButton.addActionListener(this);
    moveButton.addActionListener(this);
    copyButton.addActionListener(this);
    infoButton.addActionListener(this);
    haltButton.addActionListener(this);
    addMouseListener(this);    
    amgr.addAgentListener(this);

    mPoint = new Point();

    add("North",  buttonPanel);
    add("Center", agentList);
    add("South",  fieldPanel);
    addWindowListener(this);
    pack();
    show();
  }
  
  public void mouseClicked(MouseEvent e) {
    int currentPos  = agentList.getSelectedIndex();
    AgentInfo ainfo = (AgentInfo)alist.getAgentInfo(currentPos);
    update(true);
    if (ainfo != null) {
      AgentIdentifier aid = ainfo.getIdentifier();
      if (aid != null) {
	amgr.toFrontAgent(aid);
      }
    }
  }
  public void mouseEntered(MouseEvent e) {}
  public void mouseExited(MouseEvent e) {}
  public void mousePressed(MouseEvent e) {}
  public void mouseReleased(MouseEvent e) {}
  public void agentChanged(AgentEvent e) {
    update(false);
  }

  private synchronized void update(boolean flag) { 
    try {
      int currentPos = agentList.getSelectedIndex();
      int theNextPos = -1;
      String currentStatus = null;
      String previousStatus = null;
      boolean isRedraw = false;
      AgentInfo ainfo = (AgentInfo)alist.getAgentInfo(currentPos);
      if (ainfo != null) {
	currentStatus = 
	  ((AgentInfo)alist.getAgentInfo(currentPos)).getInfoString();
      }
      if (alist.agentInfoSize() >= agentList.getItemCount()) {
	for(int i = 0 ; i < agentList.countItems() ; i++ ) { 
	  ainfo = (AgentInfo)alist.getAgentInfo(i);
	  if (ainfo == null) {
	    break;
	  }
	  String status = ainfo.getInfoString();
	  if (!(status.equals(agentList.getItem(i)))) {
	    agentList.replaceItem(status, i);
	    agentList.deselect(agentList.getSelectedIndex());
	    isRedraw = true;
	  }
	  if (status.equals(currentStatus)) {
	    theNextPos = i;
	  }
	}
	for (int i = agentList.countItems(); i < alist.agentInfoSize(); i++ ){
	  ainfo = (AgentInfo)alist.getAgentInfo(i);
	  String status = ainfo.getInfoString();
	  agentList.addItem(status);
	  agentList.deselect(agentList.getSelectedIndex());
	  isRedraw = true;
	}
      }
      else {
	for(int i = 0 ; i < alist.agentInfoSize() ; i++ ){
	  ainfo = (AgentInfo)alist.getAgentInfo(i);
	  String status = ainfo.getInfoString();
	  if (!(status.equals(agentList.getItem(i)))) {
	    agentList.replaceItem(status, i);
	    agentList.deselect(agentList.getSelectedIndex());
	  }	  
	  if (status.equals(currentStatus)) {
	    theNextPos = i;
	  }
	}
	for (int i = alist.agentInfoSize(); i < agentList.countItems(); i++ ){ 
	  agentList.remove(i);
	}
	isRedraw = true;
      }
      agentList.select(theNextPos);
      updateButton();
      if (isRedraw && (!isDialog || flag || isFront)) {
	show();
      }
    }
    catch(ArrayIndexOutOfBoundsException e) {}
  }

  private void updateButton() {
    boolean changed = false;
    int currentPos  = agentList.getSelectedIndex();
    if (currentPos < 0) {
      saveButton.disable();
      quitButton.disable();
      moveButton.disable();
      copyButton.disable();
      infoButton.disable();
      haltButton.disable();
    }
    else {
      AgentInfo ainfo = alist.getAgentInfo(currentPos);
      if (ainfo != null) {
	if (ainfo.getAgentStatus() == AgentStatus.NORMAL) {
	  if(!(saveButton.isEnabled())) { changed = true; }
	  saveButton.enable();
	  if(!(quitButton.isEnabled())) { changed = true; }
	  quitButton.enable();
	  if(!(moveButton.isEnabled())) { changed = true; }
	  moveButton.enable();
	  if(!(copyButton.isEnabled())) { changed = true; }
	  copyButton.enable();
	  if(!(infoButton.isEnabled())) { changed = true; }
	  infoButton.enable();
	  haltButton.disable();
	}
	else {
	  if(saveButton.isEnabled()) { changed = true; }
	  saveButton.disable();
	  if(quitButton.isEnabled()) { changed = true; }
	  quitButton.disable();
	  if(moveButton.isEnabled()) { changed = true; }
	  moveButton.disable();
	  if(copyButton.isEnabled()) { changed = true; }
	  copyButton.disable();
	  if(infoButton.isEnabled()) { changed = true; }
	  infoButton.disable();
	  haltButton.enable();
	}
      }
      if (previousPos != currentPos || changed) {
	previousPos = currentPos;
	show();
      }
    }
  }

  public String getFileName() {
    FileDialog dialog = new FileDialog(this, "Save File", FileDialog.SAVE);
    dialog.show();
    if (dialog.getDirectory() != null && dialog.getFile() != null) {
      return dialog.getDirectory() + dialog.getFile();
    }
    else {
      return null;
    }
  }

  public String getDirectory() {
    return dirName;
  }

  public String getFile() {
    return fileName;
  }

  public String getFileName(String pattern) {
    FileDialog fd = new FileDialog(this, "Load Class");
    fd.setFile(pattern);
    fd.setDirectory( "." );
    fd.show();
    if (fd.getDirectory() != null && fd.getFile() != null) {
      fileName = fd.getFile();
      dirName  = fd.getDirectory();
      return fd.getDirectory() + fd.getFile();
    }
    else {
      return null;
    }
  }
  public void windowOpened(WindowEvent e) {
    update(false);
  }
  public void windowActivated(WindowEvent e) {
    isFront = true;
    update(true);
  }
  public void windowDeactivated(WindowEvent e) {
    isFront = false;
    update(false);
  }
  public void windowClosed(WindowEvent e) {
    isFront = false;
  }
  public void windowIconified(WindowEvent e){
    isFront = false;
  }
  public void windowDeiconified(WindowEvent e){
    isFront = false;
    update(false);
  }
  public void windowClosing(WindowEvent e){
    isFront = false;
    dispose();
    amgr.quit();
  }

  public void actionPerformed(ActionEvent e) {
    String command = e.getActionCommand();

    if (e.getID() == WindowEvent.WINDOW_CLOSING) {
      dispose();
      amgr.quit();
    }
    else if (command.equals("Load")) {
      if (getFileName( "*.agent" ) != null) {
	amgr.loadAgentFile(dirName, fileName);
      }
    } 
    else if (command.equals("Save")) {
      int i = agentList.getSelectedIndex();
      AgentInfo ainfo = (AgentInfo)alist.getAgentInfo(i);
      String newname = getFileName();
      if (newname != null) {
	AgentRuntime art = ainfo.getAgentRuntime();
	art.suspendRequest(newname);
      }
    } 
    else if (command.equals("Stop")) {
      int i = agentList.getSelectedIndex();
      AgentInfo ainfo = (AgentInfo)alist.getAgentInfo(i);
      AgentRuntime art = ainfo.getAgentRuntime();
      art.destroyRequest();
    } 
    else if (command.equals("Move")) {
      int i = agentList.getSelectedIndex();
      mPoint = moveButton.getLocationOnScreen();
      AgentInfo ainfo = (AgentInfo)alist.getAgentInfo(i);
      isDialog = true;
      AgentDestDialog ad = new AgentDestDialog(this, amgr, ainfo, mPoint);
      isDialog = false;
    } 
    else if (command.equals("Copy")) {
      int i = agentList.getSelectedIndex();
      AgentIdentifier aid = ((AgentInfo)alist.getAgentInfo(i)).getIdentifier();
      AgentInfo ainfo = (AgentInfo)alist.getAgentInfo(i);
      AgentRuntime art = ainfo.getAgentRuntime();
      art.duplicateRequest();
    } 
    else if (command.equals("Info")) {
      int i = agentList.getSelectedIndex();
      Enumeration enum = 
	(Enumeration)(((AgentInfo)alist.getAgentInfo(i)).getInfoList());
      AgentAboutDialog ad = new AgentAboutDialog(this,"Agent Infomation",enum);
    } 
    else if (command.equals("Halt")) {
      int i = agentList.getSelectedIndex();
      AgentIdentifier aid = ((AgentInfo)alist.getAgentInfo(i)).getIdentifier();
      amgr.killAgent(aid);
    } 
    else if (command.equals("Shutdown")) {
      amgr.quit();
    } 
    update(true);
    show();
  } 
}
