package agentspace;

import java.io.*;
import java.net.*;
import java.util.*;
import java.util.zip.*;
import java.lang.*;

public class AgentPacket {
  private AgentManager theAgentManager;
  private AgentIdentifier aid;
  private URL originalHost;
  private URL previousHost;
  private URL codeBaseHost;
  private Date birthDay;
  private String status;
  private byte[] code;
  private byte[] data;
  private byte[] context;

  public AgentPacket(AgentManager am) {
    theAgentManager = am;
  }

  public void clearAgentLoader() {
    aid = null;
    originalHost = null;
    previousHost = null;
    codeBaseHost = null;
    birthDay = null;
    status = null;
    code = null;
    context = null;
  }

  public void readPacket(byte[] packetData, String status, Thread thrd) {
    exteractPacket(packetData);
    System.out.println("AgentPacket: readPacket");
    Agent anAgent;
//    AgentLoader agentLoader = new AgentLoader(theAgentManager);
    AgentLoader agentLoader = new AgentLoader();
    Object obj = agentLoader.loadAgent(data, code, codeBaseHost);
    if (obj != null && obj instanceof Agent) {
      anAgent = (Agent)obj;
      AgentInfo ainfo = new AgentInfo(anAgent);
      if (status.equals(AgentStatus.PERSISTENT)) {
	System.out.println("AgentPacket: persistent");
	ainfo.setOriginalIdentifier(aid);
	aid = new AgentIdentifier();
      }
      else {
	System.out.println("AgentPacket: non persistend");
      }
      ainfo.setIdentifier(aid);
      ainfo.setOriginalHost(originalHost);
      ainfo.setPreviousHost(previousHost);
      ainfo.setCodeBaseHost(codeBaseHost);
      ainfo.setAgentStatus(status);
      ainfo.setAgentCode(code);
      ainfo.setAgentThread(thrd);
      clearAgentLoader();
      theAgentManager.registry(ainfo);
    }
  }

  public void exteractPacket(byte[] packetData) {
    try {
      ByteArrayInputStream bais = new ByteArrayInputStream(packetData);
      DataInputStream dis = new DataInputStream(bais);
      if (dis.readByte() != 'A') {System.out.println("Not Ace"); return;}
      if (dis.readByte() != 'C') {System.out.println("Not aCe"); return;}
      if (dis.readByte() != 'E') {System.out.println("Not acE"); return;}
      int datalen = dis.readInt();
      int codelen = dis.readInt();

      System.out.println("datalen = "+datalen+"  codelen = "+codelen);
/*
      data = new byte[datalen];
      code = new byte[codelen];
      dis.read(data, 0, datalen);
      dis.read(code, 0, codelen);
*/

      dis.read(data, 0, datalen);
      dis.read(code, 0, codelen);

/*
      byte datatemp[] = new byte[datalen];
      byte codetemp[] = new byte[codelen];
      dis.read(datatemp, 0, datalen);
      dis.read(codetemp, 0, codelen);
      data = new byte[datatemp.length];
      code = new byte[codetemp.length];
      System.arraycopy(datatemp, 0, data, 0, datatemp.length);      
      System.arraycopy(codetemp, 0, code, 0, codetemp.length);      
*/
      extractDataEntry(data);
      dis.close();
      bais.close();
    } 
    catch (IOException e) { 	 
      System.err.println(e); 	 
    } 
  }

  public void extractDataEntry(byte[] bytedata) {
    try {
      ByteArrayInputStream byteInStream = new ByteArrayInputStream(bytedata);
      ZipInputStream zipInStream = new ZipInputStream(byteInStream);
      ZipEntry zipEnt;
      while ((zipEnt = zipInStream.getNextEntry()) != null) {
	String entryName = zipEnt.getName();
	if (entryName.startsWith("META-INF")) {
	  continue;
	}
	else if (entryName.startsWith("AGID")) {
	  byte[] agid = toByteArray(zipInStream);
	  System.out.println("AGID: id.length = "+agid.length
			     +" AGID = "+AgentByteCode.byteArrayToString(agid));
	  long idnumber = 
	    (new Long(AgentByteCode.byteArrayToString(agid))).longValue();
	  aid = new AgentIdentifier(idnumber);
	}
	else if (entryName.startsWith("CDBS")) {
	  byte[] cdbs = toByteArray(zipInStream);
	  try {
	    codeBaseHost = new URL(AgentByteCode.byteArrayToString(cdbs));
	  }
	  catch (MalformedURLException e) {}
	  System.out.println("CDBS: length = "+cdbs.length
	     +" CDBS = "+codeBaseHost.toString());
	}
	else if (entryName.startsWith("OGHT")) {
	  byte[] oght = toByteArray(zipInStream);
	  try {
	    originalHost = new URL(AgentByteCode.byteArrayToString(oght));
	  }
	  catch (MalformedURLException e) {}
	  System.out.println("OGHT: length = "+oght.length
	     +" OGHT = "+originalHost.toString());
	}
	else if (entryName.startsWith("PVHT")) {
	  byte[] pvht = toByteArray(zipInStream);
	  try {
	    previousHost = new URL(AgentByteCode.byteArrayToString(pvht));
	  }
	  catch (MalformedURLException e) {}
	  System.out.println("PVHT: length = "+pvht.length
	     +" PVHT = "+previousHost.toString());
	}
	else if (entryName.startsWith("STAT")) {
	  byte[] stat = toByteArray(zipInStream);
	  System.out.println("STAT: length = "+stat.length
	     +" STAT = "+AgentByteCode.byteArrayToString(stat));
	  status = AgentByteCode.byteArrayToString(stat);
	}
//	else if (entryName.startsWith("BTDY")) {
//	  byte[] btdy = toByteArray(zipInStream);
//	  System.out.println("BTDY: length = "+btdy.length
//	     +" BTDY = "+AgentByteCode.byteArrayToString(btdy));
//	  birthDay = new Date(AgentByteCode.byteArrayToString(btdy));
//	}
	else if (entryName.startsWith("CNTX")) {
	  context = toByteArray(zipInStream);
	  System.out.println("CNTX: length = "+context.length);
	}
      }
      zipInStream.close();
      byteInStream.close(); 	 
    } catch (IOException e) { 	 
      System.err.println(e); 	 
    } 
  }

  public byte[] toByteArray(ZipInputStream zipInStream) {
    byte[] bytedata = null;
    try {
      ByteArrayOutputStream byteOutStream = new ByteArrayOutputStream();
      byte[] buffer = new byte[1024];
      int count;
      while ((count = zipInStream.read(buffer)) != -1) {
	byteOutStream.write(buffer, 0, count);
      }
      byte[] temp = byteOutStream.toByteArray();
      bytedata = new byte[temp.length];
      System.arraycopy(temp, 0, bytedata, 0, temp.length);
      byteOutStream.close();
    } catch (IOException e) { 	 
      System.err.println(e); 	 
    } 
    return bytedata;
  }
}
