package agentspace;

import java.lang.*;
import java.io.*;
import java.net.*;
import java.util.*;
import java.util.zip.*;

public class AgentPacketEncode {

  public static byte[] makeCodePacket(AgentInfo ainfo) {
    return ainfo.getAgentCode();
  }

  public static byte[] makeDataPacket(AgentInfo ainfo) {
    byte[] data = null;
    AgentIdentifier aid = ainfo.getIdentifier();
    try {
      ByteArrayOutputStream baos = new ByteArrayOutputStream();
      ZipOutputStream zos = new ZipOutputStream(baos);

      byte[] context = AgentByteCode.objectToByteArray(ainfo.getAgent());
      zos.putNextEntry(new ZipEntry("CNTX"));
      zos.write(context, 0, context.length);
      zos.flush();
/*
      System.out.println("Write: CNTX = "+context.length);
*/
      byte[] id = AgentByteCode.stringToByteArray(aid.toString());
      zos.putNextEntry(new ZipEntry("AGID"));
      zos.write(id, 0, id.length);
      zos.flush();
/*
      System.out.println("Write: AGID = "+id.length+" "+aid.toString());
*/
      byte[] orgHost = 
	AgentByteCode.stringToByteArray(((URL)ainfo.getOriginalHost()).toString());
      zos.putNextEntry(new ZipEntry("OGHT"));
      zos.write(orgHost, 0, orgHost.length);
      zos.flush();
/*
      System.out.println("Write: OGHT = "+orgHost.length+" "
			 +((URL)ainfo.getOriginalHost()).toString());
*/
      byte[] preHost = 
	AgentByteCode.stringToByteArray("http://"+AgentServer.theHost 
				   + ":" + AgentServer.theReceivePort);
      zos.putNextEntry(new ZipEntry("PVHT"));
      zos.write(preHost, 0, preHost.length);
      zos.flush();
/*
      System.out.println("Write: PVHT = "+preHost.length+" "
	 +"http://"+AgentServer.theHost+ ":" + AgentServer.theReceivePort);
*/
      byte[] codebase = 
	AgentByteCode.stringToByteArray(((URL)ainfo.getCodeBaseHost()).toString());
      zos.putNextEntry(new ZipEntry("CDBS"));
      zos.write(codebase, 0, codebase.length);
      zos.flush();
/*
      System.out.println("Write: CDBS = "+codebase.length+" "
			 +((URL)ainfo.getCodeBaseHost()).toString());
*/
      byte[] stat = AgentByteCode.stringToByteArray(ainfo.getAgentStatus());
      zos.putNextEntry(new ZipEntry("STAT"));
      zos.write(stat, 0, stat.length);
      zos.flush();
/*
      System.out.println("Write: STAT = "+stat.length+" "
			 +ainfo.getAgentStatus());
*/

      byte[] prnt = AgentByteCode.objectToByteArray(ainfo.getParentList());
      zos.putNextEntry(new ZipEntry("PRNT"));
      zos.write(prnt, 0, prnt.length);
      zos.flush();
/*
      System.out.println("Write: PRNT = "+prnt.length+" "+parentList);
*/
      byte[] name = AgentByteCode.stringToByteArray(ainfo.getName());
      zos.putNextEntry(new ZipEntry("NAME"));
      zos.write(name, 0, name.length);
      zos.flush();
/*
      System.out.println("Write: NAME = "+name.length+" "
			 +ainfo.getName());
*/
      System.out.println("Write: AGID = "+aid.toString()
			 +",  NAME = "+ainfo.getName()
			 +",  STAT = "+ainfo.getAgentStatus());

//      byte[] birthday = 
//	AgentByteCode.stringToByteArray(((Date)ainfo.getBirthday()).toString());
//      zos.putNextEntry(new ZipEntry("BTDY"));
//      zos.write(birthday, 0, birthday.length);

      zos.flush();
      zos.close();

      data = baos.toByteArray();

//      byte[] temp = baos.toByteArray();
//      data = new byte[temp.length];
//      System.arraycopy(temp, 0, data, 0, temp.length);

      baos.close();
    } 
    catch (IOException e) { 	 
      System.err.println(e); 	 
    } 
    return data;
  }
}


